/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.handler;

import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.ItemStackHandler;

public class QuiverHandler
implements INBTSerializable<NBTTagCompound> {
    private ItemStack quiver;
    private ItemStackHandler handler = new ItemStackHandler(6){

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof ItemArrow;
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            QuiverHandler.this.saveToStack();
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            super.setStackInSlot(slot, stack);
            QuiverHandler.this.saveToStack();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack result = super.insertItem(slot, stack, simulate);
            if (!simulate) {
                QuiverHandler.this.saveToStack();
            }
            return result;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack result = super.extractItem(slot, amount, simulate);
            if (!simulate) {
                QuiverHandler.this.saveToStack();
            }
            return result;
        }
    };

    public QuiverHandler(ItemStack quiver) {
        this.quiver = quiver;
    }

    public NBTTagCompound serializeNBT() {
        return this.handler.serializeNBT();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.handler.deserializeNBT(nbt);
    }

    public ItemStackHandler getInventory() {
        return this.handler;
    }

    public static QuiverHandler getHandler(ItemStack stack) {
        QuiverHandler handler = new QuiverHandler(stack);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("quiver")) {
            handler.deserializeNBT(stack.func_77978_p().func_74775_l("quiver"));
        }
        return handler;
    }

    public boolean canConsume() {
        for (int i = 0; i < 6; ++i) {
            ItemStack stack = this.handler.getStackInSlot(i);
            if (stack.func_190926_b()) {
                return true;
            }
            if (stack.func_77973_b() != Items.field_151032_g || stack.func_190916_E() >= stack.func_77976_d()) continue;
            return true;
        }
        return false;
    }

    public void saveToStack() {
        NBTTagCompound tag = this.quiver.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            this.quiver.func_77982_d(tag);
        }
        tag.func_74782_a("quiver", (NBTBase)this.serializeNBT());
    }
}

