/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.roots.entity.ritual;

import epicsquid.mysticallib.network.PacketHandler;
import epicsquid.mysticallib.util.Util;
import epicsquid.roots.entity.ritual.EntityRitualBase;
import epicsquid.roots.init.ModBlocks;
import epicsquid.roots.network.fx.MessageRampantLifeInfusionFX;
import epicsquid.roots.particle.ParticleUtil;
import epicsquid.roots.ritual.RitualRegistry;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockNetherWart;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityRitualGermination
extends EntityRitualBase {
    protected static final DataParameter<Integer> lifetime = EntityDataManager.func_187226_a(EntityRitualGermination.class, (DataSerializer)DataSerializers.field_187192_b);
    private static List<Block> skips = Arrays.asList(Blocks.field_150349_c, Blocks.field_150329_H, Blocks.field_150398_cm);

    public EntityRitualGermination(World worldIn) {
        super(worldIn);
        this.func_184212_Q().func_187214_a(lifetime, (Object)(RitualRegistry.ritual_natural_aura.getDuration() + 20));
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        float alpha = (float)Math.min(40, RitualRegistry.ritual_life.getDuration() + 20 - (Integer)this.func_184212_Q().func_187225_a(lifetime)) / 40.0f;
        this.func_184212_Q().func_187227_b(lifetime, (Object)((Integer)this.func_184212_Q().func_187225_a(lifetime) - 1));
        this.func_184212_Q().func_187217_b(lifetime);
        if ((Integer)this.func_184212_Q().func_187225_a(lifetime) < 0) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && (Integer)this.func_184212_Q().func_187225_a(lifetime) > 0) {
            ParticleUtil.spawnParticleStar(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 0.0f, 0.0f, 0.0f, 100.0f, 255.0f, 100.0f, 0.5f * alpha, 20.0f, 40);
            if (this.field_70146_Z.nextInt(5) == 0) {
                ParticleUtil.spawnParticleSpark(this.field_70170_p, (float)this.field_70165_t, (float)this.field_70163_u, (float)this.field_70161_v, 0.125f * (this.field_70146_Z.nextFloat() - 0.5f), 0.0625f * this.field_70146_Z.nextFloat(), 0.125f * (this.field_70146_Z.nextFloat() - 0.5f), 100.0f, 255.0f, 100.0f, 1.0f * alpha, 1.0f + this.field_70146_Z.nextFloat(), 160);
            }
            for (float i = 0.0f; i < 360.0f; i += 72.0f) {
                double ang = this.field_70173_aa % 360;
                float tx = (float)this.field_70165_t + 1.0f * (float)Math.sin(Math.toRadians((double)i + ang));
                float ty = (float)this.field_70163_u;
                float tz = (float)this.field_70161_v + 1.0f * (float)Math.cos(Math.toRadians((double)i + ang));
                ParticleUtil.spawnParticleGlow(this.field_70170_p, tx, ty, tz, 0.0f, 0.0f, 0.0f, 100.0f, 255.0f, 100.0f, 0.5f * alpha, 8.0f, 40);
            }
        }
        if (this.field_70173_aa % 100 == 0) {
            List positions = Util.getBlocksWithinRadius((World)this.field_70170_p, (BlockPos)this.func_180425_c(), (float)19.0f, (float)19.0f, (float)19.0f, pos -> {
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                if (state.func_177230_c() instanceof IGrowable) {
                    Block block = state.func_177230_c();
                    if (skips.contains(block)) {
                        return false;
                    }
                    if (state.func_177230_c() instanceof BlockFlower) {
                        return false;
                    }
                    return ((IGrowable)state.func_177230_c()).func_176473_a(this.field_70170_p, pos, state, false);
                }
                if (state.func_177230_c() == Blocks.field_150388_bm) {
                    return (Integer)state.func_177229_b((IProperty)BlockNetherWart.field_176486_a) < 3;
                }
                if (state.func_177230_c() instanceof BlockSapling) {
                    return true;
                }
                return state.func_177230_c() == ModBlocks.wildwood_sapling;
            });
            if (positions.isEmpty()) {
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                BlockPos pos2 = (BlockPos)positions.get(this.field_70170_p.field_73012_v.nextInt(positions.size()));
                IBlockState state = this.field_70170_p.func_180495_p(pos2);
                for (int j = 0; j < 3; ++j) {
                    state.func_177230_c().func_180645_a(this.field_70170_p, pos2, state, this.field_70170_p.field_73012_v);
                }
                PacketHandler.sendToAllTracking((IMessage)new MessageRampantLifeInfusionFX(pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p()), (Entity)this);
            }
        }
    }

    @Override
    public DataParameter<Integer> getLifetime() {
        return lifetime;
    }
}

