/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.proxy;

import java.awt.Color;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEndRod;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import shadows.placebo.client.IHasModel;
import shadows.plants2.Plants2;
import shadows.plants2.client.ActualFlowerpotModel;
import shadows.plants2.client.ActualJarModel;
import shadows.plants2.client.FlowerpotModel;
import shadows.plants2.client.JarItemModel;
import shadows.plants2.client.JarModel;
import shadows.plants2.init.ModRegistry;
import shadows.plants2.proxy.IProxy;
import shadows.plants2.tile.TileBrewingCauldron;
import shadows.plants2.tile.TileFlowerpot;
import shadows.plants2.util.ColorToPotionUtil;

public class ClientProxy
implements IProxy {
    public static boolean aoConstant = true;
    public static final int GROUND_COLOR = 10734583;
    public static final int BLUE = 4671999;
    public static TextureAtlasSprite whiteFlame;
    public static final Color WATER;

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        aoConstant = ForgeModContainer.forgeLightPipelineEnabled && !Loader.isModLoaded((String)"optifine");
    }

    @Override
    public void init(FMLInitializationEvent e) {
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, world, pos, tint) -> {
            if (tint != 1) {
                return -1;
            }
            TileEntity t = world.func_175625_s(pos);
            if (!(t instanceof TileBrewingCauldron)) {
                return -1;
            }
            TileBrewingCauldron caul = (TileBrewingCauldron)t;
            int color = ColorToPotionUtil.getColorMultiplier(caul.getColors(), caul.hasFirstWart());
            return color == -1 ? 4671999 : color;
        }, new Block[]{ModRegistry.BREWING_CAULDRON});
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, world, pos, tint) -> 10734583, new Block[]{ModRegistry.GROUNDCOVER});
        Minecraft.func_71410_x().getItemColors().func_186731_a((stack, tint) -> 10734583, new Block[]{ModRegistry.GROUNDCOVER});
        IBlockColor color = (state, world, pos, tint) -> {
            TileEntity tileentity;
            if (world != null && pos != null && (tileentity = world.func_175625_s(pos)) instanceof TileFlowerpot && ((TileFlowerpot)tileentity).getState().func_177230_c() != state.func_177230_c()) {
                Item item = ((TileFlowerpot)tileentity).func_145965_a();
                IBlockState iblockstate = Block.func_149634_a((Item)item).func_176223_P();
                return Minecraft.func_71410_x().func_184125_al().func_186724_a(iblockstate, world, pos, tint);
            }
            return -1;
        };
        Map blockBois = (Map)ReflectionHelper.getPrivateValue(BlockColors.class, (Object)Minecraft.func_71410_x().func_184125_al(), (String[])new String[]{"blockColorMap"});
        blockBois.put(Blocks.field_150457_bL.delegate, color);
        blockBois.put(ModRegistry.JAR.delegate, color);
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        ModelResourceLocation mrl2 = new ModelResourceLocation(new ResourceLocation("plants2", "flowerpot"), "cactus");
        ActualFlowerpotModel.MODELS.put(Blocks.field_150434_aF.func_176223_P(), Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174953_a(mrl2));
    }

    @SubscribeEvent
    public void onModelRegister(ModelRegistryEvent e) {
        for (Block b : Plants2.INFO.getBlockList()) {
            if (!(b instanceof IHasModel)) continue;
            ((IHasModel)b).initModels(e);
        }
        for (Item i : Plants2.INFO.getItemList()) {
            if (!(i instanceof IHasModel)) continue;
            ((IHasModel)i).initModels(e);
        }
    }

    @SubscribeEvent
    public void onModelBake(ModelBakeEvent e) {
        ModelResourceLocation mrl = new ModelResourceLocation(new ResourceLocation("plants2", "flowerpot"), "normal");
        FlowerpotModel.flowerpot = (IBakedModel)e.getModelRegistry().func_82594_a((Object)mrl);
        e.getModelRegistry().func_82595_a((Object)mrl, (Object)new ActualFlowerpotModel());
        ModelResourceLocation normal = new ModelResourceLocation(new ResourceLocation("plants2", "jar"), "normal");
        ModelResourceLocation glass = new ModelResourceLocation(new ResourceLocation("plants2", "jar"), "glass");
        ModelResourceLocation inv = new ModelResourceLocation(new ResourceLocation("plants2", "jar"), "inventory");
        JarModel.jarSolid = (IBakedModel)e.getModelRegistry().func_82594_a((Object)normal);
        JarModel.jarGlass = (IBakedModel)e.getModelRegistry().func_82594_a((Object)glass);
        e.getModelRegistry().func_82595_a((Object)normal, (Object)new ActualJarModel());
        e.getModelRegistry().func_82595_a((Object)inv, (Object)new JarItemModel());
    }

    @SubscribeEvent
    public void onTexStitch(TextureStitchEvent e) {
        whiteFlame = e.getMap().func_174942_a(new ResourceLocation("plants2", "particles/white_flame"));
    }

    @Override
    public void doCauldronParticles(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileBrewingCauldron) {
            TileBrewingCauldron caul = (TileBrewingCauldron)t;
            if (!caul.hasMaxWater() && !caul.isBeingExtracted()) {
                return;
            }
            int color = ColorToPotionUtil.getColorMultiplier(caul.getColors(), caul.hasFirstWart());
            if (color == -1) {
                color = WATER.getRGB();
            }
            for (int i = 0; i < rand.nextInt(ClientProxy.getLastNonNull(caul.getColors()) * 5 + 4); ++i) {
                ParticleEndRod p = new ParticleEndRod(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.8, (double)pos.func_177952_p() + 0.5, MathHelper.func_82716_a((Random)rand, (double)-0.05, (double)0.05), ClientProxy.getLastNonNull(caul.getColors()) == 6 ? 0.3 : 0.08, MathHelper.func_82716_a((Random)rand, (double)-0.05, (double)0.05));
                p.func_187146_c(color);
                p.func_187145_d(color);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)p);
            }
        }
    }

    @Override
    public void doCauldronInputParticles(BlockPos pos) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Random rand = world.field_73012_v;
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileBrewingCauldron) {
            TileBrewingCauldron caul = (TileBrewingCauldron)t;
            int color = ColorToPotionUtil.getColorMultiplier(caul.getColors(), caul.hasFirstWart());
            if (color == -1) {
                color = WATER.getRGB();
            }
            for (int i = 0; i < 30; ++i) {
                ParticleEndRod p = new ParticleEndRod((World)world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.8, (double)pos.func_177952_p() + 0.5, MathHelper.func_82716_a((Random)rand, (double)-0.1, (double)0.1), 0.12, MathHelper.func_82716_a((Random)rand, (double)-0.1, (double)0.1));
                p.func_187146_c(color);
                p.func_187145_d(color);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)p);
            }
        }
    }

    private static int getLastNonNull(Object[] array) {
        int j = array.length;
        for (int i = 0; i < j; ++i) {
            if (array[i] != null) continue;
            j = i;
            break;
        }
        return j;
    }

    static {
        WATER = new Color(48, 69, 244);
    }
}

