/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import shadows.placebo.Placebo;
import shadows.placebo.interfaces.IHarvestableEnum;
import shadows.placebo.interfaces.IPropertyEnum;
import shadows.placebo.util.PlaceboUtil;
import shadows.placebo.util.StackPrimer;
import shadows.plants2.block.BlockEnumBush;
import shadows.plants2.data.PlantConfig;
import shadows.plants2.data.PlantConstants;
import shadows.plants2.util.PlantUtil;

public class BlockEnumHarvestBush<E extends Enum<E>>
extends BlockEnumBush<E>
implements IGrowable {
    public static final PropertyBool FRUIT = PropertyBool.func_177716_a((String)"fruit");

    public BlockEnumHarvestBush(String name, EnumPlantType type, Class<E> enumClass, int predicate) {
        super(name, type, enumClass, predicate);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(false)));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && this.func_176473_a(world, pos, state, false)) {
            boolean couldGrow;
            boolean bl = couldGrow = rand.nextInt(PlantConfig.harvestGrowthChance) == 0;
            if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (boolean)couldGrow)) {
                this.func_176474_b(world, rand, pos, state);
                ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
            }
        }
    }

    @Override
    public void initModels(ModelRegistryEvent e) {
        for (int i = 0; i < this.types.size(); ++i) {
            PlaceboUtil.sMRL((String)"harvestables", (Block)this, (int)i, (String)("fruit=true,inventory=true," + this.property.func_177701_a() + "=" + ((IPropertyEnum)((Enum)this.types.get(i))).func_176610_l()));
        }
        Placebo.PROXY.useRenamedMapper((Block)this, "harvestables");
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!PlantConfig.harvests || !((Boolean)state.func_177229_b((IProperty)FRUIT)).booleanValue()) {
            return false;
        }
        for (StackPrimer s : ((IHarvestableEnum)((Enum)((Object)state.func_177229_b((IProperty)this.property)))).getDrops()) {
            ItemStack iS = s.genStack();
            if (player.func_191521_c(iS) || world.field_72995_K) continue;
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)iS);
        }
        world.func_175656_a(pos, state.func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(false)));
        return true;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        int k = meta % 2;
        if (k == 0) {
            return this.func_176223_P().func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)this.property, (Comparable)this.types.get(BlockEnumHarvestBush.getActualMeta(meta)));
        }
        if (k == 1) {
            return this.func_176223_P().func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)this.property, (Comparable)this.types.get(BlockEnumHarvestBush.getActualMeta(meta)));
        }
        return null;
    }

    public static int getActualMeta(int meta) {
        int k = meta % 2;
        float j = (float)meta / 2.0f;
        if (k == 0) {
            return (int)j;
        }
        if (k == 1) {
            return (int)((double)j - 0.5);
        }
        return 0;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        boolean k = (Boolean)state.func_177229_b((IProperty)FRUIT);
        int j = ((Enum)((Object)state.func_177229_b((IProperty)this.property))).ordinal() % 8;
        if (k) {
            return j * 2;
        }
        if (!k) {
            return 1 + j * 2;
        }
        return 0;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return ((IHarvestableEnum)((Enum)((Object)state.func_177229_b((IProperty)this.property)))).getMetadata();
    }

    @Override
    public BlockStateContainer createStateContainer() {
        return new BlockStateContainer((Block)this, new IProperty[]{PlantConstants.INV, this.property, FRUIT});
    }

    @Override
    public List<ItemStack> getActualDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List<ItemStack> drops = super.getActualDrops(world, pos, state, fortune);
        if (PlantConfig.harvests && ((Boolean)state.func_177229_b((IProperty)FRUIT)).booleanValue()) {
            for (StackPrimer s : ((IHarvestableEnum)((Enum)((Object)state.func_177229_b((IProperty)this.property)))).getDrops()) {
                drops.add(s.genStack());
            }
        }
        return drops;
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return (Boolean)state.func_177229_b((IProperty)FRUIT) == false;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return this.func_176473_a(world, pos, state, false);
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected int getMaxEnumValues() {
        return 8;
    }

    @Override
    protected void addStatesToList() {
        List<IBlockState> list = PlantUtil.TYPE_TO_STATES.get(this.type);
        for (Enum e : this.types) {
            list.add(this.getStateFor(e).func_177226_a((IProperty)FRUIT, (Comparable)Boolean.valueOf(true)));
        }
    }

    public StackPrimer[] getFruit(IBlockState state) {
        return ((IHarvestableEnum)((Enum)((Object)state.func_177229_b((IProperty)this.property)))).getDrops();
    }
}

