/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.rwtema.careerbees.effects.EffectBase;
import com.rwtema.careerbees.effects.ISpecialBeeEffect;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EffectPower
extends EffectBase
implements ISpecialBeeEffect.SpecialEffectBlock {
    public static final EffectPower INSTANCE = new EffectPower("rf");

    public EffectPower(String rawname) {
        super(rawname);
    }

    public EffectPower(String rawname, boolean isDominant, boolean isCombinable) {
        super(rawname, isDominant, isCombinable);
    }

    @Override
    @Nonnull
    public IEffectData doEffectBase(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, IEffectSettingsHolder settings) {
        int rfrate = this.getRFRate(genome, housing);
        TileEntity entity = housing.getWorldObj().func_175625_s(housing.getCoordinates());
        if (!(entity instanceof IBeeHousing)) {
            return storedData;
        }
        IBeeHousing beeHousingTile = (IBeeHousing)entity;
        if (beeHousingTile.getBeeInventory() != housing.getBeeInventory()) {
            return storedData;
        }
        int energyleft = rfrate;
        for (BlockPos pos : this.getAdjacentTiles(housing)) {
            IEnergyStorage energyStorage;
            World world = housing.getWorldObj();
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity == null || (energyStorage = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, null)) == null || (energyleft -= energyStorage.receiveEnergy(energyleft, false)) > 0) continue;
            break;
        }
        return storedData;
    }

    public int getRFRate(@Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        float speed = EffectPower.getSpeed(genome, housing);
        return MathHelper.func_76123_f((float)(400.0f * speed * speed));
    }

    @Override
    public boolean canHandleBlock(World world, BlockPos pos, @Nonnull IBeeGenome genome, EnumFacing sideHit) {
        TileEntity tile = world.func_175625_s(pos);
        return tile != null && tile.hasCapability(CapabilityEnergy.ENERGY, null);
    }

    @Override
    public float getCooldown(IBeeGenome genome, Random random) {
        return Math.min(120, genome.getLifespan()) * 2 * 6;
    }

    @Override
    public void processingTick(World world, BlockPos pos, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing, EnumFacing facing) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null || !tile.hasCapability(CapabilityEnergy.ENERGY, null)) {
            return;
        }
        IEnergyStorage storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, null);
        if (storage != null) {
            int rfRate = this.getRFRate(genome, housing);
            storage.receiveEnergy(rfRate, false);
        }
    }

    @Override
    public boolean handleBlock(@Nonnull World world, @Nonnull BlockPos pos, EnumFacing facing, @Nonnull IBeeGenome genome, @Nonnull IBeeHousing housing) {
        return true;
    }
}

