/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.google.common.collect.Lists;
import com.rwtema.careerbees.effects.EffectBase;
import com.rwtema.careerbees.effects.settings.IEffectSettingsHolder;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EffectJazz
extends EffectBase {
    public static final EffectBase INSTANCE = new EffectJazz("jazz");
    private static final List<SoundEvent> INSTRUMENTS = Lists.newArrayList((Object[])new SoundEvent[]{SoundEvents.field_187682_dG, SoundEvents.field_187676_dE, SoundEvents.field_187688_dI, SoundEvents.field_187685_dH, SoundEvents.field_187679_dF, SoundEvents.field_193809_ey, SoundEvents.field_193807_ew, SoundEvents.field_193810_ez, SoundEvents.field_193808_ex, SoundEvents.field_193785_eE});
    int time;

    public EffectJazz(String rawname) {
        super(rawname);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isValidSpecies(IAlleleBeeSpecies species) {
        return true;
    }

    @SubscribeEvent
    public void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ++this.time;
        }
    }

    @Override
    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public IEffectData doFX(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing) {
        World worldIn = housing.getWorldObj();
        BlockPos pos = housing.getCoordinates();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        Vec3d territory = EffectJazz.getTerritory(genome, housing).func_186678_a(0.5);
        Random random = new Random();
        int time = this.time / 4;
        random.setSeed((long)(time / 120) + MathHelper.func_180186_a((Vec3i)housing.getCoordinates()));
        if (worldIn.field_73012_v.nextInt(2) != 0) {
            return super.doFX(genome, storedData, housing);
        }
        random.setSeed(time / 10);
        int param = EffectJazz.getRand(random.nextInt(24), random.nextInt(24), worldIn.field_73012_v);
        NoteBlockEvent.Play e = new NoteBlockEvent.Play(worldIn, pos, worldIn.func_180495_p(pos), param, 0);
        if (!MinecraftForge.EVENT_BUS.post((Event)e)) {
            param = e.getVanillaNoteId();
            float f = (float)Math.pow(2.0, (double)(param - 12) / 12.0);
            SoundEvent blockNoteGuitar = SoundEvents.field_193810_ez;
            worldIn.func_175688_a(EnumParticleTypes.NOTE, (double)pos.func_177958_n() + worldIn.field_73012_v.nextDouble(), (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + worldIn.field_73012_v.nextDouble(), (double)param / 24.0, 0.0, 0.0, new int[0]);
            float volume = 3.0f;
            for (int i = 0; i < 10; ++i) {
                territory = territory.func_186678_a(1.3);
                volume = (float)((double)volume * 0.6666666666666666);
                AxisAlignedBB bounds = new AxisAlignedBB(housing.getCoordinates()).func_72314_b(territory.field_72450_a, territory.field_72448_b, territory.field_72449_c);
                if (!bounds.func_72326_a(player.func_174813_aQ())) continue;
                worldIn.func_184133_a((EntityPlayer)player, pos, blockNoteGuitar, SoundCategory.RECORDS, volume, f);
                break;
            }
        }
        return super.doFX(genome, storedData, housing);
    }

    @Override
    @Nonnull
    public IEffectData doEffectBase(@Nonnull IBeeGenome genome, @Nonnull IEffectData storedData, @Nonnull IBeeHousing housing, IEffectSettingsHolder settings) {
        return storedData;
    }
}

