/*
 * Decompiled with CFR 0.152.
 */
package com.ezrol.terry.minecraft.defaultworldgenerator;

import com.ezrol.terry.minecraft.defaultworldgenerator.CommonProxy;
import com.ezrol.terry.minecraft.defaultworldgenerator.DefaultWorldGenerator;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.BooleanTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.QuadStateTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.StringTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.UuidTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.config.WorldTypeNode;
import com.ezrol.terry.minecraft.defaultworldgenerator.lib.Log;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.PendingCommand;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.server.FMLServerHandler;

public class ServerProxy
extends CommonProxy {
    @Override
    public void postInit(FMLPostInitializationEvent event) {
        if (event.getSide() == Side.SERVER) {
            Log.info("Injecting Server Defaults");
            MinecraftServer s = FMLServerHandler.instance().getServer();
            if (s.func_71262_S()) {
                DedicatedServer server = (DedicatedServer)s;
                UUID type = null;
                try {
                    type = UUID.fromString(server.func_71330_a("defaultworldgenerator-port", ""));
                }
                catch (Exception e) {
                    Log.info("Default World Type UUID not set in server.properties");
                }
                String levelName = server.func_71330_a("level-name", "world");
                File levelDir = new File(levelName);
                File levelData = new File(levelDir, "level.dat");
                if (!levelDir.isDirectory() || !levelData.isFile()) {
                    QuadStateTypeNode.States state;
                    Log.info("World Type missing find default or ask user");
                    WorldTypeNode config = this.getWorldConfig(type, server);
                    Log.info("Updating server.properties");
                    server.func_71328_a("level-type", (Object)((StringTypeNode)config.getField(WorldTypeNode.Fields.WORLD_GENERATOR)).getValue());
                    server.func_71328_a("generator-settings", (Object)((StringTypeNode)config.getField(WorldTypeNode.Fields.CUSTOMIZATION_STRING)).getValue());
                    if (!((StringTypeNode)config.getField(WorldTypeNode.Fields.SEED)).getValue().equals("")) {
                        server.func_71328_a("level-seed", (Object)((StringTypeNode)config.getField(WorldTypeNode.Fields.SEED)).getValue());
                    }
                    if ((state = ((QuadStateTypeNode)config.getField(WorldTypeNode.Fields.BONUS_CHEST_STATE)).getValue()) == QuadStateTypeNode.States.STATE_ENABLED || state == QuadStateTypeNode.States.STATE_FORCED) {
                        server.func_71194_c(true);
                    }
                    if ((state = ((QuadStateTypeNode)config.getField(WorldTypeNode.Fields.STRUCTURE_STATE)).getValue()) == QuadStateTypeNode.States.STATE_ENABLED || state == QuadStateTypeNode.States.STATE_FORCED) {
                        server.func_71328_a("generate-structures", (Object)true);
                    } else {
                        server.func_71328_a("generate-structures", (Object)false);
                    }
                    DefaultWorldGenerator.selectedLevel = config;
                } else {
                    Log.info("World exists, not updating server.properties");
                }
            }
        }
    }

    public WorldTypeNode getWorldConfig(UUID type, DedicatedServer server) {
        HashMap<UUID, WorldTypeNode> possibleNodes = new HashMap<UUID, WorldTypeNode>();
        LinkedList<Object> DisplayOrder = new LinkedList<Object>();
        WorldTypeNode first = null;
        boolean usePrimary = true;
        for (WorldTypeNode n : DefaultWorldGenerator.modConfig.getSettings().getWorldList()) {
            UUID key = ((UuidTypeNode)n.getField(WorldTypeNode.Fields.UUID)).getValue();
            possibleNodes.put(key, n);
            if (first == null) {
                first = n;
            }
            if (!((BooleanTypeNode)n.getField(WorldTypeNode.Fields.SHOW_IN_LIST)).getValue()) continue;
            usePrimary = false;
            DisplayOrder.add(key);
        }
        if (type != null && possibleNodes.containsKey(type)) {
            return (WorldTypeNode)possibleNodes.get(type);
        }
        if (usePrimary) {
            return first;
        }
        StringBuilder prompt = new StringBuilder();
        prompt.append("\n\nChoose A default world type:\n\n");
        int i = 0;
        for (UUID uUID : DisplayOrder) {
            prompt.append(++i);
            prompt.append(") ");
            prompt.append(((StringTypeNode)((WorldTypeNode)possibleNodes.get(uUID)).getField(WorldTypeNode.Fields.CONFIGURATION_NAME)).getValue());
            prompt.append("   [");
            prompt.append(uUID);
            prompt.append("]\n");
        }
        prompt.append("\n");
        prompt.append("Type \"/defaultworldgenerator-port <the number for the server's worldtype>\n");
        prompt.append("Alternativly add the uuid as the value of \"defaultworldgenerator-port\" in server.properties");
        prompt.append("\n\n");
        try {
            int idx = Integer.parseInt(this.queryUser(prompt.toString(), server)) - 1;
            if (idx < 0 || idx >= DisplayOrder.size()) {
                throw new InvalidWorldTypeException("Invalid Selection");
            }
            return (WorldTypeNode)possibleNodes.get(DisplayOrder.get(idx));
        }
        catch (InterruptedException e) {
            throw new InvalidWorldTypeException("User Prompt was interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryUser(String text, DedicatedServer server) throws InterruptedException {
        String retval = "";
        String commandPrefix = "/defaultworldgenerator-port ";
        Log.warn(text);
        boolean done = false;
        while (!done && server.func_71278_l()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            List list = server.field_71341_l;
            synchronized (list) {
                Iterator it = server.field_71341_l.iterator();
                while (it.hasNext()) {
                    String cmd = ((PendingCommand)it.next()).field_73702_a.trim().toLowerCase();
                    if (cmd.startsWith(commandPrefix)) {
                        retval = cmd.substring(commandPrefix.length()).trim();
                        done = true;
                        it.remove();
                        continue;
                    }
                    if (!cmd.equals("/stop")) continue;
                    throw new InvalidWorldTypeException("Stopping per user request");
                }
            }
            Thread.sleep(10L);
        }
        return retval;
    }

    @Override
    public void wrongServerMode(String newMode) {
        FMLCommonHandler.instance().raiseException((Throwable)new RuntimeException("Restart Required (to change pack mode)"), "Pack mode set to: " + newMode + "\nPlease restart the Minecraft server", true);
    }

    public static class InvalidWorldTypeException
    extends RuntimeException {
        public InvalidWorldTypeException(String message) {
            super(message);
        }
    }
}

