/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.world;

import com.teamwizardry.librarianlib.features.base.block.BlockModSapling;
import com.teamwizardry.wizardry.init.ModBlocks;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;

public class WorldGeneratorWisdomTree
extends WorldGenAbstractTree {
    private static final IBlockState LOG = ModBlocks.WISDOM_WOOD_LOG.func_176223_P();
    private static final IBlockState LEAF = ModBlocks.WISDOM_LEAVES.func_176223_P();

    public WorldGeneratorWisdomTree(boolean notify) {
        super(notify);
    }

    public boolean func_180709_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos position) {
        int height = rand.nextInt(5) + 5;
        boolean canFit = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + height + 1 <= 256) {
            for (int currentY = position.func_177956_o(); currentY <= position.func_177956_o() + 1 + height; ++currentY) {
                int leafWidth = 0;
                if (currentY >= position.func_177956_o() + height / 2) {
                    leafWidth = 2;
                }
                if (currentY >= position.func_177956_o() + height - 2) {
                    leafWidth = 1;
                }
                BlockPos.MutableBlockPos poses = new BlockPos.MutableBlockPos();
                for (int searchX = position.func_177958_n() - leafWidth; searchX <= position.func_177958_n() + leafWidth && canFit; ++searchX) {
                    for (int searchZ = position.func_177952_p() - leafWidth; searchZ <= position.func_177952_p() + leafWidth && canFit; ++searchZ) {
                        if (currentY >= 0 && currentY < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)poses.func_181079_c(searchX, currentY, searchZ)) || worldIn.func_180495_p((BlockPos)poses.func_181079_c(searchX, currentY, searchZ)).func_177230_c().func_176200_f((IBlockAccess)worldIn, (BlockPos)poses.func_181079_c(searchX, currentY, searchZ))) continue;
                            canFit = false;
                            continue;
                        }
                        canFit = false;
                    }
                }
            }
            if (!canFit) {
                return false;
            }
            BlockPos down = position.func_177977_b();
            IBlockState state = worldIn.func_180495_p(down);
            boolean isSoil = state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, down, EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g));
            if (isSoil && position.func_177956_o() < worldIn.func_72800_K() - height - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, down, position);
                for (int i2 = position.func_177956_o() - 3 + height; i2 <= position.func_177956_o() + height; ++i2) {
                    int k2 = i2 - (position.func_177956_o() + height);
                    int l2 = 1 - k2 / 2;
                    for (int i3 = position.func_177958_n() - l2; i3 <= position.func_177958_n() + l2; ++i3) {
                        int j1 = i3 - position.func_177958_n();
                        for (int k1 = position.func_177952_p() - l2; k1 <= position.func_177952_p() + l2; ++k1) {
                            BlockPos blockpos;
                            IBlockState state2;
                            int l1 = k1 - position.func_177952_p();
                            if (Math.abs(j1) == l2 && Math.abs(l1) == l2 && (rand.nextInt(2) == 0 || k2 == 0) || !(state2 = worldIn.func_180495_p(blockpos = new BlockPos(i3, i2, k1))).func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos) && !state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, blockpos)) continue;
                            this.func_175903_a(worldIn, blockpos, LEAF);
                        }
                    }
                }
                for (int j2 = 0; j2 < height; ++j2) {
                    BlockPos upN = position.func_177981_b(j2);
                    IBlockState state2 = worldIn.func_180495_p(upN);
                    if (!state2.func_177230_c().isAir(state2, (IBlockAccess)worldIn, upN) && !state2.func_177230_c().isLeaves(state2, (IBlockAccess)worldIn, upN) && !(state2.func_177230_c() instanceof BlockModSapling)) continue;
                    this.func_175903_a(worldIn, position.func_177981_b(j2), LOG);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

