/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.potion;

import com.teamwizardry.librarianlib.features.forgeevents.EntityUpdateEvent;
import com.teamwizardry.wizardry.api.events.EntityMoveEvent;
import com.teamwizardry.wizardry.common.potion.PotionBase;
import com.teamwizardry.wizardry.init.ModPotions;
import com.teamwizardry.wizardry.init.ModSounds;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="wizardry")
public class PotionTimeSlow
extends PotionBase {
    public PotionTimeSlow() {
        super("time_slow", false, 15256077);
    }

    public void func_111185_a(EntityLivingBase entityLivingBaseIn, @Nonnull AbstractAttributeMap attributeMapIn, int amplifier) {
        super.func_111185_a(entityLivingBaseIn, attributeMapIn, amplifier);
        entityLivingBaseIn.field_70170_p.func_184133_a(null, entityLivingBaseIn.func_180425_c(), (SoundEvent)ModSounds.SLOW_MOTION_IN, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    public void func_111187_a(EntityLivingBase entityLivingBaseIn, @Nonnull AbstractAttributeMap attributeMapIn, int amplifier) {
        super.func_111187_a(entityLivingBaseIn, attributeMapIn, amplifier);
        entityLivingBaseIn.field_70170_p.func_184133_a(null, entityLivingBaseIn.func_180425_c(), (SoundEvent)ModSounds.SLOW_MOTION_OUT, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    public static float timeScale(Entity entity) {
        PotionEffect effect;
        if (entity instanceof EntityLivingBase && (effect = ModPotions.TIME_SLOW.getEffect((EntityLivingBase)entity)) != null) {
            return 1.0f / ((float)effect.func_76458_c() + 1.5f);
        }
        return -1.0f;
    }

    @SubscribeEvent
    public static void fall(LivingFallEvent event) {
        float scale = PotionTimeSlow.timeScale(event.getEntity());
        if (scale > 0.0f) {
            event.setDistance(event.getDistance() * scale);
        }
    }

    @SubscribeEvent
    public static void entityPreUpdate(EntityUpdateEvent event) {
        Entity entity = event.getEntity();
        float scale = PotionTimeSlow.timeScale(entity);
        if (!entity.func_189652_ae() && scale > 0.0f) {
            double gravity = entity instanceof EntityLivingBase ? -0.08 : -0.04;
            entity.field_70181_x -= gravity * (double)(1.0f - scale);
        }
    }

    @SubscribeEvent
    public static void entityMove(EntityMoveEvent event) {
        float scale = PotionTimeSlow.timeScale(event.entity);
        if (scale > 0.0f) {
            event.x *= (double)scale;
            event.y *= (double)scale;
            event.z *= (double)scale;
        }
    }
}

