/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects.phase;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.wizardry.api.spell.IDelayedModule;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellDataTypes;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleRegistry;
import com.teamwizardry.wizardry.api.util.BlockUtils;
import com.teamwizardry.wizardry.api.util.PosUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RenderUtils;
import com.teamwizardry.wizardry.common.core.WizardryNemezManager;
import com.teamwizardry.wizardry.common.core.nemez.NemezEventHandler;
import com.teamwizardry.wizardry.common.core.nemez.NemezTracker;
import com.teamwizardry.wizardry.common.module.effects.phase.PhasedBlockRenderer;
import com.teamwizardry.wizardry.init.ModBlocks;
import com.teamwizardry.wizardry.init.ModPotions;
import com.teamwizardry.wizardry.init.ModSounds;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_phase")
public class ModuleEffectPhase
implements IModuleEffect,
IDelayedModule {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_extend_time", "modifier_increase_aoe", "modifier_extend_range"};
    }

    @Override
    public void runDelayedEffect(@Nonnull World world, SpellData spell, SpellRing spellRing) {
        BlockPos targetPos = spell.getTargetPos();
        if (targetPos == null) {
            return;
        }
        NemezTracker nemezDrive = WizardryNemezManager.getAndRemoveNemezDrive(world, targetPos);
        if (nemezDrive != null) {
            NemezEventHandler.reverseTime(world, nemezDrive, targetPos);
        }
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Entity caster = spell.getCaster(world);
        Entity targetEntity = spell.getVictim(world);
        BlockPos targetPos = spell.getTargetPos();
        EnumFacing faceHit = spell.getFaceHit();
        double duration = spellRing.getAttributeValue(world, AttributeRegistry.DURATION, spell) * 20.0f;
        double area = spellRing.getAttributeValue(world, AttributeRegistry.AREA, spell);
        double range = spellRing.getAttributeValue(world, AttributeRegistry.RANGE, spell);
        if (!spellRing.taxCaster(world, spell, true)) {
            return false;
        }
        if (targetEntity instanceof EntityLivingBase) {
            EntityLivingBase entity = (EntityLivingBase)targetEntity;
            entity.func_70690_d(new PotionEffect((Potion)ModPotions.PHASE, (int)duration, 0, true, false));
            world.func_184133_a(null, targetEntity.func_180425_c(), (SoundEvent)ModSounds.ETHEREAL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
        }
        if (targetPos != null && faceHit != null) {
            world.func_184133_a(null, targetPos, (SoundEvent)ModSounds.ETHEREAL, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            NemezTracker nemezDrive = WizardryNemezManager.getOrCreateNemezDrive(world, targetPos);
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(targetPos);
            faceHit = faceHit.func_176734_d();
            IBlockState targetState = world.func_180495_p((BlockPos)mutable);
            if (BlockUtils.isAnyAir(targetState)) {
                return true;
            }
            HashSet<BlockPos> poses = new HashSet<BlockPos>();
            HashMap<BlockPos, IBlockState> stateCache = new HashMap<BlockPos, IBlockState>();
            for (int rangeTick = 0; rangeTick <= (int)range; ++rangeTick) {
                IBlockState state;
                AxisAlignedBB bb = new AxisAlignedBB((BlockPos)mutable, (BlockPos)mutable);
                switch (faceHit) {
                    case DOWN: 
                    case UP: {
                        bb = bb.func_72314_b(area + 1.0, 0.0, area + 1.0);
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        bb = bb.func_72314_b(area + 1.0, area + 1.0, 0.0);
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        bb = bb.func_72314_b(0.0, area + 1.0, area + 1.0);
                    }
                }
                HashSet<BlockPos> edges = new HashSet<BlockPos>();
                switch (faceHit) {
                    case DOWN: 
                    case UP: {
                        for (int x = (int)bb.field_72340_a; x <= (int)bb.field_72336_d; ++x) {
                            for (int z = (int)bb.field_72339_c; z <= (int)bb.field_72334_f; ++z) {
                                if (x == (int)bb.field_72336_d || x == (int)bb.field_72340_a) {
                                    edges.add(new BlockPos(x, mutable.func_177956_o(), z));
                                    continue;
                                }
                                if (z != (int)bb.field_72339_c && z != (int)bb.field_72334_f) continue;
                                edges.add(new BlockPos(x, mutable.func_177956_o(), z));
                            }
                        }
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        int y;
                        for (int x = (int)bb.field_72340_a; x <= (int)bb.field_72336_d; ++x) {
                            for (y = (int)bb.field_72338_b; y <= (int)bb.field_72337_e; ++y) {
                                if (y == (int)bb.field_72337_e || y == (int)bb.field_72338_b) {
                                    edges.add(new BlockPos(x, y, mutable.func_177952_p()));
                                    continue;
                                }
                                if (x != (int)bb.field_72340_a && x != (int)bb.field_72336_d) continue;
                                edges.add(new BlockPos(x, y, mutable.func_177952_p()));
                            }
                        }
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        int y;
                        for (int z = (int)bb.field_72339_c; z <= (int)bb.field_72334_f; ++z) {
                            for (y = (int)bb.field_72338_b; y <= (int)bb.field_72337_e; ++y) {
                                if (y == (int)bb.field_72337_e || y == (int)bb.field_72338_b) {
                                    edges.add(new BlockPos(mutable.func_177958_n(), y, z));
                                    continue;
                                }
                                if (z != (int)bb.field_72339_c && z != (int)bb.field_72334_f) continue;
                                edges.add(new BlockPos(mutable.func_177958_n(), y, z));
                            }
                        }
                        break;
                    }
                }
                HashMap<BlockPos, IBlockState> tmp = new HashMap<BlockPos, IBlockState>();
                boolean fullAirPlane = true;
                int edgeAirCount = 0;
                int edgeBlockCount = 0;
                for (BlockPos blockPos : BlockPos.func_191532_a((int)((int)bb.field_72340_a), (int)((int)bb.field_72338_b), (int)((int)bb.field_72339_c), (int)((int)bb.field_72336_d), (int)((int)bb.field_72337_e), (int)((int)bb.field_72334_f))) {
                    IBlockState originalState = world.func_180495_p(blockPos);
                    Block block = originalState.func_177230_c();
                    if (edges.contains(blockPos)) {
                        stateCache.put(blockPos, originalState);
                        if (block == Blocks.field_150350_a) {
                            ++edgeAirCount;
                            continue;
                        }
                        ++edgeBlockCount;
                        continue;
                    }
                    if (block != Blocks.field_150350_a) {
                        fullAirPlane = false;
                    }
                    if (block == ModBlocks.FAKE_AIR || world.func_175625_s(blockPos) != null) continue;
                    tmp.put(blockPos, originalState);
                }
                if (fullAirPlane) break;
                if (edgeAirCount <= edgeBlockCount) {
                    for (Map.Entry entry : tmp.entrySet()) {
                        nemezDrive.trackBlock((BlockPos)entry.getKey(), (IBlockState)entry.getValue());
                        state = ModBlocks.FAKE_AIR.func_176223_P();
                        BlockUtils.placeBlock(world, (BlockPos)entry.getKey(), state, (EntityPlayerMP)caster);
                        stateCache.put((BlockPos)entry.getKey(), state);
                        nemezDrive.trackBlock((BlockPos)entry.getKey(), state);
                    }
                    poses.addAll(tmp.keySet());
                } else {
                    for (Map.Entry entry : tmp.entrySet()) {
                        if (((IBlockState)entry.getValue()).func_177230_c() == Blocks.field_150350_a) {
                            stateCache.put((BlockPos)entry.getKey(), (IBlockState)entry.getValue());
                            continue;
                        }
                        nemezDrive.trackBlock((BlockPos)entry.getKey(), (IBlockState)entry.getValue());
                        state = ModBlocks.FAKE_AIR.func_176223_P();
                        BlockUtils.placeBlock(world, (BlockPos)entry.getKey(), state, (EntityPlayerMP)caster);
                        stateCache.put((BlockPos)entry.getKey(), state);
                        nemezDrive.trackBlock((BlockPos)entry.getKey(), state);
                        poses.add((BlockPos)entry.getKey());
                    }
                }
                mutable.func_189536_c(faceHit);
            }
            nemezDrive.endUpdate();
            nemezDrive.collapse();
            spell.addData(SpellData.DefaultKeys.BLOCK_SET, new SpellDataTypes.BlockSet(poses));
            spell.addData(SpellData.DefaultKeys.BLOCKSTATE_CACHE, new SpellDataTypes.BlockStateCache(stateCache));
            this.addDelayedSpell(world, spellRing, spell, (int)duration);
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        EnumFacing faceHit = spell.getFaceHit();
        Set<BlockPos> blockSet = spell.getDataWithFallback(SpellData.DefaultKeys.BLOCK_SET, new SpellDataTypes.BlockSet(new HashSet<BlockPos>())).getBlockSet();
        Map<BlockPos, IBlockState> blockStateCache = spell.getDataWithFallback(SpellData.DefaultKeys.BLOCKSTATE_CACHE, new SpellDataTypes.BlockStateCache(new HashMap<BlockPos, IBlockState>())).getBlockStateCache();
        HashMap<BlockPos, IBlockState> tmpCache = new HashMap<BlockPos, IBlockState>(blockStateCache);
        double duration = spellRing.getAttributeValue(world, AttributeRegistry.DURATION, spell) * 20.0f;
        PhasedBlockRenderer.addPhase(world, blockSet, (int)duration);
        if (faceHit != null) {
            for (Map.Entry<BlockPos, IBlockState> entry : tmpCache.entrySet()) {
                IBlockState thisState = entry.getValue();
                if (thisState.func_177230_c() != ModBlocks.FAKE_AIR) continue;
                ParticleBuilder glitter2 = new ParticleBuilder(10);
                glitter2.setRenderNormalLayer(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
                glitter2.disableRandom();
                ParticleSpawner.spawn((ParticleBuilder)glitter2, (World)world, (InterpFunction)new StaticInterp((Object)new Vec3d((Vec3i)entry.getKey()).func_72441_c(0.5, 0.5, 0.5)), (int)5, (int)((int)duration), (aFloat, build) -> {
                    build.setColor(Color.CYAN);
                    build.setAlpha(RandUtil.nextFloat(0.05f, 0.2f));
                    build.setPositionOffset(new Vec3d(RandUtil.nextDouble(-0.5, 0.5), RandUtil.nextDouble(-0.5, 0.5), RandUtil.nextDouble(-0.5, 0.5)));
                    build.setMotion(new Vec3d(RandUtil.nextDouble(-0.001, 0.001), RandUtil.nextDouble(-0.001, 0.001), RandUtil.nextDouble(-0.001, 0.001)));
                    build.setLifetime(RandUtil.nextInt(20, 40));
                    build.setScaleFunction((InterpFunction)new InterpFloatInOut(0.9f, 0.9f));
                    build.setScale(RandUtil.nextFloat(0.1f, 0.3f));
                });
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(entry.getKey());
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    IBlockState adjState;
                    mutable.func_189536_c(facing);
                    if (!blockStateCache.containsKey(mutable)) {
                        adjState = world.func_180495_p((BlockPos)mutable);
                        blockStateCache.put(mutable.func_185334_h(), adjState);
                    } else {
                        adjState = blockStateCache.get(mutable);
                    }
                    if (adjState.func_177230_c() != Blocks.field_150350_a && adjState.func_177230_c() != ModBlocks.FAKE_AIR) {
                        Vec3d directionOffsetVec = new Vec3d(facing.func_176734_d().func_176730_m()).func_186678_a(0.5);
                        Vec3d adjPos = new Vec3d((Vec3i)mutable).func_72441_c(0.5, 0.5, 0.5).func_178787_e(directionOffsetVec);
                        for (EnumFacing subFacing : PosUtils.getPerpendicularFacings(facing)) {
                            IBlockState subState;
                            mutable.func_189536_c(subFacing);
                            if (!blockStateCache.containsKey(mutable)) {
                                subState = world.func_180495_p((BlockPos)mutable);
                                blockStateCache.put(mutable.func_185334_h(), subState);
                            } else {
                                subState = blockStateCache.get(mutable);
                            }
                            if (BlockUtils.isAnyAir(subState)) {
                                Vec3d subPos = new Vec3d((Vec3i)mutable).func_72441_c(0.5, 0.5, 0.5).func_178787_e(directionOffsetVec);
                                Vec3d midPointVec = new Vec3d((adjPos.field_72450_a + subPos.field_72450_a) / 2.0, (adjPos.field_72448_b + subPos.field_72448_b) / 2.0, (adjPos.field_72449_c + subPos.field_72449_c) / 2.0);
                                Vec3d sub = subPos.func_178788_d(adjPos);
                                EnumFacing adjSubFacing = EnumFacing.func_176737_a((float)((float)sub.field_72450_a), (float)((float)sub.field_72448_b), (float)((float)sub.field_72449_c));
                                Vec3d cross = new Vec3d(adjSubFacing.func_176730_m()).func_72431_c(new Vec3d(facing.func_176730_m())).func_72432_b().func_186678_a(0.5);
                                ParticleBuilder glitter = new ParticleBuilder(10);
                                glitter.setRenderNormalLayer(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
                                glitter.disableRandom();
                                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)midPointVec), (int)50, (int)((int)duration), (aFloat, build) -> {
                                    build.setColor(Color.CYAN);
                                    build.setAlpha(RandUtil.nextFloat(0.3f, 0.7f));
                                    build.setPositionOffset(cross.func_186678_a((double)RandUtil.nextFloat(-1.0f, 1.0f)));
                                    build.setLifetime(RandUtil.nextInt(20, 40));
                                    build.setScaleFunction((InterpFunction)new InterpFloatInOut(0.9f, 0.9f));
                                    build.setScale(RandUtil.nextFloat(0.2f, 0.5f));
                                });
                            }
                            mutable.func_189536_c(subFacing.func_176734_d());
                        }
                    }
                    mutable.func_189536_c(facing.func_176734_d());
                }
            }
        }
    }

    @Override
    @NotNull
    public SpellData renderVisualization(@Nonnull World world, ModuleInstanceEffect instance, @Nonnull SpellData data, @Nonnull SpellRing ring, float partialTicks) {
        if (ring.getParentRing() != null && ring.getParentRing().getModule() != null && ring.getParentRing().getModule() == ModuleRegistry.INSTANCE.getModule("event_collide_entity")) {
            return data;
        }
        BlockPos targetPos = data.getData(SpellData.DefaultKeys.BLOCK_HIT);
        EnumFacing faceHit = data.getFaceHit();
        double area = ring.getAttributeValue(world, AttributeRegistry.AREA, data);
        double range = ring.getAttributeValue(world, AttributeRegistry.RANGE, data);
        if (faceHit != null && targetPos != null) {
            IBlockState targetState = instance.getCachableBlockstate(world, targetPos, data);
            if (BlockUtils.isAnyAir(targetState)) {
                return data;
            }
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(targetPos);
            faceHit = faceHit.func_176734_d();
            for (int rangeTick = 0; rangeTick <= (int)range; ++rangeTick) {
                AxisAlignedBB bb = new AxisAlignedBB((BlockPos)mutable, (BlockPos)mutable);
                switch (faceHit) {
                    case DOWN: 
                    case UP: {
                        bb = bb.func_72314_b(area + 1.0, 0.0, area + 1.0);
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        bb = bb.func_72314_b(area + 1.0, area + 1.0, 0.0);
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        bb = bb.func_72314_b(0.0, area + 1.0, area + 1.0);
                    }
                }
                HashSet<BlockPos> edges = new HashSet<BlockPos>();
                switch (faceHit) {
                    case DOWN: 
                    case UP: {
                        for (int x = (int)bb.field_72340_a; x <= (int)bb.field_72336_d; ++x) {
                            for (int z = (int)bb.field_72339_c; z <= (int)bb.field_72334_f; ++z) {
                                if (x == (int)bb.field_72336_d || x == (int)bb.field_72340_a) {
                                    edges.add(new BlockPos(x, mutable.func_177956_o(), z));
                                    continue;
                                }
                                if (z != (int)bb.field_72339_c && z != (int)bb.field_72334_f) continue;
                                edges.add(new BlockPos(x, mutable.func_177956_o(), z));
                            }
                        }
                        break;
                    }
                    case NORTH: 
                    case SOUTH: {
                        int y;
                        for (int x = (int)bb.field_72340_a; x <= (int)bb.field_72336_d; ++x) {
                            for (y = (int)bb.field_72338_b; y <= (int)bb.field_72337_e; ++y) {
                                if (y == (int)bb.field_72337_e || y == (int)bb.field_72338_b) {
                                    edges.add(new BlockPos(x, y, mutable.func_177952_p()));
                                    continue;
                                }
                                if (x != (int)bb.field_72340_a && x != (int)bb.field_72336_d) continue;
                                edges.add(new BlockPos(x, y, mutable.func_177952_p()));
                            }
                        }
                        break;
                    }
                    case WEST: 
                    case EAST: {
                        int y;
                        for (int z = (int)bb.field_72339_c; z <= (int)bb.field_72334_f; ++z) {
                            for (y = (int)bb.field_72338_b; y <= (int)bb.field_72337_e; ++y) {
                                if (y == (int)bb.field_72337_e || y == (int)bb.field_72338_b) {
                                    edges.add(new BlockPos(mutable.func_177958_n(), y, z));
                                    continue;
                                }
                                if (z != (int)bb.field_72339_c && z != (int)bb.field_72334_f) continue;
                                edges.add(new BlockPos(mutable.func_177958_n(), y, z));
                            }
                        }
                        break;
                    }
                }
                HashMap<BlockPos, IBlockState> tmp = new HashMap<BlockPos, IBlockState>();
                boolean fullAirPlane = true;
                for (BlockPos blockPos : BlockPos.func_191532_a((int)((int)bb.field_72340_a), (int)((int)bb.field_72338_b), (int)((int)bb.field_72339_c), (int)((int)bb.field_72336_d), (int)((int)bb.field_72337_e), (int)((int)bb.field_72334_f))) {
                    IBlockState originalState = instance.getCachableBlockstate(world, blockPos, data);
                    Block block = originalState.func_177230_c();
                    if (edges.contains(blockPos)) continue;
                    if (block != Blocks.field_150350_a) {
                        fullAirPlane = false;
                    }
                    if (block == ModBlocks.FAKE_AIR || world.func_175625_s(blockPos) != null || BlockUtils.isAnyAir(originalState)) continue;
                    tmp.put(blockPos, originalState);
                }
                if (fullAirPlane) break;
                for (Map.Entry entry : tmp.entrySet()) {
                    if (BlockUtils.isAnyAir((IBlockState)entry.getValue())) continue;
                    BlockPos.MutableBlockPos mutable2 = new BlockPos.MutableBlockPos((BlockPos)entry.getKey());
                    for (EnumFacing facing : PosUtils.getPerpendicularFacings(faceHit)) {
                        mutable2.func_189536_c(facing);
                        if (!tmp.containsKey(mutable2)) {
                            RenderUtils.drawFaceOutline((BlockPos)mutable2, facing.func_176734_d());
                        }
                        mutable2.func_189536_c(facing.func_176734_d());
                    }
                }
                mutable.func_189536_c(faceHit);
            }
        }
        return data;
    }
}

