/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects.lightning;

import com.google.common.base.Predicate;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.api.LightningGenerator;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.ContextRing;
import com.teamwizardry.wizardry.api.spell.annotation.ContextSuper;
import com.teamwizardry.wizardry.api.spell.annotation.ModuleOverride;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleOverrideSuper;
import com.teamwizardry.wizardry.api.util.PosUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RandUtilSeed;
import com.teamwizardry.wizardry.api.util.RayTrace;
import com.teamwizardry.wizardry.common.core.LightningTracker;
import com.teamwizardry.wizardry.common.entity.projectile.EntityLightningProjectile;
import com.teamwizardry.wizardry.common.network.PacketRenderLightningBolt;
import com.teamwizardry.wizardry.init.ModSounds;
import java.util.ArrayList;
import java.util.HashSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_lightning")
public class ModuleEffectLightning
implements IModuleEffect {
    @Override
    public void initEffect(ModuleInstanceEffect instance) {
    }

    @ModuleOverride(value="shape_touch_render")
    public boolean onRenderTouch(World world, SpellData data, SpellRing shape, @ContextRing SpellRing childRing) {
        return true;
    }

    @ModuleOverride(value="shape_projectile_render")
    public boolean onRenderProjectile(World world, SpellData data, SpellRing shape, @ContextRing SpellRing childRing) {
        return true;
    }

    @ModuleOverride(value="shape_cone_render")
    public boolean onRenderCone(World world, SpellData data, SpellRing shape, @ContextRing SpellRing childRing) {
        return true;
    }

    @ModuleOverride(value="shape_beam_render")
    public boolean onRenderBeam(World world, SpellData data, SpellRing shape, @ContextRing SpellRing childRing) {
        return true;
    }

    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_extend_range", "modifier_increase_potency", "modifier_extend_time"};
    }

    public static void doLightning(long seed, World world, Entity caster, Vec3d from, Vec3d to, double offshootRange, double potency, double duration) {
        RandUtilSeed rand = new RandUtilSeed(seed);
        ArrayList points = new ArrayList();
        LightningGenerator.generate(rand, from, to, offshootRange).forEach(points::add);
        world.func_184133_a(null, new BlockPos(to), (SoundEvent)ModSounds.LIGHTNING, SoundCategory.NEUTRAL, 0.1f, RandUtil.nextFloat(1.0f, 1.5f));
        world.func_184133_a(null, new BlockPos(from), (SoundEvent)ModSounds.LIGHTNING, SoundCategory.NEUTRAL, 0.1f, RandUtil.nextFloat(1.0f, 1.5f));
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (Vec3d point : points) {
            positions.add(new BlockPos(point));
        }
        HashSet entities = new HashSet();
        for (BlockPos position : positions) {
            entities.addAll(world.func_72872_a(EntityLivingBase.class, new AxisAlignedBB(position).func_191195_a(0.2, 0.2, 0.2)));
        }
        entities.remove(caster);
        for (Entity entity : entities) {
            LightningTracker.INSTANCE.addEntity(from, entity, caster, potency, duration);
        }
        ModuleEffectLightning.doLightningRender(seed, world, from, to, offshootRange);
    }

    public static void doLightningRender(long seed, World world, Vec3d from, Vec3d to, double offshootRange) {
        PacketHandler.NETWORK.sendToAllAround((IMessage)new PacketRenderLightningBolt(seed, from, to, offshootRange), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), from.field_72450_a, from.field_72448_b, from.field_72449_c, 256.0));
    }

    @ModuleOverride(value="shape_self_run")
    public void onRunSelf(@ContextSuper ModuleOverrideSuper ovdSuper, World world, SpellData data, SpellRing shape, @ContextRing SpellRing childRing) {
        if (ovdSuper.hasSuper()) {
            ovdSuper.invoke(true, world, data, shape);
        }
        if (world.field_72995_K) {
            return;
        }
        Entity caster = data.getCaster(world);
        if (caster == null) {
            return;
        }
        Vec3d origin = data.getOrigin(world);
        if (origin == null) {
            return;
        }
        if (!childRing.taxCaster(world, data, true)) {
            return;
        }
        double range = childRing.getAttributeValue(world, AttributeRegistry.RANGE, data);
        double potency = childRing.getAttributeValue(world, AttributeRegistry.POTENCY, data) / 2.0f;
        double duration = childRing.getAttributeValue(world, AttributeRegistry.DURATION, data);
        RandUtilSeed rand = new RandUtilSeed(RandUtil.nextLong(100L, 100000L));
        float pitch = rand.nextFloat(-45.0f, 45.0f);
        float yaw = rand.nextFloat(0.0f, 360.0f);
        ModuleEffectLightning.doLightning(rand.nextLong(100L, 100000L), world, caster, origin, Vec3d.func_189986_a((float)pitch, (float)yaw).func_72432_b().func_186678_a(range).func_178787_e(origin), range, potency, duration);
    }

    @ModuleOverride(value="shape_touch_run")
    public void onRunTouch(@ContextSuper ModuleOverrideSuper ovdSuper, World world, SpellData data, SpellRing shape, @ContextRing SpellRing childRing) {
        if (ovdSuper.hasSuper()) {
            ovdSuper.invoke(true, world, data, shape);
        }
        Vec3d look = data.getData(SpellData.DefaultKeys.LOOK);
        Entity caster = data.getCaster(world);
        Vec3d origin = data.getOriginWithFallback(world);
        if (look == null || caster == null || origin == null) {
            return;
        }
        if (!childRing.taxCaster(world, data, true)) {
            return;
        }
        double range = childRing.getAttributeValue(world, AttributeRegistry.RANGE, data);
        double potency = childRing.getAttributeValue(world, AttributeRegistry.POTENCY, data);
        double duration = childRing.getAttributeValue(world, AttributeRegistry.DURATION, data);
        RayTraceResult trace = new RayTrace(world, look, origin, caster instanceof EntityLivingBase ? ((EntityLivingBase)caster).func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e() : 5.0).setEntityFilter((Predicate<Entity>)((Predicate)input -> input != caster)).setReturnLastUncollidableBlock(true).setIgnoreBlocksWithoutBoundingBoxes(true).trace();
        ModuleEffectLightning.doLightning(RandUtil.nextLong(100L, 100000L), world, caster, origin, trace.field_72307_f, range, potency, duration);
    }

    @ModuleOverride(value="shape_projectile_run")
    public boolean onRunProjectile(@ContextSuper ModuleOverrideSuper ovdSuper, World world, SpellData data, SpellRing shape, @ContextRing SpellRing childRing) {
        if (ovdSuper.hasSuper()) {
            ovdSuper.invoke(true, world, data, shape);
        }
        if (world.field_72995_K) {
            return true;
        }
        Vec3d origin = data.getOriginWithFallback(world);
        if (origin == null) {
            return true;
        }
        if (!childRing.taxCaster(world, data, true)) {
            return true;
        }
        double dist = shape.getAttributeValue(world, AttributeRegistry.RANGE, data);
        double speed = shape.getAttributeValue(world, AttributeRegistry.SPEED, data);
        EntityLightningProjectile proj = new EntityLightningProjectile(world, shape, childRing, data, (float)dist, (float)speed, 0.1f);
        proj.func_70107_b(origin.field_72450_a, origin.field_72448_b, origin.field_72449_c);
        world.func_72838_d((Entity)proj);
        return true;
    }

    @ModuleOverride(value="shape_beam_run")
    public void onRunBeam(@ContextSuper ModuleOverrideSuper ovdSuper, World world, SpellData data, SpellRing shape, @ContextRing SpellRing childRing) {
        if (ovdSuper.hasSuper()) {
            ovdSuper.invoke(true, world, data, shape);
        }
        if (world.field_72995_K) {
            return;
        }
        Entity caster = data.getCaster(world);
        float yaw = data.getYaw();
        float pitch = data.getPitch();
        Vec3d origin = data.getOriginHand(world);
        if (origin == null) {
            return;
        }
        if (!childRing.taxCaster(world, data, true)) {
            return;
        }
        double lightningRange = childRing.getAttributeValue(world, AttributeRegistry.RANGE, data);
        double lightningPotency = (double)childRing.getAttributeValue(world, AttributeRegistry.POTENCY, data) / 2.0;
        double lightningDuration = childRing.getAttributeValue(world, AttributeRegistry.DURATION, data);
        double beamRange = shape.getAttributeValue(world, AttributeRegistry.RANGE, data);
        RayTraceResult traceResult = new RayTrace(world, PosUtils.vecFromRotations(pitch, yaw), origin, beamRange).setSkipBlocks(true).setSkipEntities(true).trace();
        ModuleEffectLightning.doLightning(RandUtil.nextLong(100L, 100000L), world, caster, origin, traceResult.field_72307_f, lightningRange, lightningPotency, lightningDuration);
    }

    @ModuleOverride(value="generic_chargeup_time")
    public int modifyChargeupTime(int originalTime, @ContextRing SpellRing mySpellRing) {
        return mySpellRing.getChargeUpTime();
    }

    @ModuleOverride(value="shape_cone_run")
    public void onRunCone(@ContextSuper ModuleOverrideSuper ovdSuper, World world, SpellData data, SpellRing shape, @ContextRing SpellRing childRing) {
        if (ovdSuper.hasSuper()) {
            ovdSuper.invoke(true, world, data, shape);
        }
        float yaw = data.getYaw();
        float pitch = data.getPitch();
        Vec3d origin = data.getOriginHand(world);
        Entity caster = data.getCaster(world);
        if (origin == null) {
            return;
        }
        if (!childRing.taxCaster(world, data, true)) {
            return;
        }
        double coneRange = shape.getAttributeValue(world, AttributeRegistry.RANGE, data);
        double lightningRange = childRing.getAttributeValue(world, AttributeRegistry.RANGE, data);
        double lightningPotency = childRing.getAttributeValue(world, AttributeRegistry.POTENCY, data);
        double lightningDuration = childRing.getAttributeValue(world, AttributeRegistry.DURATION, data);
        RandUtilSeed rand = new RandUtilSeed(RandUtil.nextLong(100L, 100000L));
        float angle = (float)coneRange * 2.0f;
        float newPitch = pitch + rand.nextFloat(-angle, angle);
        float newYaw = yaw + rand.nextFloat(-angle, angle);
        Vec3d to = Vec3d.func_189986_a((float)newPitch, (float)newYaw).func_72432_b().func_186678_a(coneRange).func_178787_e(origin);
        ModuleEffectLightning.doLightning(rand.nextLong(100L, 100000L), world, caster, origin, to, lightningRange, lightningPotency, lightningDuration);
    }

    @ModuleOverride(value="shape_zone_run")
    public boolean onRunZone(@ContextSuper ModuleOverrideSuper ovdSuper, World world, SpellData data, SpellRing shape, @ContextRing SpellRing childRing) {
        if (ovdSuper.hasSuper()) {
            ovdSuper.invoke(true, world, data, shape);
        }
        Entity caster = data.getCaster(world);
        Vec3d targetPos = data.getTargetWithFallback(world);
        if (targetPos == null) {
            return true;
        }
        if (!childRing.taxCaster(world, data, true)) {
            return true;
        }
        double lightningRange = childRing.getAttributeValue(world, AttributeRegistry.RANGE, data);
        double lightningPotency = (double)childRing.getAttributeValue(world, AttributeRegistry.POTENCY, data) / 2.0;
        double lightningDuration = childRing.getAttributeValue(world, AttributeRegistry.DURATION, data);
        double zoneAoE = shape.getAttributeValue(world, AttributeRegistry.AREA, data);
        double zoneRange = shape.getAttributeValue(world, AttributeRegistry.RANGE, data);
        Vec3d min = targetPos.func_178786_a(zoneAoE / 2.0, zoneRange / 2.0, zoneAoE / 2.0);
        Vec3d max = targetPos.func_72441_c(zoneAoE / 2.0, zoneRange / 2.0, zoneAoE / 2.0);
        RandUtilSeed rand = new RandUtilSeed(RandUtil.nextLong(100L, 100000L));
        Vec3d from = new Vec3d(rand.nextDouble(min.field_72450_a, max.field_72450_a), rand.nextDouble(min.field_72448_b, max.field_72448_b), rand.nextDouble(min.field_72449_c, max.field_72449_c));
        float pitch = (float)(180.0 * Math.asin(2.0 * rand.nextDouble() - 1.0) / Math.PI);
        float yaw = (float)rand.nextDouble(360.0);
        Vec3d to = Vec3d.func_189986_a((float)pitch, (float)yaw).func_72432_b().func_186678_a(lightningRange).func_178787_e(from);
        ModuleEffectLightning.doLightning(rand.nextLong(100L, 100000L), world, caster, from, to, lightningRange, lightningPotency, lightningDuration);
        return true;
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @ContextRing @Nonnull SpellRing spellRing) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @ContextRing @Nonnull SpellRing spellRing) {
    }
}

