/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects.bounce;

import com.teamwizardry.librarianlib.features.network.PacketHandler;
import com.teamwizardry.wizardry.common.module.effects.bounce.BounceHandler;
import com.teamwizardry.wizardry.common.module.effects.bounce.PacketBounce;
import com.teamwizardry.wizardry.init.ModPotions;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

@Mod.EventBusSubscriber
public class BounceManager {
    public static final BounceManager INSTANCE = new BounceManager();
    private final Set<BouncyBlock> blocks = new HashSet<BouncyBlock>();

    private BounceManager() {
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        if (!BounceManager.shouldBounce(entity)) {
            return;
        }
        BounceManager.INSTANCE.blocks.removeIf(bouncyBlock -> entity.field_70170_p.func_82737_E() - bouncyBlock.tickSpawned > (long)bouncyBlock.expiry);
        boolean isClient = entity.func_130014_f_().field_72995_K;
        if ((double)event.getDistance() > 0.5) {
            event.setDamageMultiplier(0.0f);
            entity.field_70143_R = 0.0f;
            if (isClient) {
                entity.field_70181_x *= -0.9;
                entity.field_70160_al = true;
                entity.field_70122_E = false;
                double f = 0.95;
                entity.field_70159_w /= f;
                entity.field_70179_y /= f;
                PacketHandler.NETWORK.sendToServer((IMessage)new PacketBounce());
            } else {
                event.setCanceled(true);
            }
            entity.func_184185_a(SoundEvents.field_187886_fs, 1.0f, 1.0f);
            BounceHandler.addBounceHandler(entity, entity.field_70181_x);
        }
    }

    @SubscribeEvent
    public static void onFlyableFall(PlayerFlyableFallEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        if (!BounceManager.shouldBounce(entity)) {
            return;
        }
        BounceManager.INSTANCE.blocks.removeIf(bouncyBlock -> entity.field_70170_p.func_82737_E() - bouncyBlock.tickSpawned > (long)bouncyBlock.expiry);
        boolean isClient = entity.func_130014_f_().field_72995_K;
        if ((double)event.getDistance() > 0.5) {
            entity.field_70143_R = 0.0f;
            if (isClient) {
                entity.field_70181_x *= -0.9;
                entity.field_70160_al = true;
                entity.field_70122_E = false;
                double f = 0.95;
                entity.field_70159_w /= f;
                entity.field_70179_y /= f;
                PacketHandler.NETWORK.sendToServer((IMessage)new PacketBounce());
            }
            entity.func_184185_a(SoundEvents.field_187886_fs, 1.0f, 1.0f);
            BounceHandler.addBounceHandler(entity, entity.field_70181_x);
        }
    }

    private static boolean shouldBounce(EntityLivingBase entity) {
        if (entity.func_70644_a((Potion)ModPotions.BOUNCING)) {
            return true;
        }
        for (BouncyBlock block : BounceManager.INSTANCE.blocks) {
            if (!block.doesMatch((Entity)entity)) continue;
            return true;
        }
        return false;
    }

    public void forEntity(EntityLivingBase entity, int time) {
        entity.func_70690_d(new PotionEffect((Potion)ModPotions.BOUNCING, time, 0, true, false));
    }

    public void forBlock(World world, BlockPos pos, int time) {
        for (BouncyBlock block : this.blocks) {
            if (!block.doesMatch(world, pos)) continue;
            block.resetTimer(world, time);
            return;
        }
        this.blocks.add(new BouncyBlock(world, pos, time));
    }

    private static class BouncyBlock {
        public final int dim;
        public final BlockPos pos;
        public long tickSpawned;
        public int expiry;

        public BouncyBlock(@Nonnull World world, @Nonnull BlockPos pos, int expiry) {
            this.dim = world.field_73011_w.getDimension();
            this.pos = pos;
            this.expiry = expiry;
            this.tickSpawned = world.func_82737_E();
        }

        public boolean doesMatch(World world, BlockPos pos) {
            return this.dim == world.field_73011_w.getDimension() && this.pos.equals((Object)pos);
        }

        public boolean doesMatch(Entity entity) {
            Vec3d vec = entity.func_174791_d();
            if (vec.field_72450_a > (double)this.pos.func_177958_n() && vec.field_72450_a < (double)(this.pos.func_177958_n() + 1) && vec.field_72449_c > (double)this.pos.func_177952_p() && vec.field_72449_c < (double)(this.pos.func_177952_p() + 1)) {
                return this.dim == entity.field_70170_p.field_73011_w.getDimension();
            }
            return false;
        }

        public void resetTimer(World world, int expiry) {
            this.tickSpawned = world.func_82737_E();
            this.expiry = expiry;
        }
    }
}

