/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.wizardry.api.spell.IBlockSelectable;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.BlockUtils;
import com.teamwizardry.wizardry.api.util.RenderUtils;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.common.module.shapes.ModuleShapeZone;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_place")
public class ModuleEffectPlace
implements IModuleEffect,
IBlockSelectable {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_aoe"};
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        BlockPos targetPos = spell.getData(SpellData.DefaultKeys.BLOCK_HIT);
        Entity caster = spell.getCaster(world);
        EnumFacing facing = spell.getData(SpellData.DefaultKeys.FACE_HIT);
        if (facing == null || targetPos == null) {
            return false;
        }
        double area = spellRing.getAttributeValue(world, AttributeRegistry.AREA, spell);
        if (caster instanceof EntityPlayer) {
            IBlockState selected = instance.getSelectedBlockState((EntityLivingBase)((EntityPlayer)caster));
            if (selected == null) {
                return true;
            }
            IBlockState targetState = world.func_180495_p(targetPos);
            List<ItemStack> stacks = instance.getAllOfStackFromInventory((EntityPlayer)caster, selected);
            if (stacks.isEmpty()) {
                return true;
            }
            int stackCount = instance.getCountOfStacks(stacks);
            Set<BlockPos> blocks = BlockUtils.blocksInSquare(targetPos, facing, Math.min(stackCount, (int)area), MathHelper.func_76123_f((float)MathHelper.func_76133_a((double)area)) / 2, pos -> {
                BlockPos front = pos.func_177972_a(facing);
                if (!world.func_180495_p(front).func_177230_c().func_176200_f((IBlockAccess)world, front)) {
                    return true;
                }
                IBlockState state = world.func_180495_p(pos);
                return state.func_177230_c() != targetState.func_177230_c();
            });
            if (blocks.isEmpty()) {
                blocks.add(targetPos);
            }
            for (BlockPos pos2 : blocks) {
                if (!spellRing.taxCaster(world, spell, 1.0 / area, false)) {
                    return false;
                }
                ItemStack availableStack = instance.getAvailableStack(stacks);
                if (availableStack == null) {
                    return true;
                }
                BlockUtils.placeBlock(world, pos2, facing, availableStack);
            }
        } else {
            List items = world.func_72872_a(EntityItem.class, new AxisAlignedBB(targetPos).func_72314_b(3.0, 3.0, 3.0));
            if (items.isEmpty()) {
                return true;
            }
            EntityItem item = (EntityItem)items.get(0);
            if (item == null) {
                return true;
            }
            if (item.func_92059_d().func_77973_b() instanceof ItemBlock) {
                if (!spellRing.taxCaster(world, spell, true)) {
                    return false;
                }
                BlockUtils.placeBlock(world, targetPos, facing, item.func_92059_d());
            }
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d position = spell.getTarget(world);
        if (position == null) {
            return;
        }
        LibParticles.EXPLODE(world, position, instance.getPrimaryColor(), instance.getSecondaryColor(), 0.2, 0.3, 20, 40, 10, true);
    }

    @Override
    @NotNull
    public SpellData renderVisualization(@Nonnull World world, ModuleInstanceEffect instance, @Nonnull SpellData data, @Nonnull SpellRing ring, float partialTicks) {
        if (ring.getParentRing() != null && ring.getParentRing().getModule() != null && ring.getParentRing().getModule().getModuleClass() instanceof ModuleShapeZone) {
            return data;
        }
        BlockPos targetPos = data.getData(SpellData.DefaultKeys.BLOCK_HIT);
        EnumFacing facing = data.getFaceHit();
        Entity caster = data.getCaster(world);
        if (facing == null || targetPos == null) {
            return data;
        }
        double area = ring.getAttributeValue(world, AttributeRegistry.AREA, data);
        if (caster instanceof EntityPlayer) {
            IBlockState selected = instance.getSelectedBlockState((EntityLivingBase)((EntityPlayer)caster));
            if (selected == null) {
                return data;
            }
            IBlockState targetState = world.func_180495_p(targetPos);
            List<ItemStack> stacks = instance.getAllOfStackFromInventory((EntityPlayer)caster, selected);
            if (stacks.isEmpty()) {
                return data;
            }
            int stackCount = instance.getCountOfStacks(stacks);
            Set<BlockPos> blocks = BlockUtils.blocksInSquare(targetPos, facing, Math.min(stackCount, (int)area), (int)((Math.sqrt(area) + 1.0) / 2.0), pos -> {
                if (BlockUtils.isAnyAir(targetState)) {
                    return true;
                }
                BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos);
                IBlockState adjacentState = instance.getCachableBlockstate(world, mutable.func_177972_a(facing), data);
                if (adjacentState.func_177230_c() != Blocks.field_150350_a) {
                    return true;
                }
                IBlockState state = instance.getCachableBlockstate(world, (BlockPos)pos, data);
                return state.func_177230_c() != targetState.func_177230_c();
            });
            if (blocks.isEmpty()) {
                if (targetState.func_177230_c() == Blocks.field_150350_a) {
                    RenderUtils.drawCubeOutline(world, targetPos, targetState);
                } else {
                    RenderUtils.drawFaceOutline(targetPos, facing);
                }
            } else {
                for (BlockPos areaPos : blocks) {
                    BlockPos pos2 = areaPos.func_177972_a(facing);
                    BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos2);
                    for (EnumFacing facing1 : EnumFacing.field_82609_l) {
                        mutable.func_189536_c(facing1);
                        if (blocks.contains(mutable)) {
                            RenderUtils.drawFaceOutline((BlockPos)mutable, facing1.func_176734_d());
                        }
                        mutable.func_189536_c(facing1.func_176734_d());
                    }
                }
            }
        }
        return data;
    }
}

