/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.ContextRing;
import com.teamwizardry.wizardry.api.spell.annotation.ModuleOverride;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.BlockUtils;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.init.ModPotions;
import com.teamwizardry.wizardry.init.ModSounds;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_frost")
public class ModuleEffectFrost
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_aoe", "modifier_extend_time"};
    }

    @ModuleOverride(value="shape_zone_run")
    public boolean onRunZone(World world, SpellData data, SpellRing ring, @ContextRing SpellRing childRing) {
        double aoe = ring.getAttributeValue(world, AttributeRegistry.AREA, data);
        double range = ring.getAttributeValue(world, AttributeRegistry.RANGE, data);
        Vec3d targetPos = data.getTarget(world);
        if (targetPos == null) {
            return false;
        }
        Vec3d min = targetPos.func_178786_a(aoe, range, aoe);
        Vec3d max = targetPos.func_72441_c(aoe, range, aoe);
        List entities = world.func_72839_b(null, new AxisAlignedBB(min, max));
        for (Entity entity : entities) {
            entity.func_70066_B();
            if (!(entity instanceof EntityLivingBase) || ((EntityLivingBase)entity).func_70644_a((Potion)ModPotions.SLIPPERY) || !(entity.func_70092_e(targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c) <= aoe * aoe)) continue;
            double time = childRing.getAttributeValue(world, AttributeRegistry.DURATION, data) * 10.0f;
            world.func_184133_a(null, entity.func_180425_c(), (SoundEvent)ModSounds.FROST_FORM, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            ((EntityLivingBase)entity).func_70690_d(new PotionEffect((Potion)ModPotions.SLIPPERY, (int)time, 0, true, false));
        }
        return false;
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Entity targetEntity = spell.getVictim(world);
        BlockPos targetPos = spell.getTargetPos();
        Entity caster = spell.getCaster(world);
        double range = spellRing.getAttributeValue(world, AttributeRegistry.AREA, spell) / 2.0f;
        double time = spellRing.getAttributeValue(world, AttributeRegistry.DURATION, spell) * 10.0f;
        if (!spellRing.taxCaster(world, spell, true)) {
            return false;
        }
        if (targetEntity != null) {
            world.func_184133_a(null, targetEntity.func_180425_c(), (SoundEvent)ModSounds.FROST_FORM, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            targetEntity.func_70066_B();
            if (targetEntity instanceof EntityLivingBase) {
                ((EntityLivingBase)targetEntity).func_70690_d(new PotionEffect((Potion)ModPotions.SLIPPERY, (int)time, 0, true, false));
            }
        }
        if (targetPos != null) {
            world.func_184133_a(null, targetPos, (SoundEvent)ModSounds.FROST_FORM, SoundCategory.NEUTRAL, 1.0f, 1.0f);
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)targetPos.func_177963_a(-range, -range, -range), (BlockPos)targetPos.func_177963_a(range + 1.0, range + 1.0, range + 1.0))) {
                double dist = pos.func_177951_i((Vec3i)targetPos);
                if (dist > range) continue;
                for (EnumFacing facing : EnumFacing.field_82609_l) {
                    IBlockState state = world.func_180495_p(pos.func_177972_a(facing));
                    if (state.func_177230_c() != Blocks.field_150480_ab) continue;
                    BlockUtils.breakBlock(world, pos.func_177972_a(facing), state, BlockUtils.makeBreaker(world, pos, caster));
                }
                BlockPos up = pos.func_177972_a(EnumFacing.UP);
                if (world.func_180495_p(pos).isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) && world.func_175623_d(up)) {
                    int layerSize = (int)Math.max(1.0, Math.min(8.0, Math.max(1.0, dist / range * 6.0)));
                    layerSize = Math.max(1, Math.min(layerSize + RandUtil.nextInt(-1, 1), 8));
                    BlockUtils.placeBlock(world, up, Blocks.field_150431_aC.func_176223_P().func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(layerSize)), BlockUtils.makePlacer(world, up, caster));
                }
                if (world.func_180495_p(pos).func_177230_c() != Blocks.field_150355_j) continue;
                BlockUtils.placeBlock(world, pos, Blocks.field_150432_aD.func_176223_P(), BlockUtils.makePlacer(world, pos, caster));
            }
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d position = spell.getTarget(world);
        if (position == null) {
            return;
        }
        ParticleBuilder glitter = new ParticleBuilder(1);
        glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.0f, 0.1f));
        glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
        glitter.enableMotionCalculation();
        glitter.setScaleFunction((InterpFunction)new InterpScale(1.0f, 0.0f));
        glitter.setAcceleration(new Vec3d(0.0, -0.02, 0.0));
        glitter.setCollision(true);
        glitter.setCanBounce(true);
        ParticleSpawner.spawn((ParticleBuilder)glitter, (World)world, (InterpFunction)new StaticInterp((Object)position), (int)RandUtil.nextInt(5, 15), (int)0, (aFloat, particleBuilder) -> {
            double radius = 2.0;
            double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
            double r = radius * (double)RandUtil.nextFloat();
            double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
            double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
            glitter.setScale(RandUtil.nextFloat());
            glitter.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(-2.0, 2.0), z));
            glitter.setLifetime(RandUtil.nextInt(50, 100));
            Vec3d direction = position.func_178787_e(glitter.getPositionOffset()).func_178788_d(position).func_72432_b().func_186678_a(0.0);
            glitter.addMotion(direction.func_186678_a(RandUtil.nextDouble(0.5, 1.0)));
        });
    }
}

