/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.module.effects;

import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.annotation.RegisterModule;
import com.teamwizardry.wizardry.api.spell.attribute.AttributeRegistry;
import com.teamwizardry.wizardry.api.spell.module.IModuleEffect;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceEffect;
import com.teamwizardry.wizardry.api.util.BlockUtils;
import com.teamwizardry.wizardry.api.util.RenderUtils;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.common.module.shapes.ModuleShapeZone;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@RegisterModule(ID="effect_break")
public class ModuleEffectBreak
implements IModuleEffect {
    @Override
    public String[] compatibleModifiers() {
        return new String[]{"modifier_increase_aoe", "modifier_increase_potency"};
    }

    @Override
    public boolean run(@NotNull World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        BlockPos targetPos = spell.getData(SpellData.DefaultKeys.BLOCK_HIT);
        EnumFacing facing = spell.getData(SpellData.DefaultKeys.FACE_HIT);
        Entity targetEntity = spell.getVictim(world);
        Entity caster = spell.getCaster(world);
        double range = spellRing.getAttributeValue(world, AttributeRegistry.AREA, spell);
        double strength = spellRing.getAttributeValue(world, AttributeRegistry.POTENCY, spell);
        if (targetEntity instanceof EntityLivingBase) {
            for (ItemStack stack : targetEntity.func_184193_aE()) {
                stack.func_77972_a((int)strength, (EntityLivingBase)targetEntity);
            }
        }
        if (targetPos == null || facing == null) {
            return false;
        }
        Set<BlockPos> blocks = BlockUtils.blocksInSquare(targetPos, facing, (int)range, (int)((Math.sqrt(range) + 1.0) / 2.0), pos -> {
            if (world.func_175623_d(pos)) {
                return true;
            }
            if (!world.func_175623_d(pos.func_177972_a(facing))) {
                return true;
            }
            IBlockState state = world.func_180495_p(pos);
            float hardness = state.func_185887_b(world, pos);
            return hardness < 0.0f || (double)hardness > strength;
        });
        for (BlockPos pos2 : blocks) {
            if (!spellRing.taxCaster(world, spell, 1.0 / range, false)) {
                return false;
            }
            IBlockState state = world.func_180495_p(pos2);
            BlockUtils.breakBlock(world, pos2, state, BlockUtils.makeBreaker(world, pos2, caster));
            world.func_175718_b(2001, pos2, Block.func_176210_f((IBlockState)state));
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderSpell(World world, ModuleInstanceEffect instance, @Nonnull SpellData spell, @Nonnull SpellRing spellRing) {
        Vec3d position = spell.getTarget(world);
        if (position == null) {
            return;
        }
        LibParticles.EXPLODE(world, position, instance.getPrimaryColor(), instance.getSecondaryColor(), 0.2, 0.3, 20, 40, 10, true);
    }

    @Override
    @NotNull
    public SpellData renderVisualization(@Nonnull World world, ModuleInstanceEffect instance, @Nonnull SpellData data, @Nonnull SpellRing ring, float partialTicks) {
        if (ring.getParentRing() != null && ring.getParentRing().getModule() != null && ring.getParentRing().getModule().getModuleClass() instanceof ModuleShapeZone) {
            return data;
        }
        BlockPos targetPos = data.getData(SpellData.DefaultKeys.BLOCK_HIT);
        EnumFacing facing = data.getData(SpellData.DefaultKeys.FACE_HIT);
        double range = ring.getAttributeValue(world, AttributeRegistry.AREA, data);
        double strength = ring.getAttributeValue(world, AttributeRegistry.POTENCY, data);
        if (targetPos == null || facing == null) {
            return data;
        }
        Set<BlockPos> blocks = BlockUtils.blocksInSquare(targetPos, facing, (int)range, (int)((Math.sqrt(range) + 1.0) / 2.0), pos -> {
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos);
            if (!world.func_175623_d(mutable.func_177972_a(facing))) {
                return true;
            }
            IBlockState state = world.func_180495_p(pos);
            if (BlockUtils.isAnyAir(state)) {
                return true;
            }
            float hardness = state.func_185887_b(world, pos);
            return hardness < 0.0f || (double)hardness > strength;
        });
        if (blocks.isEmpty()) {
            return data;
        }
        for (BlockPos pos2 : blocks) {
            IBlockState state = world.func_180495_p(pos2);
            BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos(pos2);
            for (EnumFacing face : EnumFacing.field_82609_l) {
                mutable.func_189536_c(face);
                IBlockState adjStat = instance.getCachableBlockstate(world, (BlockPos)mutable, data);
                if (adjStat.func_177230_c() != state.func_177230_c() || !blocks.contains(mutable)) {
                    RenderUtils.drawFaceOutline((BlockPos)mutable, face.func_176734_d());
                }
                mutable.func_189536_c(face.func_176734_d());
            }
        }
        return data;
    }
}

