/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.item.pearlbelt;

import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.wizardry.api.item.INacreProduct;
import com.teamwizardry.wizardry.api.item.pearlswapping.IPearlStorageHolder;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kotlin.jvm.functions.Function2;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public interface IPearlBelt
extends IPearlStorageHolder,
INacreProduct.INacreDecayProduct {
    default public void addBeltColorProperty(Item item) {
        item.func_185043_a(new ResourceLocation("slot"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                IItemHandler handler = IPearlBelt.this.getPearls(stack);
                if (handler == null) {
                    return 0.0f;
                }
                int total = 0;
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack pearl = handler.getStackInSlot(i);
                    if (pearl.func_190926_b()) continue;
                    ++total;
                }
                return MathHelper.func_76125_a((int)total, (int)0, (int)6);
            }
        });
    }

    default public IItemHandler getBeltPearls(ItemStack stack) {
        return (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    default public Function2<ItemStack, Integer, Integer> getBeltColorFunction() {
        return (pearlBelt, tintIndex) -> {
            if (tintIndex == 0) {
                return 0xFFFFFF;
            }
            IItemHandler handler = this.getPearls((ItemStack)pearlBelt);
            if (handler == null) {
                return 0;
            }
            ItemStack stack = handler.getStackInSlot(tintIndex - 1);
            if (stack.func_190926_b()) {
                return 0xFFFFFF;
            }
            if (!stack.func_77942_o()) {
                return Color.HSBtoRGB(MathHelper.func_76126_a((float)((float)Minecraft.func_71410_x().field_71441_e.func_82737_E() / 140.0f)), 0.75f, 1.0f);
            }
            long lastCast = NBTHelper.getLong((ItemStack)stack, (String)"last_cast", (long)-1L);
            int decayCooldown = NBTHelper.getInt((ItemStack)stack, (String)"last_cooldown", (int)-1);
            long tick = Minecraft.func_71410_x().field_71441_e.func_82737_E();
            long timeSinceCooldown = tick - lastCast;
            float decayStage = decayCooldown > 0 ? (float)timeSinceCooldown / (float)decayCooldown : 1.0f;
            float rand = NBTHelper.getFloat((ItemStack)stack, (String)"rand", (float)-1.0f);
            float hue = rand < 0.0f ? (float)tick / 140.0f % 140.0f : rand;
            float pow = Math.min(1.0f, Math.max(0.0f, this.getQuality(stack)));
            double decaySaturation = lastCast == -1L || decayCooldown <= 0 || decayStage >= 1.0f ? 1.0 : ((double)decayStage < 0.16666666666666666 ? Math.pow(Math.E, -15.0f * decayStage) : Math.pow(Math.E, 3.0f * decayStage - 3.0f));
            float saturation = 1.1864825f * (1.0f - (float)Math.pow(Math.E, -pow)) * (float)decaySaturation;
            return Color.HSBtoRGB(hue, saturation, 1.0f);
        };
    }
}

