/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.item;

import com.teamwizardry.librarianlib.features.base.item.IItemColorProvider;
import com.teamwizardry.librarianlib.features.base.item.ItemMod;
import com.teamwizardry.wizardry.api.capability.player.mana.CustomManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaCapabilityProvider;
import com.teamwizardry.wizardry.api.capability.player.mana.ManaManager;
import com.teamwizardry.wizardry.api.item.IManaCell;
import com.teamwizardry.wizardry.common.block.fluid.ModFluids;
import com.teamwizardry.wizardry.init.ModItems;
import java.awt.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kotlin.jvm.functions.Function2;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class ItemOrb
extends ItemMod
implements IManaCell,
IItemColorProvider {
    public ItemOrb() {
        super("orb", new String[]{"glass_orb", "mana_orb"});
        this.func_185043_a(new ResourceLocation("fill"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                double mana = ManaManager.getMana(stack);
                double maxMana = ManaManager.getMaxMana(stack);
                return (float)((int)(10.0 * mana / maxMana)) / 10.0f;
            }
        });
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ManaCapabilityProvider(new CustomManaCapability(100.0, 100.0, stack.func_77952_i() * 100, 0.0));
    }

    public boolean onEntityItemUpdate(EntityItem entityItem) {
        if (entityItem.func_92059_d().func_77952_i() == 0) {
            if (!ManaManager.isManaEmpty(entityItem.func_92059_d())) {
                entityItem.func_92059_d().func_77964_b(1);
            } else {
                IBlockState state = entityItem.field_70170_p.func_180495_p(entityItem.func_180425_c());
                if (state.func_177230_c() == ModFluids.NACRE.getActualBlock()) {
                    ItemStack newStack = new ItemStack((Item)ModItems.PEARL_NACRE, entityItem.func_92059_d().func_190916_E());
                    entityItem.func_92058_a(newStack);
                    newStack.func_77973_b().onEntityItemUpdate(entityItem);
                }
            }
        } else if (entityItem.func_92059_d().func_77952_i() == 1) {
            if (ManaManager.isManaEmpty(entityItem.func_92059_d())) {
                entityItem.func_92059_d().func_77964_b(0);
            } else {
                IBlockState state = entityItem.field_70170_p.func_180495_p(entityItem.func_180425_c());
                if (state.func_177230_c() == ModFluids.MANA.getActualBlock()) {
                    ManaManager.forObject(entityItem.func_92059_d()).setMana(ManaManager.getMaxMana(entityItem.func_92059_d())).close();
                }
            }
        }
        return super.onEntityItemUpdate(entityItem);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (ManaManager.isManaEmpty(stack) && stack.func_77952_i() == 1) {
            stack.func_77964_b(0);
        } else if (!ManaManager.isManaEmpty(stack) && stack.func_77952_i() == 0) {
            stack.func_77964_b(1);
        }
    }

    @NotNull
    public String func_77667_c(@NotNull ItemStack stack) {
        float percentage = (float)((int)(10.0 * ManaManager.getMana(stack) / ManaManager.getMaxMana(stack))) / 10.0f;
        return super.func_77667_c(stack) + ".fill." + (int)(percentage * 100.0f);
    }

    public void func_150895_a(@Nullable CreativeTabs tab, @Nonnull NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            for (int i = 1; i < 10; ++i) {
                ItemStack stack = new ItemStack((Item)this, 1, 1);
                ManaManager.forObject(stack).setMana(ManaManager.getMaxMana(stack) * (double)i / 10.0).close();
                subItems.add((Object)stack);
            }
            subItems.add((Object)new ItemStack((Item)this, 1, 1));
        }
    }

    @Nullable
    public Function2<ItemStack, Integer, Integer> getItemColorFunction() {
        return (stack, tintIndex) -> tintIndex == 0 && stack.func_77952_i() == 1 ? Color.CYAN.getRGB() : 0xFFFFFF;
    }
}

