/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.entity.angel.zachriel;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.saving.AbstractSaveHandler;
import com.teamwizardry.librarianlib.features.saving.SaveInPlace;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import com.teamwizardry.wizardry.api.arena.Arena;
import com.teamwizardry.wizardry.api.arena.ArenaManager;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.common.core.nemez.NemezEventHandler;
import com.teamwizardry.wizardry.common.core.nemez.NemezTracker;
import com.teamwizardry.wizardry.common.entity.angel.EntityAngel;
import com.teamwizardry.wizardry.common.entity.angel.zachriel.EntityCorruptionArea;
import com.teamwizardry.wizardry.init.ModItems;
import com.teamwizardry.wizardry.init.ModPotions;
import java.awt.Color;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SaveInPlace
public class EntityZachriel
extends EntityAngel {
    public static final float burstDamage = 10.0f;
    public static final float burstCorruptionScaling = 0.25f;
    private static int timeReverseTick = 200;
    public boolean saveTime = false;
    public boolean reverseTime = false;
    public int numSaves = 0;
    public int numLoads = 0;
    public float[] saveTimes = new float[]{0.8333333f, 0.5f, 0.16666667f};
    public int nextBurst = 0;
    public int nextBurstSave = -1;
    public float[] loadTimes = new float[]{0.6666667f, 0.33333334f, 1.0f / this.func_110138_aP()};
    public int burstTimer = 0;
    public float[] burstLevels = new float[]{0.95f, 0.85f, 0.75f, 0.65f, 0.55f, 0.45f, 0.35f, 0.25f, 0.15f, 0.05f};
    public Arena arena = null;
    public NemezTracker nemezDrive = new NemezTracker();

    public EntityZachriel(World world) {
        super(world);
        this.func_96094_a("Zachriel");
        this.func_70105_a(1.2f, 3.2f);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(300.0);
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (this.arena == null) {
            HashSet<UUID> players = new HashSet<UUID>();
            this.arena = new Arena(this.func_130014_f_().field_73011_w.getDimension(), this.func_180425_c(), 50.0, 50.0, this.func_145782_y(), players);
            ArenaManager.INSTANCE.addArena(this.arena);
        }
        if (this.burstTimer > 0) {
            return false;
        }
        boolean result = super.func_70097_a(source, amount);
        if (source.equals(DamageSource.field_76380_i)) {
            this.numLoads = this.loadTimes.length;
            return super.func_70097_a(source, amount);
        }
        if (!this.field_70170_p.field_72995_K) {
            float healthPercent = this.func_110143_aJ() / this.func_110138_aP();
            if (this.numSaves < this.saveTimes.length && healthPercent < this.saveTimes[this.numSaves]) {
                ++this.numSaves;
                this.nextBurstSave = this.nextBurst;
            }
            if (this.numLoads < this.loadTimes.length && healthPercent < this.loadTimes[this.numLoads]) {
                this.func_70606_j(this.func_110138_aP() * this.saveTimes[this.numLoads]);
                ++this.numLoads;
                this.nextBurst = this.nextBurstSave;
                if (this.field_70128_L) {
                    this.field_70128_L = false;
                }
                NemezEventHandler.reverseTime(this.field_70170_p, this.nemezDrive, this.arena.getCenter());
            }
            if (this.nextBurst < this.burstLevels.length && healthPercent < this.burstLevels[this.nextBurst]) {
                ++this.nextBurst;
                this.burstTimer = 60;
            }
        }
        return result;
    }

    public void func_70645_a(@Nonnull DamageSource source) {
        if (this.numLoads < this.loadTimes.length) {
            return;
        }
        super.func_70645_a(source);
    }

    @Override
    public void func_70071_h_() {
        List corruptionList;
        this.field_70181_x = 0.0;
        super.func_70071_h_();
        if (this.arena == null) {
            Iterator players = new HashSet();
            this.arena = new Arena(this.func_130014_f_().field_73011_w.getDimension(), this.func_180425_c(), 50.0, 50.0, this.func_145782_y(), (Set<UUID>)((Object)players));
            ArenaManager.INSTANCE.addArena(this.arena);
        }
        for (EntityLivingBase targeted : this.arena.getVictims()) {
            this.nemezDrive.trackEntity((Entity)targeted);
        }
        if (this.burstTimer > 0) {
            --this.burstTimer;
            if (this.burstTimer == 0 && !this.field_70170_p.field_72995_K) {
                for (EntityPlayer player : this.field_70170_p.field_73010_i) {
                    if (!EntitySelectors.field_188444_d.apply((Object)player) || !(this.func_70068_e((Entity)player) < 1024.0)) continue;
                    PotionEffect corruption = player.func_70660_b((Potion)ModPotions.ZACH_CORRUPTION);
                    float bonusDamage = corruption == null ? 0.0f : 10.0f * (float)(corruption.func_76458_c() + 1);
                    player.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this).func_82726_p().func_76348_h(), 10.0f + bonusDamage);
                }
            }
            ClientRunnable.run((ClientRunnable)new ClientRunnable(){

                @SideOnly(value=Side.CLIENT)
                public void runIfClient() {
                    ParticleBuilder glitter = new ParticleBuilder(RandUtil.nextInt(30, 50));
                    glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
                    glitter.enableMotionCalculation();
                    glitter.setCollision(EntityZachriel.this.burstTimer > 0);
                    glitter.setCanBounce(EntityZachriel.this.burstTimer > 0);
                    glitter.setAcceleration(new Vec3d(0.0, -0.035, 0.0));
                    glitter.setColor(new Color(255, 0, 206));
                    glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.5f, 0.0f));
                    ParticleSpawner.spawn((ParticleBuilder)glitter, (World)EntityZachriel.this.field_70170_p, (InterpFunction)new StaticInterp((Object)EntityZachriel.this.func_174791_d()), (int)1, (int)1, (i, build) -> {
                        double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
                        double r = EntityZachriel.this.burstTimer > 0 ? (EntityZachriel.this.func_174813_aQ().field_72336_d - EntityZachriel.this.func_174813_aQ().field_72340_a) / 2.0 * (double)RandUtil.nextFloat(0.01f, 1.0f) : (double)(32.0f * RandUtil.nextFloat());
                        double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
                        double y = (EntityZachriel.this.func_174813_aQ().field_72337_e - EntityZachriel.this.func_174813_aQ().field_72338_b) * (double)RandUtil.nextFloat();
                        double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
                        build.setPositionOffset(new Vec3d(x, y, z));
                        build.addMotion(new Vec3d(0.0, RandUtil.nextDouble(0.01, 0.15), 0.0));
                    });
                }
            });
        }
        if (!this.field_70170_p.field_72995_K && (corruptionList = this.field_70170_p.func_72872_a(EntityCorruptionArea.class, new AxisAlignedBB(this.func_180425_c()).func_186662_g(2.0))).isEmpty()) {
            EntityCorruptionArea corruption = new EntityCorruptionArea(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.field_70170_p.func_72838_d((Entity)corruption);
        }
        this.nemezDrive.endUpdate();
    }

    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (player.func_184614_ca().func_77973_b() == ModItems.MAGIC_WAND) {
            HashSet<UUID> players = new HashSet<UUID>();
            players.add(player.func_110124_au());
            ArenaManager.INSTANCE.addArena(new Arena(player.field_70170_p.field_73011_w.getDimension(), this.func_180425_c(), 10.0, 10.0, this.func_145782_y(), players));
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        this.func_70099_a(new ItemStack(ModItems.REAL_HALO), 0.0f);
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
    }

    @Override
    public void writeCustomNBT(@Nonnull NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        compound.func_74782_a("save", AbstractSaveHandler.writeAutoNBT((Object)((Object)this), (boolean)true));
        compound.func_74782_a("nemez", (NBTBase)this.nemezDrive.serializeNBT());
    }

    @Override
    public void readCustomNBT(@Nonnull NBTTagCompound compound) {
        super.readCustomNBT(compound);
        AbstractSaveHandler.readAutoNBT((Object)((Object)this), (NBTBase)compound.func_74775_l("save"), (boolean)true);
        this.nemezDrive.deserializeNBT(compound.func_150295_c("nemez", 10));
    }
}

