/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.entity.ai;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.AxisAlignedBB;

public class EntityAINearestAttackableTargetFiltered<T extends EntityLivingBase>
extends EntityAITarget {
    protected final Class<T> targetClass;
    protected final EntityAINearestAttackableTarget.Sorter sorter;
    protected final Predicate<? super T> targetEntitySelector;
    private final int targetChance;
    protected T targetEntity;

    public EntityAINearestAttackableTargetFiltered(EntityCreature creature, Class<T> classTarget, boolean checkSight) {
        this(creature, classTarget, checkSight, false);
    }

    public EntityAINearestAttackableTargetFiltered(EntityCreature creature, Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
        this(creature, classTarget, 10, checkSight, onlyNearby, null);
    }

    public EntityAINearestAttackableTargetFiltered(EntityCreature creature, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby, @Nullable Predicate<? super T> targetSelector) {
        super(creature, checkSight, onlyNearby);
        this.targetClass = classTarget;
        this.targetChance = chance;
        this.sorter = new EntityAINearestAttackableTarget.Sorter((Entity)creature);
        this.func_75248_a(1);
        UUID exclude = creature.getEntityData().func_186857_a("owner");
        this.targetEntitySelector = entity -> entity != null && !entity.func_110124_au().equals(exclude) && (targetSelector == null || targetSelector.apply(entity) && EntitySelectors.field_180132_d.apply(entity) && this.func_75296_a((EntityLivingBase)entity, false));
    }

    public boolean func_75250_a() {
        if (this.targetChance > 0 && this.field_75299_d.func_70681_au().nextInt(this.targetChance) != 0) {
            return false;
        }
        if (this.targetClass != EntityPlayer.class && this.targetClass != EntityPlayerMP.class) {
            List list = this.field_75299_d.field_70170_p.func_175647_a(this.targetClass, this.getTargetableArea(this.func_111175_f()), this.targetEntitySelector);
            if (list.isEmpty()) {
                return false;
            }
            list.sort(this.sorter);
            this.targetEntity = (EntityLivingBase)list.get(0);
            return true;
        }
        this.targetEntity = this.field_75299_d.field_70170_p.func_184150_a(this.field_75299_d.field_70165_t, this.field_75299_d.field_70163_u + (double)this.field_75299_d.func_70047_e(), this.field_75299_d.field_70161_v, this.func_111175_f(), this.func_111175_f(), (Function)new Function<EntityPlayer, Double>(){

            @Nullable
            public Double apply(@Nullable EntityPlayer p_apply_1_) {
                ItemStack itemstack = p_apply_1_.func_184582_a(EntityEquipmentSlot.HEAD);
                if (itemstack.func_77973_b() == Items.field_151144_bL) {
                    boolean flag2;
                    int i = itemstack.func_77952_i();
                    boolean flag = EntityAINearestAttackableTargetFiltered.this.field_75299_d instanceof EntitySkeleton && i == 0;
                    boolean flag1 = EntityAINearestAttackableTargetFiltered.this.field_75299_d instanceof EntityZombie && i == 2;
                    boolean bl = flag2 = EntityAINearestAttackableTargetFiltered.this.field_75299_d instanceof EntityCreeper && i == 4;
                    if (flag || flag1 || flag2) {
                        return 0.5;
                    }
                }
                return 1.0;
            }
        }, this.targetEntitySelector);
        return this.targetEntity != null;
    }

    protected AxisAlignedBB getTargetableArea(double targetDistance) {
        return this.field_75299_d.func_174813_aQ().func_72314_b(targetDistance, 4.0, targetDistance);
    }

    public void func_75249_e() {
        this.field_75299_d.func_70624_b(this.targetEntity);
        super.func_75249_e();
    }
}

