/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.entity;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.StaticInterp;
import com.teamwizardry.librarianlib.features.math.interpolate.numeric.InterpFloatInOut;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawner;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import com.teamwizardry.wizardry.api.util.RandUtil;
import com.teamwizardry.wizardry.api.util.RandUtilSeed;
import com.teamwizardry.wizardry.api.util.interp.InterpScale;
import com.teamwizardry.wizardry.client.fx.LibParticles;
import com.teamwizardry.wizardry.init.ModSounds;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySpiritBlight
extends EntityMob {
    public static final DataParameter<Integer> DATA_SHIFT_SEED = EntityDataManager.func_187226_a(EntitySpiritBlight.class, (DataSerializer)DataSerializers.field_187192_b);

    public EntitySpiritBlight(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.95f);
        this.field_70728_aV = 5;
        this.setShiftseed(RandUtil.nextInt(100, 100000));
    }

    public void setShiftseed(int seed) {
        this.func_184212_Q().func_187227_b(DATA_SHIFT_SEED, (Object)seed);
        this.func_184212_Q().func_187217_b(DATA_SHIFT_SEED);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70178_ae = true;
        this.func_184212_Q().func_187214_a(DATA_SHIFT_SEED, (Object)RandUtil.nextInt(100, 1000000));
    }

    protected void func_184651_r() {
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(75.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
    }

    protected void func_175456_n() {
    }

    public void func_82167_n(Entity entity) {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.func_175446_cd()) {
            return;
        }
        if (RandUtil.nextInt(10) == 0) {
            this.setShiftseed(RandUtil.nextInt(1000, 100000000));
            this.func_184185_a((SoundEvent)ModSounds.ZAP, 0.3f, RandUtil.nextFloat(1.5f, 2.0f));
        }
        if (this.field_70173_aa % RandUtil.nextInt(100, 200) == 0) {
            this.func_184185_a((SoundEvent)ModSounds.HALLOWED_SPIRIT, RandUtil.nextFloat(), RandUtil.nextFloat());
        }
        this.field_70143_R = 0.0f;
        EntityPlayer farPlayer = this.field_70170_p.func_184136_b((Entity)this, 300.0);
        this.func_70624_b((EntityLivingBase)farPlayer);
        if (this.func_70638_az() != null) {
            this.field_70145_X = true;
            Vec3d direction = this.func_174791_d().func_178788_d(this.func_70638_az().func_174791_d()).func_72432_b();
            this.field_70159_w = direction.field_72450_a * -0.05;
            this.field_70181_x = direction.field_72448_b * -0.05;
            this.field_70179_y = direction.field_72449_c * -0.05;
            this.field_70177_z = (float)(-MathHelper.func_181159_b((double)direction.field_72450_a, (double)direction.field_72449_c) * 180.0 / Math.PI - 180.0) / 2.0f;
        } else {
            if (!this.field_70124_G) {
                this.field_70181_x = 0.0;
            }
            this.field_70145_X = false;
        }
        EntityPlayer player = this.func_70638_az() == null ? null : this.field_70170_p.func_184136_b((Entity)this, 2.0);
        EntityPlayer closePlayer = this.func_70638_az() == null ? null : this.field_70170_p.func_184136_b((Entity)this, 30.0);
        boolean angry = player != null;
        ClientRunnable.run((ClientRunnable)new ClientRunnable(){

            @SideOnly(value=Side.CLIENT)
            public void runIfClient() {
                ParticleBuilder glitter = new ParticleBuilder(30);
                glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
                glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(1.0f, 1.0f));
                glitter.setColor(new Color(15992020));
                RandUtilSeed seed = new RandUtilSeed(((Integer)EntitySpiritBlight.this.func_184212_Q().func_187225_a(DATA_SHIFT_SEED)).intValue());
                Vec3d offset = new Vec3d(seed.nextDouble(-3.0, 3.0), seed.nextDouble(-3.0, 3.0), seed.nextDouble(-3.0, 3.0));
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)EntitySpiritBlight.this.field_70170_p, (InterpFunction)new StaticInterp((Object)EntitySpiritBlight.this.func_174791_d().func_72441_c(0.0, (double)EntitySpiritBlight.this.func_70047_e(), 0.0).func_178787_e(offset)), (int)10, (int)0, (i, build) -> {
                    double radius = 0.1;
                    double theta = (float)Math.PI * 2 * RandUtil.nextFloat();
                    double r = radius * (double)RandUtil.nextFloat();
                    double x = r * (double)MathHelper.func_76134_b((float)((float)theta));
                    double z = r * (double)MathHelper.func_76126_a((float)((float)theta));
                    glitter.setLifetime(RandUtil.nextInt(10, 40));
                    glitter.setScaleFunction((InterpFunction)new InterpScale(0.0f, (float)RandUtil.nextDouble(3.0, 4.0)));
                    glitter.setPositionOffset(new Vec3d(x, RandUtil.nextDouble(0.0, 0.2), z));
                    if (RandUtil.nextInt(15) == 0) {
                        glitter.addMotion(new Vec3d(RandUtil.nextDouble(-0.01, 0.01), RandUtil.nextDouble(-0.03, 0.0), RandUtil.nextDouble(-0.01, 0.01)));
                    }
                });
            }
        });
        if (angry) {
            player.func_70097_a(DamageSource.field_76376_m, 0.15f);
            player.field_70172_ad = 0;
        }
    }

    public int func_70070_b() {
        return 255;
    }

    public void func_184610_a(boolean wasRecentlyHit, int lootingModifier, @Nonnull DamageSource source) {
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        if (source.func_82725_o()) {
            super.func_70097_a(source, amount);
            ClientRunnable.run((ClientRunnable)new ClientRunnable(){

                @SideOnly(value=Side.CLIENT)
                public void runIfClient() {
                    LibParticles.SPIRIT_WIGHT_HURT(EntitySpiritBlight.this.field_70170_p, EntitySpiritBlight.this.func_174791_d());
                }
            });
            return true;
        }
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        ClientRunnable.run((ClientRunnable)new ClientRunnable(){

            @SideOnly(value=Side.CLIENT)
            public void runIfClient() {
                ParticleBuilder glitter = new ParticleBuilder(RandUtil.nextInt(100, 150));
                glitter.setColor(Color.WHITE);
                glitter.setRender(new ResourceLocation("wizardry", "particles/sparkle_blurred"));
                glitter.setAlphaFunction((InterpFunction)new InterpFloatInOut(0.1f, 0.1f));
                glitter.setAcceleration(Vec3d.field_186680_a);
                ParticleSpawner.spawn((ParticleBuilder)glitter, (World)EntitySpiritBlight.this.field_70170_p, (InterpFunction)new StaticInterp((Object)EntitySpiritBlight.this.func_174791_d().func_72441_c(0.0, (double)EntitySpiritBlight.this.field_70131_O, 0.0)), (int)1000, (int)0, (i, build) -> {
                    double radius = 0.2;
                    build.setDeceleration(new Vec3d(RandUtil.nextDouble(0.8, 0.95), RandUtil.nextDouble(0.8, 0.95), RandUtil.nextDouble(0.8, 0.95)));
                    build.addMotion(new Vec3d(RandUtil.nextDouble(-radius, radius), RandUtil.nextDouble(-radius, radius), RandUtil.nextDouble(-radius, radius)));
                    build.setLifetime(RandUtil.nextInt(200, 250));
                    build.setScaleFunction((InterpFunction)new InterpScale(RandUtil.nextFloat(0.6f, 1.5f), 0.0f));
                    if (RandUtil.nextBoolean()) {
                        build.setColor(Color.WHITE);
                    } else {
                        build.setColor(new Color(15992020));
                    }
                });
            }
        });
        this.func_184185_a((SoundEvent)ModSounds.BASS_BOOM, 3.0f, 0.5f);
        this.func_184185_a((SoundEvent)ModSounds.BASS_BOOM, 1.0f, RandUtil.nextFloat(1.0f, 1.5f));
        super.func_70645_a(cause);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("shift_seed")) {
            this.func_184212_Q().func_187227_b(DATA_SHIFT_SEED, (Object)compound.func_74762_e("shift_seed"));
            this.func_184212_Q().func_187217_b(DATA_SHIFT_SEED);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("shift_seed", ((Integer)this.func_184212_Q().func_187225_a(DATA_SHIFT_SEED)).intValue());
    }
}

