/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.common.core.nemez;

import com.teamwizardry.librarianlib.features.methodhandles.MethodHandleHelper;
import javax.annotation.Nullable;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.FoodStats;

public final class EntityMoment {
    public static final EntityMoment EMPTY = new EntityMoment();
    private static final Function1<FoodStats, Object> exhaustionGetter = MethodHandleHelper.wrapperForGetter(FoodStats.class, (String[])new String[]{"field_75126_c", "foodExhaustionLevel"});
    private static final Function2<FoodStats, Object, Unit> exhaustionSetter = MethodHandleHelper.wrapperForSetter(FoodStats.class, (String[])new String[]{"field_75126_c", "foodExhaustionLevel"});
    private static final Function2<FoodStats, Object, Unit> saturationSetter = MethodHandleHelper.wrapperForSetter(FoodStats.class, (String[])new String[]{"field_75125_b", "foodSaturationLevel"});
    @Nullable
    public final Double x;
    @Nullable
    public final Double y;
    @Nullable
    public final Double z;
    @Nullable
    public final Float yaw;
    @Nullable
    public final Float pitch;
    @Nullable
    public final Float health;
    @Nullable
    public final Integer food;
    @Nullable
    public final Float saturation;
    @Nullable
    public final Float exhaustion;

    public EntityMoment(@Nullable Double x, @Nullable Double y, @Nullable Double z, @Nullable Float yaw, @Nullable Float pitch, @Nullable Float health, @Nullable Integer food, @Nullable Float saturation, @Nullable Float exhaustion) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
        this.health = health;
        this.food = food;
        this.saturation = saturation;
        this.exhaustion = exhaustion;
    }

    public EntityMoment(Entity entity) {
        this(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, Float.valueOf(entity.field_70177_z), Float.valueOf(entity.field_70125_A), Float.valueOf(entity instanceof EntityLivingBase ? ((EntityLivingBase)entity).func_110143_aJ() : 0.0f), entity instanceof EntityPlayer ? ((EntityPlayer)entity).func_71024_bL().func_75116_a() : 0, Float.valueOf(entity instanceof EntityPlayer ? ((EntityPlayer)entity).func_71024_bL().func_75115_e() : 0.0f), Float.valueOf(entity instanceof EntityPlayer ? ((Float)exhaustionGetter.invoke((Object)((EntityPlayer)entity).func_71024_bL())).floatValue() : 0.0f));
    }

    private EntityMoment() {
        this(null, null, null, null, null, null, null, null, null);
    }

    public static EntityMoment fromNBT(NBTTagCompound nbt) {
        return new EntityMoment(nbt.func_74764_b("x") ? Double.valueOf(nbt.func_74769_h("x")) : null, nbt.func_74764_b("y") ? Double.valueOf(nbt.func_74769_h("y")) : null, nbt.func_74764_b("z") ? Double.valueOf(nbt.func_74769_h("z")) : null, nbt.func_74764_b("yaw") ? Float.valueOf(nbt.func_74760_g("yaw")) : null, nbt.func_74764_b("pitch") ? Float.valueOf(nbt.func_74760_g("pitch")) : null, nbt.func_74764_b("health") ? Float.valueOf(nbt.func_74760_g("health")) : null, nbt.func_74764_b("food") ? Integer.valueOf(nbt.func_74762_e("food")) : null, nbt.func_74764_b("saturation") ? Float.valueOf(nbt.func_74760_g("saturation")) : null, nbt.func_74764_b("exhaustion") ? Float.valueOf(nbt.func_74760_g("exhaustion")) : null);
    }

    public static EntityMoment fromPreviousMoment(Entity entity, EntityMoment previous) {
        Float pitch;
        if (previous == null) {
            return new EntityMoment(entity);
        }
        Float health = null;
        Integer food = null;
        Float saturation = null;
        Float exhaustion = null;
        Double x = previous.x == null || entity.field_70165_t != previous.x ? Double.valueOf(entity.field_70165_t) : null;
        Double y = previous.y == null || entity.field_70163_u != previous.y ? Double.valueOf(entity.field_70163_u) : null;
        Double z = previous.z == null || entity.field_70161_v != previous.z ? Double.valueOf(entity.field_70161_v) : null;
        Float yaw = previous.yaw == null || entity.field_70177_z != previous.yaw.floatValue() ? Float.valueOf(entity.field_70177_z) : null;
        Float f = pitch = previous.pitch == null || entity.field_70125_A != previous.pitch.floatValue() ? Float.valueOf(entity.field_70125_A) : null;
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            Float f2 = health = previous.health == null || living.func_110143_aJ() != previous.health.floatValue() ? Float.valueOf(living.func_110143_aJ()) : null;
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)living;
                food = previous.food == null || player.func_71024_bL().func_75116_a() != previous.food.intValue() ? Integer.valueOf(player.func_71024_bL().func_75116_a()) : null;
                saturation = previous.saturation == null || player.func_71024_bL().func_75115_e() != previous.saturation.floatValue() ? Float.valueOf(player.func_71024_bL().func_75115_e()) : null;
                exhaustion = previous.exhaustion == null || exhaustionGetter.invoke((Object)player.func_71024_bL()) != previous.saturation ? (Float)exhaustionGetter.invoke((Object)player.func_71024_bL()) : null;
            }
        }
        return new EntityMoment(x, y, z, yaw, pitch, health, food, saturation, exhaustion);
    }

    public void apply(Entity entity) {
        entity.func_189654_d(true);
        if (this.x != null) {
            entity.field_70165_t = this.x;
        }
        if (this.y != null) {
            entity.field_70163_u = this.y;
        }
        if (this.z != null) {
            entity.field_70161_v = this.z;
        }
        if (this.yaw != null) {
            entity.field_70177_z = this.yaw.floatValue();
        }
        if (this.pitch != null) {
            entity.field_70125_A = this.pitch.floatValue();
        }
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            if (this.health != null) {
                living.func_70606_j(this.health.floatValue());
            }
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)living;
                if (this.food != null) {
                    player.func_71024_bL().func_75114_a(this.food.intValue());
                }
                if (this.saturation != null) {
                    saturationSetter.invoke((Object)player.func_71024_bL(), (Object)this.saturation);
                }
                if (this.exhaustion != null) {
                    exhaustionSetter.invoke((Object)player.func_71024_bL(), (Object)this.exhaustion);
                }
            }
        }
    }

    public void apply(Entity entity, EntityMoment nextMoment, float partialTicks) {
        if (partialTicks == 0.0f) {
            this.apply(entity);
            return;
        }
        entity.func_189654_d(true);
        if (this.x != null) {
            entity.field_70165_t = this.x + (nextMoment.x != null ? (nextMoment.x - this.x) * (double)partialTicks : 0.0);
        }
        if (this.y != null) {
            entity.field_70163_u = this.y + (nextMoment.y != null ? (nextMoment.y - this.y) * (double)partialTicks : 0.0);
        }
        if (this.z != null) {
            entity.field_70161_v = this.z + (nextMoment.z != null ? (nextMoment.z - this.z) * (double)partialTicks : 0.0);
        }
        if (this.yaw != null) {
            entity.field_70177_z = this.yaw.floatValue() + (nextMoment.yaw != null ? (((nextMoment.yaw.floatValue() - this.yaw.floatValue()) % 360.0f + 540.0f) % 360.0f - 180.0f) * partialTicks : 0.0f);
        }
        if (this.pitch != null) {
            entity.field_70125_A = this.pitch.floatValue() + (nextMoment.pitch != null ? (nextMoment.pitch.floatValue() - this.pitch.floatValue()) * partialTicks : 0.0f);
        }
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            if (this.health != null) {
                living.func_70606_j(this.health.floatValue() + (nextMoment.health != null ? (nextMoment.health.floatValue() - this.health.floatValue()) * partialTicks : 0.0f));
            }
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)living;
                if (this.food != null) {
                    player.func_71024_bL().func_75114_a(this.food + (int)(nextMoment.food != null ? (float)(nextMoment.food - this.food) * partialTicks : 0.0f));
                }
                if (this.saturation != null) {
                    saturationSetter.invoke((Object)player.func_71024_bL(), (Object)Float.valueOf(this.saturation.floatValue() + (nextMoment.saturation != null ? (nextMoment.saturation.floatValue() - this.saturation.floatValue()) * partialTicks : 0.0f)));
                }
                if (this.exhaustion != null) {
                    exhaustionSetter.invoke((Object)player.func_71024_bL(), (Object)Float.valueOf(this.exhaustion.floatValue() + (nextMoment.exhaustion != null ? (nextMoment.exhaustion.floatValue() - this.exhaustion.floatValue()) * partialTicks : 0.0f)));
                }
            }
        }
    }

    public EntityMoment withOverride(EntityMoment moment) {
        return new EntityMoment(moment.x != null ? moment.x : this.x, moment.y != null ? moment.y : this.y, moment.z != null ? moment.z : this.z, moment.yaw != null ? moment.yaw : this.yaw, moment.pitch != null ? moment.pitch : this.pitch, moment.health != null ? moment.health : this.health, moment.food != null ? moment.food : this.food, moment.saturation != null ? moment.saturation : this.saturation, moment.exhaustion != null ? moment.exhaustion : this.exhaustion);
    }

    public boolean matches(Entity entity) {
        if (this.x != null && entity.field_70165_t != this.x) {
            return false;
        }
        if (this.y != null && entity.field_70163_u != this.y) {
            return false;
        }
        if (this.z != null && entity.field_70161_v != this.z) {
            return false;
        }
        if (this.yaw != null && entity.field_70177_z != this.yaw.floatValue()) {
            return false;
        }
        if (this.pitch != null && entity.field_70125_A != this.pitch.floatValue()) {
            return false;
        }
        if (entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            if (this.health != null && living.func_110143_aJ() != this.health.floatValue()) {
                return false;
            }
            if (entity instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)living;
                if (this.food != null && player.func_71024_bL().func_75116_a() != this.food.intValue()) {
                    return false;
                }
                return this.saturation == null || player.func_71024_bL().func_75115_e() == this.saturation.floatValue();
            }
        }
        return true;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        if (this.x != null) {
            compound.func_74780_a("x", this.x.doubleValue());
        }
        if (this.y != null) {
            compound.func_74780_a("y", this.y.doubleValue());
        }
        if (this.z != null) {
            compound.func_74780_a("z", this.z.doubleValue());
        }
        if (this.yaw != null) {
            compound.func_74776_a("yaw", this.yaw.floatValue());
        }
        if (this.pitch != null) {
            compound.func_74776_a("pitch", this.pitch.floatValue());
        }
        if (this.health != null) {
            compound.func_74776_a("health", this.health.floatValue());
        }
        if (this.food != null) {
            compound.func_74774_a("food", this.food.byteValue());
        }
        if (this.saturation != null) {
            compound.func_74776_a("saturation", this.saturation.floatValue());
        }
        if (this.exhaustion != null) {
            compound.func_74776_a("exhaustion", this.exhaustion.floatValue());
        }
        return compound;
    }
}

