/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.client.gui.book;

import com.google.gson.JsonObject;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponent;
import com.teamwizardry.librarianlib.features.gui.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.gui.provided.book.context.Bookmark;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.entry.Entry;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.page.Page;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import com.teamwizardry.wizardry.client.gui.book.BookmarkWizardryStructure;
import com.teamwizardry.wizardry.client.gui.book.ComponentWizardryStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.functions.Function0;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageWizardryStructure
implements Page {
    private Entry entry;
    private String structureName;
    private ResourceLocation structure;

    public PageWizardryStructure(Entry entry, JsonObject element) {
        this.entry = entry;
        if (element != null && element.has("name")) {
            this.structureName = element.getAsJsonPrimitive("name").getAsString();
        }
        if (this.structureName != null) {
            this.structure = new ResourceLocation(this.structureName);
        }
    }

    @NotNull
    public Entry getEntry() {
        return this.entry;
    }

    @NotNull
    public List<Bookmark> getExtraBookmarks() {
        ArrayList<Bookmark> list = new ArrayList<Bookmark>();
        list.add(new BookmarkWizardryStructure(this.structure));
        return list;
    }

    @Nullable
    public Collection<String> getSearchableKeys() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.structureName);
        return list;
    }

    @Nullable
    public Collection<String> getSearchableStrings() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public List<Function0<GuiComponent>> createBookComponents(@NotNull IBookGui book, @NotNull Vec2d size) {
        ArrayList<Function0<GuiComponent>> list = new ArrayList<Function0<GuiComponent>>();
        list.add(() -> new ComponentWizardryStructure(book, 16, 16, size.getXi(), size.getYi(), this.structure));
        return list;
    }
}

