/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;

public class TreeNode<T>
implements Iterable<T> {
    private T data;
    private TreeNode<T> parent;
    private List<TreeNode<T>> children;

    public TreeNode(T data) {
        this.data = data;
        this.parent = null;
        this.children = new ArrayList<TreeNode<T>>();
    }

    public TreeNode<T> setData(T data) {
        this.data = data;
        return this;
    }

    public TreeNode<T> setParent(TreeNode<T> parent) {
        this.parent = parent;
        return this;
    }

    public TreeNode<T> addChild(TreeNode<T> child) {
        this.children.add(child.setParent(this));
        return child;
    }

    public T getData() {
        return this.data;
    }

    public TreeNode<T> getParent() {
        return this.parent;
    }

    public List<TreeNode<T>> getChildren() {
        return this.children;
    }

    @Override
    public Iterator<T> iterator() {
        return new TreeIterator(this);
    }

    public Iterator<TreeNode<T>> nodeIterator() {
        return new TreeNodeIterator(this);
    }

    private class TreeNodeIterator<U extends TreeNode<T>>
    implements Iterator<TreeNode<T>> {
        public Queue<TreeNode<T>> queue = new LinkedList();

        public TreeNodeIterator(TreeNode<T> root) {
            this.queue.add(root);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public TreeNode<T> next() {
            if (this.hasNext()) {
                TreeNode node = this.queue.remove();
                this.queue.addAll(node.children);
                return node;
            }
            throw new NoSuchElementException();
        }
    }

    private class TreeIterator<U>
    implements Iterator<U> {
        public Queue<TreeNode<U>> queue = new LinkedList<TreeNode<U>>();

        public TreeIterator(TreeNode<U> root) {
            this.queue.add(root);
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        @Override
        public U next() {
            if (this.hasNext()) {
                TreeNode<U> node = this.queue.remove();
                this.queue.addAll(((TreeNode)node).children);
                return (U)((TreeNode)node).data;
            }
            throw new NoSuchElementException();
        }
    }
}

