/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.util;

import com.google.common.base.Predicate;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class RayTrace {
    private final World world;
    private final Vec3d slope;
    private final Vec3d origin;
    private final double range;
    private boolean skipBlocks = false;
    private boolean skipEntities = false;
    private boolean returnLastUncollidableBlock = true;
    private boolean ignoreBlocksWithoutBoundingBoxes = false;
    private Predicate<Entity> predicateEntity;
    private Predicate<Block> predicateBlock;
    private HashSet<BlockPos> skipBlockList = new HashSet();

    public RayTrace(@Nonnull World world, @Nonnull Vec3d slope, @Nonnull Vec3d origin, double range) {
        this.world = world;
        this.slope = slope;
        this.origin = origin;
        this.range = range;
    }

    public RayTrace addBlockToSkip(@Nonnull BlockPos pos) {
        this.skipBlockList.add(pos);
        return this;
    }

    public RayTrace setEntityFilter(Predicate<Entity> predicate) {
        this.predicateEntity = predicate;
        return this;
    }

    public RayTrace setBlockFilter(Predicate<Block> predicate) {
        this.predicateBlock = predicate;
        return this;
    }

    public RayTrace setReturnLastUncollidableBlock(boolean returnLastUncollidableBlock) {
        this.returnLastUncollidableBlock = returnLastUncollidableBlock;
        return this;
    }

    public RayTrace setIgnoreBlocksWithoutBoundingBoxes(boolean ignoreBlocksWithoutBoundingBoxes) {
        this.ignoreBlocksWithoutBoundingBoxes = ignoreBlocksWithoutBoundingBoxes;
        return this;
    }

    public RayTrace setSkipEntities(boolean skipEntities) {
        this.skipEntities = skipEntities;
        return this;
    }

    private boolean isOrigin(BlockPos pos) {
        return new BlockPos(this.origin) == pos;
    }

    @Nonnull
    public RayTraceResult trace() {
        Vec3d lookVec = this.origin.func_178787_e(this.slope.func_186678_a(this.range));
        RayTraceResult entityResult = null;
        RayTraceResult blockResult = null;
        if (!this.skipEntities) {
            Entity targetEntity = null;
            RayTraceResult entityTrace = null;
            AxisAlignedBB bb = new AxisAlignedBB(this.origin.field_72450_a, this.origin.field_72448_b, this.origin.field_72449_c, lookVec.field_72450_a, lookVec.field_72448_b, lookVec.field_72449_c);
            List list = this.world.func_175647_a(Entity.class, bb.func_72314_b(this.range, this.range, this.range), input -> {
                if (this.predicateEntity == null) {
                    return true;
                }
                return this.predicateEntity.test(input);
            });
            double closest = 0.0;
            for (Entity entity : list) {
                double tmp;
                RayTraceResult traceTmp;
                if (entity == null || (traceTmp = (bb = entity.func_174813_aQ()).func_72327_a(lookVec, this.origin)) == null || !((tmp = this.origin.func_72438_d(traceTmp.field_72307_f)) < closest) && closest != 0.0) continue;
                targetEntity = entity;
                entityTrace = traceTmp;
                closest = tmp;
            }
            if (targetEntity != null) {
                entityResult = new RayTraceResult(targetEntity, entityTrace.field_72307_f);
            }
        }
        if (!this.skipBlocks) {
            blockResult = this.traceBlock(this.origin, lookVec);
        }
        if (blockResult == null) {
            blockResult = new RayTraceResult(RayTraceResult.Type.BLOCK, lookVec, EnumFacing.func_176737_a((float)((float)lookVec.field_72450_a), (float)((float)lookVec.field_72448_b), (float)((float)lookVec.field_72449_c)), new BlockPos(lookVec));
        }
        return entityResult != null && this.origin.func_72438_d(entityResult.field_72307_f) < this.origin.func_72438_d(blockResult.field_72307_f) ? entityResult : blockResult;
    }

    private RayTraceResult traceBlock(@Nonnull Vec3d start, @Nonnull Vec3d end) {
        RayTraceResult raytraceresult2 = null;
        int i = MathHelper.func_76128_c((double)end.field_72450_a);
        int j = MathHelper.func_76128_c((double)end.field_72448_b);
        int k = MathHelper.func_76128_c((double)end.field_72449_c);
        int l = MathHelper.func_76128_c((double)start.field_72450_a);
        int i1 = MathHelper.func_76128_c((double)start.field_72448_b);
        int j1 = MathHelper.func_76128_c((double)start.field_72449_c);
        int k1 = 200;
        while (k1-- >= 0) {
            EnumFacing enumfacing;
            if (l == i && i1 == j && j1 == k) {
                return this.returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            boolean flag2 = true;
            boolean flag = true;
            boolean flag1 = true;
            double d0 = 999.0;
            double d1 = 999.0;
            double d2 = 999.0;
            if (i > l) {
                d0 = (double)l + 1.0;
            } else if (i < l) {
                d0 = (double)l + 0.0;
            } else {
                flag2 = false;
            }
            if (j > i1) {
                d1 = (double)i1 + 1.0;
            } else if (j < i1) {
                d1 = (double)i1 + 0.0;
            } else {
                flag = false;
            }
            if (k > j1) {
                d2 = (double)j1 + 1.0;
            } else if (k < j1) {
                d2 = (double)j1 + 0.0;
            } else {
                flag1 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = end.field_72450_a - start.field_72450_a;
            double d7 = end.field_72448_b - start.field_72448_b;
            double d8 = end.field_72449_c - start.field_72449_c;
            if (flag2) {
                d3 = (d0 - start.field_72450_a) / d6;
            }
            if (flag) {
                d4 = (d1 - start.field_72448_b) / d7;
            }
            if (flag1) {
                d5 = (d2 - start.field_72449_c) / d8;
            }
            if (d3 == -0.0) {
                d3 = -1.0E-4;
            }
            if (d4 == -0.0) {
                d4 = -1.0E-4;
            }
            if (d5 == -0.0) {
                d5 = -1.0E-4;
            }
            if (d3 < d4 && d3 < d5) {
                enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                start = new Vec3d(d0, start.field_72448_b + d7 * d3, start.field_72449_c + d8 * d3);
            } else if (d4 < d5) {
                enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                start = new Vec3d(start.field_72450_a + d6 * d4, d1, start.field_72449_c + d8 * d4);
            } else {
                enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                start = new Vec3d(start.field_72450_a + d6 * d5, start.field_72448_b + d7 * d5, d2);
            }
            l = MathHelper.func_76128_c((double)start.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
            i1 = MathHelper.func_76128_c((double)start.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
            j1 = MathHelper.func_76128_c((double)start.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
            BlockPos targetPos = new BlockPos(l, i1, j1);
            IBlockState targetState = this.world.func_180495_p(targetPos);
            Block targetBlock = targetState.func_177230_c();
            if (this.isOrigin(targetPos) || this.ignoreBlocksWithoutBoundingBoxes && targetState.func_185904_a() != Material.field_151567_E && targetState.func_185890_d((IBlockAccess)this.world, targetPos) == Block.field_185506_k) continue;
            if (targetBlock.func_176209_a(targetState, false) && (this.predicateBlock == null || this.predicateBlock.test((Object)targetBlock))) {
                RayTraceResult raytraceresult1 = targetState.func_185910_a(this.world, targetPos, start, end);
                if (raytraceresult1 == null) continue;
                return raytraceresult1;
            }
            raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, start, enumfacing, targetPos);
        }
        return this.returnLastUncollidableBlock ? raytraceresult2 : null;
    }

    public RayTrace setSkipBlocks(boolean skipBlocks) {
        this.skipBlocks = skipBlocks;
        return this;
    }
}

