/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.spell;

import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.wizardry.api.item.BaublesSupport;
import com.teamwizardry.wizardry.api.item.INacreProduct;
import com.teamwizardry.wizardry.api.spell.SpellData;
import com.teamwizardry.wizardry.api.spell.SpellRing;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstance;
import com.teamwizardry.wizardry.api.spell.module.ModuleInstanceModifier;
import com.teamwizardry.wizardry.api.util.ColorUtils;
import com.teamwizardry.wizardry.init.ModItems;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;

public class SpellUtils {
    public static final Item CODE_LINE_BREAK = ModItems.DEVIL_DUST;

    public static void copySpell(ItemStack from, ItemStack to) {
        NBTTagList spell = SpellUtils.getSpell(from);
        if (spell == null) {
            return;
        }
        if (to.func_77973_b() instanceof INacreProduct && from.func_77973_b() instanceof INacreProduct) {
            NBTHelper.setFloat((ItemStack)to, (String)"rand", (float)NBTHelper.getFloat((ItemStack)from, (String)"rand", (float)-1.0f));
        }
        SpellUtils.infuseSpell(to, spell);
    }

    public static void transferSpell(ItemStack from, ItemStack to) {
        NBTTagList spell = SpellUtils.uninfuseSpell(from);
        if (spell == null) {
            return;
        }
        if (to.func_77973_b() instanceof INacreProduct.INacreDecayProduct && from.func_77973_b() instanceof INacreProduct.INacreDecayProduct) {
            NBTHelper.setFloat((ItemStack)to, (String)"rand", (float)NBTHelper.getFloat((ItemStack)from, (String)"rand", (float)-1.0f));
        }
        SpellUtils.infuseSpell(to, spell);
    }

    @Nullable
    public static NBTTagList getSpell(ItemStack spellHolder) {
        if (NBTHelper.hasNBTEntry((ItemStack)spellHolder, (String)"spellData")) {
            return NBTHelper.getList((ItemStack)spellHolder, (String)"spellData", (int)10);
        }
        return null;
    }

    public static void infuseSpell(ItemStack toInfuse, NBTTagList spell) {
        NBTHelper.setBoolean((ItemStack)toInfuse, (String)"infused", (boolean)true);
        NBTHelper.setList((ItemStack)toInfuse, (String)"spellData", (NBTTagList)spell);
    }

    @Nullable
    public static NBTTagList uninfuseSpell(ItemStack toUninfuse) {
        if (NBTHelper.hasNBTEntry((ItemStack)toUninfuse, (String)"infused")) {
            NBTHelper.removeNBTEntry((ItemStack)toUninfuse, (String)"infused");
        }
        if (NBTHelper.hasNBTEntry((ItemStack)toUninfuse, (String)"spellData")) {
            NBTTagList spell = NBTHelper.getList((ItemStack)toUninfuse, (String)"spellData", (int)10);
            NBTHelper.removeNBTEntry((ItemStack)toUninfuse, (String)"spellData");
            return spell;
        }
        return null;
    }

    public static Color getAverageSpellColor(List<SpellRing> spellChains) {
        boolean b;
        ArrayList<Color> colorSet = new ArrayList<Color>();
        NBTTagList list = new NBTTagList();
        for (SpellRing spellRing : spellChains) {
            colorSet.add(spellRing.getPrimaryColor());
            list.func_74742_a((NBTBase)spellRing.serializeNBT());
        }
        if (colorSet.size() == 1) {
            return (Color)colorSet.get(0);
        }
        Color lastColor = ColorUtils.mixColors(colorSet);
        boolean r = lastColor.getRed() == 0;
        boolean g = lastColor.getGreen() == 0;
        boolean bl = b = lastColor.getBlue() == 0;
        if (g ? !b || !r : b) {
            return lastColor;
        }
        if ((double)(lastColor.getRed() / lastColor.getBlue()) < 0.8 || (double)(lastColor.getRed() / lastColor.getGreen()) < 0.8) {
            // empty if block
        }
        return lastColor;
    }

    public static void runSpell(@Nonnull World world, @Nonnull ItemStack spellHolder, @Nonnull SpellData data) {
        if (world.field_72995_K) {
            return;
        }
        Entity caster = data.getCaster(world);
        if (caster instanceof EntityLivingBase && BaublesSupport.getItem((EntityLivingBase)caster, ModItems.CREATIVE_HALO, ModItems.FAKE_HALO, ModItems.REAL_HALO).func_190926_b()) {
            return;
        }
        for (SpellRing spellRing : SpellUtils.getSpellChains(spellHolder)) {
            spellRing.runSpellRing(world, data, false);
        }
    }

    public static List<SpellRing> getSpellChains(@Nonnull ItemStack spellHolder) {
        ArrayList<SpellRing> rings = new ArrayList<SpellRing>();
        NBTTagList list = NBTHelper.getList((ItemStack)spellHolder, (String)"spellData", (int)10);
        if (list == null) {
            return rings;
        }
        return SpellUtils.getSpellChains(list);
    }

    public static List<SpellRing> getSpellChains(@Nonnull NBTTagList list) {
        ArrayList<SpellRing> rings = new ArrayList<SpellRing>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound compound = list.func_150305_b(i);
            SpellRing ring = SpellRing.deserializeRing(compound);
            if (ring == null) continue;
            rings.add(ring);
        }
        return rings;
    }

    public static List<List<ModuleInstance>> deserializeModuleList(@Nonnull NBTTagList list) {
        ArrayList<List<ModuleInstance>> modules = new ArrayList<List<ModuleInstance>>();
        ArrayList<ModuleInstance> moduleList = new ArrayList<ModuleInstance>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ModuleInstance module;
            NBTBase base = list.func_179238_g(i);
            if (!(base instanceof NBTTagString)) continue;
            NBTTagString string = (NBTTagString)base;
            if (string.func_82582_d()) {
                if (!moduleList.isEmpty()) {
                    modules.add(moduleList);
                }
                moduleList = new ArrayList();
            }
            if ((module = ModuleInstance.deserialize(string)) == null) continue;
            moduleList.add(module);
        }
        if (!moduleList.isEmpty()) {
            modules.add(moduleList);
        }
        return modules;
    }

    public static List<ItemStack> getSpellItems(List<List<ModuleInstance>> modules) {
        ArrayDeque<ItemStack> items = new ArrayDeque<ItemStack>();
        for (List<ModuleInstance> moduleList : modules) {
            for (ModuleInstance module : moduleList) {
                ItemStack stack = module.getItemStack();
                ItemStack last = (ItemStack)items.peekLast();
                if (last == null) {
                    items.add(stack.func_77946_l());
                    continue;
                }
                if (((ItemStack)items.peekLast()).func_77969_a(stack)) {
                    last.func_190917_f(stack.func_190916_E());
                    continue;
                }
                items.add(stack.func_77946_l());
            }
            items.add(new ItemStack(CODE_LINE_BREAK));
        }
        items.add(new ItemStack((Item)ModItems.PEARL_NACRE));
        return new ArrayList<ItemStack>(items);
    }

    public static List<List<ModuleInstance>> getEssentialModules(List<List<ModuleInstance>> modules) {
        ArrayList<List<ModuleInstance>> essentialModules = new ArrayList<List<ModuleInstance>>();
        modules.forEach(moduleList -> {
            ArrayList essentialList = new ArrayList();
            moduleList.forEach(module -> {
                if (!(module instanceof ModuleInstanceModifier)) {
                    essentialList.add(module);
                }
            });
            essentialModules.add(essentialList);
        });
        return essentialModules;
    }

    public static List<SpellRing> getAllSpellRings(@Nonnull SpellRing spellRing) {
        ArrayList<SpellRing> rings = new ArrayList<SpellRing>();
        for (SpellRing tempSpellRing = spellRing; tempSpellRing != null; tempSpellRing = tempSpellRing.getChildRing()) {
            rings.add(tempSpellRing);
        }
        return rings;
    }

    public static List<SpellRing> getAllSpellRings(@Nonnull ItemStack spellHolder) {
        ArrayList<SpellRing> rings = new ArrayList<SpellRing>();
        List<SpellRing> heads = SpellUtils.getSpellChains(spellHolder);
        Iterator<SpellRing> iterator = heads.iterator();
        while (iterator.hasNext()) {
            SpellRing spellRing;
            for (SpellRing tempSpellRing = spellRing = iterator.next(); tempSpellRing != null; tempSpellRing = tempSpellRing.getChildRing()) {
                rings.add(tempSpellRing);
            }
        }
        return rings;
    }
}

