/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.wizardry.api.capability.player.mana;

import com.teamwizardry.wizardry.api.capability.player.mana.BaubleManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.DefaultManaCapability;
import com.teamwizardry.wizardry.api.capability.player.mana.IManaCapability;
import com.teamwizardry.wizardry.api.item.BaublesSupport;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class ManaCapabilityProvider
implements ICapabilitySerializable<NBTTagCompound> {
    @CapabilityInject(value=IManaCapability.class)
    public static final Capability<IManaCapability> manaCapability = null;
    private final IManaCapability capability;

    public ManaCapabilityProvider() {
        this.capability = new DefaultManaCapability();
    }

    public ManaCapabilityProvider(IManaCapability capability) {
        this.capability = capability;
    }

    @Nullable
    public static IManaCapability getCap(Entity entity) {
        return (IManaCapability)entity.getCapability(manaCapability, null);
    }

    @Nullable
    public static IManaCapability getCap(World world, BlockPos pos, EnumFacing facing) {
        if (!world.func_175667_e(pos)) {
            return null;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile == null) {
            return null;
        }
        return (IManaCapability)tile.getCapability(manaCapability, facing);
    }

    @Nullable
    public static IManaCapability getCap(ItemStack stack) {
        if (BaublesSupport.isBauble(stack)) {
            return new BaubleManaCapability(stack);
        }
        return (IManaCapability)stack.getCapability(manaCapability, null);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == manaCapability;
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, EnumFacing facing) {
        if (manaCapability != null && capability == manaCapability) {
            return (T)this.capability;
        }
        return null;
    }

    public NBTTagCompound serializeNBT() {
        return (NBTTagCompound)this.capability.serializeNBT();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.capability.deserializeNBT((NBTBase)nbt);
    }
}

