/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.starlight.network.handlers;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.common.base.LightOreTransmutations;
import hellfirepvp.astralsorcery.common.constellation.IWeakConstellation;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.starlight.network.StarlightNetworkRegistry;
import hellfirepvp.astralsorcery.common.util.ParticleEffectWatcher;
import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTransmutationHandler
implements StarlightNetworkRegistry.IStarlightBlockHandler {
    private static Map<BlockPos, ActiveTransmutation> runningTransmutations = new HashMap<BlockPos, ActiveTransmutation>();

    @Override
    @Deprecated
    public boolean isApplicable(World world, BlockPos pos, IBlockState state) {
        return false;
    }

    @Override
    public boolean isApplicable(World world, BlockPos pos, IBlockState state, @Nullable IWeakConstellation starlightType) {
        return LightOreTransmutations.searchForTransmutation(state) != null;
    }

    @Override
    public void receiveStarlight(World world, Random rand, BlockPos pos, @Nullable IWeakConstellation starlightType, double amount) {
        long ms = System.currentTimeMillis();
        if (!runningTransmutations.containsKey(pos)) {
            IBlockState tryStateIn = world.func_180495_p(pos);
            LightOreTransmutations.Transmutation tr = LightOreTransmutations.searchForTransmutation(tryStateIn);
            if (tr != null && (tr.getRequiredType() == null || tr.getRequiredType().equals(starlightType))) {
                ActiveTransmutation atr = new ActiveTransmutation();
                runningTransmutations.put(pos, atr);
                atr.accCharge = 0.0;
                atr.lastMSrec = ms;
                atr.runningTransmutation = tr;
            } else {
                return;
            }
        }
        ActiveTransmutation node = runningTransmutations.get(pos);
        if (LightOreTransmutations.searchForTransmutation(world.func_180495_p(pos)) != node.runningTransmutation) {
            runningTransmutations.remove(pos);
            return;
        }
        if (node.runningTransmutation.getRequiredType() != null && !node.runningTransmutation.getRequiredType().equals(starlightType)) {
            return;
        }
        long diff = ms - node.lastMSrec;
        if (diff >= 15000L) {
            node.accCharge = 0.0;
        }
        ActiveTransmutation activeTransmutation = node;
        activeTransmutation.accCharge = activeTransmutation.accCharge + amount;
        node.lastMSrec = ms;
        if (ParticleEffectWatcher.INSTANCE.mayFire(world, pos)) {
            PktParticleEvent pkt = new PktParticleEvent(PktParticleEvent.ParticleEventType.TRANSMUTATION_CHARGE, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            PacketChannel.CHANNEL.sendToAllAround((IMessage)pkt, PacketChannel.pointFromPos(world, (Vec3i)pos, 16.0));
        }
        if (node.accCharge >= node.runningTransmutation.getCost()) {
            if (!world.func_175656_a(pos, node.runningTransmutation.getOutput())) {
                activeTransmutation = node;
                activeTransmutation.accCharge = activeTransmutation.accCharge - 1000.0;
            } else {
                runningTransmutations.remove(pos);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void playTransmutationEffects(PktParticleEvent event) {
        Random rand = EffectHandler.STATIC_EFFECT_RAND;
        EntityFXFacingParticle p = EffectHelper.genericFlareParticle(event.getVec().getX() + (double)rand.nextFloat(), event.getVec().getY() + (double)rand.nextFloat(), event.getVec().getZ() + (double)rand.nextFloat());
        p.motion(0.0, (double)rand.nextFloat() * 0.05, 0.0);
        p.scale(0.2f).setColor(Color.WHITE);
    }

    public static class ActiveTransmutation {
        private LightOreTransmutations.Transmutation runningTransmutation;
        private long lastMSrec;
        private double accCharge;
    }
}

