/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.item.wand;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.effect.EffectHelper;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.event.ClientRenderEventHandler;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.common.base.Mods;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.integrations.ModIntegrationBotania;
import hellfirepvp.astralsorcery.common.item.ItemBlockStorage;
import hellfirepvp.astralsorcery.common.item.base.render.ItemAlignmentChargeConsumer;
import hellfirepvp.astralsorcery.common.item.base.render.ItemAlignmentChargeRevealer;
import hellfirepvp.astralsorcery.common.item.base.render.ItemHandRender;
import hellfirepvp.astralsorcery.common.item.base.render.ItemHudRender;
import hellfirepvp.astralsorcery.common.network.PacketChannel;
import hellfirepvp.astralsorcery.common.network.packet.server.PktParticleEvent;
import hellfirepvp.astralsorcery.common.registry.RegistryItems;
import hellfirepvp.astralsorcery.common.util.ItemUtils;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.lwjgl.opengl.GL11;

public class ItemArchitectWand
extends ItemBlockStorage
implements ItemHandRender,
ItemHudRender,
ItemAlignmentChargeConsumer {
    private static final double architectRange = 60.0;

    public ItemArchitectWand() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(RegistryItems.creativeTabAstralSorcery);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldReveal(ItemAlignmentChargeRevealer.ChargeType ct, ItemStack stack) {
        return ct == ItemAlignmentChargeRevealer.ChargeType.TEMP;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderInHandHUD(ItemStack lastCacheInstance, float fadeAlpha, float pTicks) {
        Collection<ItemStack> stored = ItemArchitectWand.getMappedStoredStates(lastCacheInstance).values();
        if (stored.isEmpty()) {
            return;
        }
        LinkedHashMap<ItemStack, Integer> amountMap = new LinkedHashMap<ItemStack, Integer>();
        for (ItemStack stack : stored) {
            int found = 0;
            if (Mods.BOTANIA.isPresent()) {
                found = ModIntegrationBotania.getItemCount((EntityPlayer)Minecraft.func_71410_x().field_71439_g, lastCacheInstance, ItemUtils.createBlockState(stack));
            } else {
                Collection<ItemStack> stacks = ItemUtils.scanInventoryForMatching((IItemHandler)new InvWrapper((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by), stack, false);
                for (ItemStack foundStack : stacks) {
                    found += foundStack.func_190916_E();
                }
            }
            amountMap.put(stack, found);
        }
        int heightNormal = 26;
        int heightSplit = 13;
        int width = 26;
        int offsetX = 30;
        int offsetY = 15;
        GlStateManager.func_179094_E();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        Blending.DEFAULT.applyStateManager();
        Blending.DEFAULT.apply();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(fadeAlpha * 0.9f));
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(fadeAlpha * 0.9f));
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        int tempOffsetY = offsetY;
        for (int i = 0; i < amountMap.size(); ++i) {
            boolean last;
            boolean first = i == 0;
            boolean bl = last = i + 1 == amountMap.size();
            if (first) {
                vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                ClientRenderEventHandler.texHUDItemFrame.bind();
                vb.func_181662_b((double)offsetX, (double)(tempOffsetY + heightSplit), 10.0).func_187315_a(0.0, 0.5).func_181675_d();
                vb.func_181662_b((double)(offsetX + width), (double)(tempOffsetY + heightSplit), 10.0).func_187315_a(1.0, 0.5).func_181675_d();
                vb.func_181662_b((double)(offsetX + width), (double)tempOffsetY, 10.0).func_187315_a(1.0, 0.0).func_181675_d();
                vb.func_181662_b((double)offsetX, (double)tempOffsetY, 10.0).func_187315_a(0.0, 0.0).func_181675_d();
                tempOffsetY += heightSplit;
                tes.func_78381_a();
            } else {
                vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                ClientRenderEventHandler.texHUDItemFrameEx.bind();
                vb.func_181662_b((double)offsetX, (double)(tempOffsetY + heightNormal), 10.0).func_187315_a(0.0, 1.0).func_181675_d();
                vb.func_181662_b((double)(offsetX + width), (double)(tempOffsetY + heightNormal), 10.0).func_187315_a(1.0, 1.0).func_181675_d();
                vb.func_181662_b((double)(offsetX + width), (double)tempOffsetY, 10.0).func_187315_a(1.0, 0.0).func_181675_d();
                vb.func_181662_b((double)offsetX, (double)tempOffsetY, 10.0).func_187315_a(0.0, 0.0).func_181675_d();
                tempOffsetY += heightNormal;
                tes.func_78381_a();
            }
            if (!last) continue;
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            ClientRenderEventHandler.texHUDItemFrame.bind();
            vb.func_181662_b((double)offsetX, (double)(tempOffsetY + heightSplit), 10.0).func_187315_a(0.0, 1.0).func_181675_d();
            vb.func_181662_b((double)(offsetX + width), (double)(tempOffsetY + heightSplit), 10.0).func_187315_a(1.0, 1.0).func_181675_d();
            vb.func_181662_b((double)(offsetX + width), (double)tempOffsetY, 10.0).func_187315_a(1.0, 0.5).func_181675_d();
            vb.func_181662_b((double)offsetX, (double)tempOffsetY, 10.0).func_187315_a(0.0, 0.5).func_181675_d();
            tempOffsetY += heightSplit;
            tes.func_78381_a();
        }
        TextureHelper.refreshTextureBindState();
        TextureHelper.setActiveTextureToAtlasSprite();
        RenderHelper.func_74520_c();
        RenderItem ri = Minecraft.func_71410_x().func_175599_af();
        tempOffsetY = offsetY;
        for (Map.Entry entry : amountMap.entrySet()) {
            ri.func_184391_a((EntityLivingBase)Minecraft.func_71410_x().field_71439_g, (ItemStack)entry.getKey(), offsetX + 5, tempOffsetY + 5);
            tempOffsetY += heightNormal;
            GlStateManager.func_179141_d();
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179097_i();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(offsetX + 14), (float)(offsetY + 16), (float)0.0f);
        int c = 0xDDDDDD;
        for (Map.Entry entry : amountMap.entrySet()) {
            String amountStr = String.valueOf(entry.getValue());
            if ((Integer)entry.getValue() == -1) {
                amountStr = "\u221e";
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(-Minecraft.func_71410_x().field_71466_p.func_78256_a(amountStr) / 3), (float)0.0f, (float)0.0f);
            GlStateManager.func_179139_a((double)0.7, (double)0.7, (double)0.7);
            if (amountStr.length() > 3) {
                GlStateManager.func_179139_a((double)0.9, (double)0.9, (double)0.9);
            }
            Minecraft.func_71410_x().field_71466_p.func_175063_a(amountStr, 0.0f, 0.0f, c);
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)heightNormal, (float)0.0f);
        }
        TextureHelper.refreshTextureBindState();
        GlStateManager.func_179121_F();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRenderWhileInHand(ItemStack stack, EnumHand hand, float pTicks) {
        ArrayList storedStates = Lists.newArrayList(ItemArchitectWand.getMappedStoredStates(stack).keySet());
        if (storedStates.isEmpty()) {
            return;
        }
        Random r = ItemArchitectWand.getPreviewRandomFromWorld((World)Minecraft.func_71410_x().field_71441_e);
        Deque<BlockPos> placeable = this.filterBlocksToPlace((Entity)Minecraft.func_71410_x().field_71439_g, (World)Minecraft.func_71410_x().field_71441_e, 60.0);
        if (!placeable.isEmpty()) {
            RayTraceResult rtr = this.getLookBlock((Entity)Minecraft.func_71410_x().field_71439_g, false, true, 60.0);
            if (rtr == null || rtr.field_72313_a != RayTraceResult.Type.BLOCK) {
                return;
            }
            Vec3d hitVec = rtr.field_72307_f;
            EnumFacing sideHit = rtr.field_178784_b;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            Blending.ADDITIVEDARK.applyStateManager();
            GlStateManager.func_179118_c();
            RenderingUtils.removeStandartTranslationFromTESRMatrix(pTicks);
            WorldClient w = Minecraft.func_71410_x().field_71441_e;
            TextureHelper.setActiveTextureToAtlasSprite();
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder vb = tes.func_178180_c();
            vb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            for (BlockPos pos : placeable) {
                Collections.shuffle(storedStates, r);
                IBlockState potentialState = (IBlockState)Iterables.getFirst((Iterable)storedStates, (Object)Blocks.field_150350_a.func_176223_P());
                try {
                    potentialState = potentialState.func_177230_c().getStateForPlacement((World)Minecraft.func_71410_x().field_71441_e, pos, sideHit, (float)hitVec.field_72450_a, (float)hitVec.field_72448_b, (float)hitVec.field_72449_c, potentialState.func_177230_c().func_176201_c(potentialState), (EntityLivingBase)Minecraft.func_71410_x().field_71439_g, hand);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RenderingUtils.renderBlockSafely((IBlockAccess)w, pos, potentialState, vb);
            }
            vb.func_181674_a((float)TileEntityRendererDispatcher.field_147554_b, (float)TileEntityRendererDispatcher.field_147555_c, (float)TileEntityRendererDispatcher.field_147552_d);
            tes.func_78381_a();
            Blending.DEFAULT.applyStateManager();
            Blending.DEFAULT.apply();
            GlStateManager.func_179141_d();
            GlStateManager.func_179121_F();
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer playerIn, EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)playerIn.func_184586_b(hand));
        }
        if (world.field_72995_K) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        Map<IBlockState, ItemStack> storedStates = ItemArchitectWand.getMappedStoredStates(stack);
        if (storedStates.isEmpty()) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        RayTraceResult rtr = this.getLookBlock((Entity)playerIn, false, true, 60.0);
        if (rtr == null || rtr.field_178784_b == null || rtr.field_72307_f == null) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        EnumFacing sideHit = rtr.field_178784_b;
        List<Tuple> shuffleable = MiscUtils.flatten(storedStates, Tuple::new);
        Random r = ItemArchitectWand.getPreviewRandomFromWorld(world);
        Deque<BlockPos> placeable = this.filterBlocksToPlace((Entity)playerIn, world, 60.0);
        if (!placeable.isEmpty()) {
            for (BlockPos placePos : placeable) {
                Tuple applicable;
                Collections.shuffle(shuffleable, r);
                Tuple tuple = applicable = playerIn.func_184812_l_() ? (Tuple)Iterables.getFirst(shuffleable, null) : null;
                if (!playerIn.func_184812_l_()) {
                    for (Tuple it : shuffleable) {
                        ItemStack test = ItemUtils.copyStackWithSize((ItemStack)it.value, 1);
                        if (!ItemUtils.consumeFromPlayerInventory(playerIn, stack, test, true)) continue;
                        applicable = it;
                        break;
                    }
                }
                if (applicable == null) break;
                if (!this.drainTempCharge(playerIn, Config.architectWandUseCost, true)) continue;
                IBlockState place = (IBlockState)applicable.key;
                try {
                    place = ((IBlockState)applicable.key).func_177230_c().getStateForPlacement(world, placePos, sideHit, (float)rtr.field_72307_f.field_72450_a, (float)rtr.field_72307_f.field_72448_b, (float)rtr.field_72307_f.field_72449_c, ((ItemStack)applicable.value).func_77960_j(), (EntityLivingBase)playerIn, hand);
                }
                catch (Exception it) {
                    // empty catch block
                }
                if (!MiscUtils.canPlayerPlaceBlockPos(playerIn, hand, place, placePos, sideHit) || !world.func_175656_a(placePos, place)) continue;
                this.drainTempCharge(playerIn, Config.architectWandUseCost, false);
                if (!playerIn.func_184812_l_()) {
                    ItemUtils.consumeFromPlayerInventory(playerIn, stack, ItemUtils.copyStackWithSize((ItemStack)applicable.value, 1), false);
                }
                PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.ARCHITECT_PLACE, (Vec3i)placePos);
                ev.setAdditionalDataLong(Block.func_176210_f((IBlockState)((IBlockState)applicable.key)));
                PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, (Vec3i)placePos, 40.0));
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (stack.func_190926_b()) {
            return EnumActionResult.SUCCESS;
        }
        if (playerIn.func_70093_af()) {
            ItemArchitectWand.tryStoreBlock(stack, world, pos);
            return EnumActionResult.SUCCESS;
        }
        if (!world.field_72995_K) {
            Map<IBlockState, ItemStack> storedStates = ItemArchitectWand.getMappedStoredStates(stack);
            if (storedStates.isEmpty()) {
                return EnumActionResult.SUCCESS;
            }
            List<Tuple> shuffleable = MiscUtils.flatten(storedStates, Tuple::new);
            Random r = ItemArchitectWand.getPreviewRandomFromWorld(world);
            Deque<BlockPos> placeable = this.filterBlocksToPlace((Entity)playerIn, world, 60.0);
            if (!placeable.isEmpty()) {
                for (BlockPos placePos : placeable) {
                    Tuple applicable;
                    Collections.shuffle(shuffleable, r);
                    Tuple tuple = applicable = playerIn.func_184812_l_() ? (Tuple)Iterables.getFirst(shuffleable, null) : null;
                    if (!playerIn.func_184812_l_()) {
                        for (Tuple it : shuffleable) {
                            ItemStack test = ItemUtils.copyStackWithSize((ItemStack)it.value, 1);
                            if (!ItemUtils.consumeFromPlayerInventory(playerIn, stack, test, true)) continue;
                            applicable = it;
                            break;
                        }
                    }
                    if (applicable == null) break;
                    if (!this.drainTempCharge(playerIn, Config.architectWandUseCost, true)) continue;
                    IBlockState place = (IBlockState)applicable.key;
                    try {
                        place = ((IBlockState)applicable.key).func_177230_c().getStateForPlacement(world, placePos, facing, hitX, hitY, hitZ, ((ItemStack)applicable.value).func_77960_j(), (EntityLivingBase)playerIn, hand);
                    }
                    catch (Exception it) {
                        // empty catch block
                    }
                    if (!MiscUtils.canPlayerPlaceBlockPos(playerIn, hand, place, placePos, facing) || !world.func_175656_a(placePos, place)) continue;
                    this.drainTempCharge(playerIn, Config.architectWandUseCost, false);
                    if (!playerIn.func_184812_l_()) {
                        ItemUtils.consumeFromPlayerInventory(playerIn, stack, ItemUtils.copyStackWithSize((ItemStack)applicable.value, 1), false);
                    }
                    PktParticleEvent ev = new PktParticleEvent(PktParticleEvent.ParticleEventType.ARCHITECT_PLACE, (Vec3i)placePos);
                    ev.setAdditionalDataLong(Block.func_176210_f((IBlockState)((IBlockState)applicable.key)));
                    PacketChannel.CHANNEL.sendToAllAround((IMessage)ev, PacketChannel.pointFromPos(world, (Vec3i)placePos, 40.0));
                }
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @SideOnly(value=Side.CLIENT)
    public static void playArchitectPlaceEvent(PktParticleEvent event) {
        AstralSorcery.proxy.scheduleClientside(() -> {
            Vector3 at = event.getVec();
            IBlockState state = Block.func_176220_d((int)((int)event.getAdditionalDataLong()));
            RenderingUtils.playBlockBreakParticles(at.toBlockPos(), state);
            for (int i = 0; i < 9; ++i) {
                EntityFXFacingParticle p = EffectHelper.genericFlareParticle(at.getX() + (field_77697_d.nextBoolean() ? -((double)field_77697_d.nextFloat() * 0.1) : 1.0 + (double)field_77697_d.nextFloat() * 0.1), at.getY() + (field_77697_d.nextBoolean() ? -((double)field_77697_d.nextFloat() * 0.1) : 1.0 + (double)field_77697_d.nextFloat() * 0.1), at.getZ() + (field_77697_d.nextBoolean() ? -((double)field_77697_d.nextFloat() * 0.1) : 1.0 + (double)field_77697_d.nextFloat() * 0.1));
                p.motion(field_77697_d.nextFloat() * 0.03f * (float)(field_77697_d.nextBoolean() ? 1 : -1), field_77697_d.nextFloat() * 0.03f * (float)(field_77697_d.nextBoolean() ? 1 : -1), field_77697_d.nextFloat() * 0.03f * (float)(field_77697_d.nextBoolean() ? 1 : -1));
                p.scale(0.35f).setColor(Color.WHITE.brighter());
            }
        }, 1);
    }

    private Deque<BlockPos> filterBlocksToPlace(Entity entity, World world, double range) {
        Deque<BlockPos> placeable = this.getBlocksToPlaceAt(entity, range);
        boolean discard = false;
        Iterator<BlockPos> iterator = placeable.iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            if (discard) {
                iterator.remove();
                continue;
            }
            if (world.func_175623_d(pos) || world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) continue;
            discard = true;
            iterator.remove();
        }
        return placeable;
    }

    private Deque<BlockPos> getBlocksToPlaceAt(Entity entity, double range) {
        double cmpTo;
        int cmpFrom;
        RayTraceResult rtr = this.getLookBlock(entity, false, true, range);
        if (rtr == null || rtr.field_72313_a != RayTraceResult.Type.BLOCK) {
            return Lists.newLinkedList();
        }
        LinkedList blocks = Lists.newLinkedList();
        EnumFacing sideHit = rtr.field_178784_b;
        BlockPos hitPos = rtr.func_178782_a();
        switch (sideHit.func_176740_k()) {
            case X: {
                cmpFrom = hitPos.func_177958_n();
                cmpTo = entity.field_70165_t;
                break;
            }
            case Y: {
                cmpFrom = hitPos.func_177956_o();
                cmpTo = entity.field_70163_u;
                break;
            }
            case Z: {
                cmpFrom = hitPos.func_177952_p();
                cmpTo = entity.field_70161_v;
                break;
            }
            default: {
                return Lists.newLinkedList();
            }
        }
        int length = (int)Math.min(20.0, Math.abs((double)cmpFrom + 0.5 - cmpTo));
        for (int i = 1; i < length; ++i) {
            blocks.add(hitPos.func_177967_a(sideHit, i));
        }
        return blocks;
    }
}

