/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.integrations.mods.jei.altar;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.util.RenderConstellation;
import hellfirepvp.astralsorcery.common.crafting.ItemHandle;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.AttunementRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.ConstellationRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.AccessibleRecipe;
import hellfirepvp.astralsorcery.common.crafting.helper.ShapedRecipeSlot;
import hellfirepvp.astralsorcery.common.integrations.mods.jei.base.JEIBaseWrapper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class AltarTraitRecipeWrapper
extends JEIBaseWrapper {
    private TraitRecipe recipe;

    public AltarTraitRecipeWrapper(TraitRecipe recipe) {
        this.recipe = recipe;
    }

    public final TraitRecipe getUnderlyingRecipe() {
        return this.recipe;
    }

    public void getIngredients(IIngredients ingredients) {
        AccessibleRecipe underlyingRecipe = this.recipe.getNativeRecipe();
        boolean r = ItemHandle.ignoreGatingRequirement;
        ItemHandle.ignoreGatingRequirement = true;
        ArrayList stackList = Lists.newArrayList();
        for (ShapedRecipeSlot shapedRecipeSlot : ShapedRecipeSlot.values()) {
            NonNullList<ItemStack> stacks = underlyingRecipe.getExpectedStackForRender(shapedRecipeSlot);
            stackList.add(stacks == null ? Lists.newArrayList() : stacks);
        }
        for (Enum enum_ : AttunementRecipe.AttunementAltarSlot.values()) {
            stackList.add(this.recipe.getAttItems((AttunementRecipe.AttunementAltarSlot)enum_));
        }
        for (Enum enum_ : ConstellationRecipe.ConstellationAtlarSlot.values()) {
            stackList.add(this.recipe.getCstItems((ConstellationRecipe.ConstellationAtlarSlot)enum_));
        }
        for (Enum enum_ : TraitRecipe.TraitRecipeSlot.values()) {
            stackList.add(this.recipe.getInnerTraitItems((TraitRecipe.TraitRecipeSlot)enum_));
        }
        for (NonNullList nonNullList : this.recipe.getTraitItems()) {
            stackList.add(nonNullList);
        }
        ItemHandle.ignoreGatingRequirement = r;
        ingredients.setInputLists(ItemStack.class, (List)stackList);
        ingredients.setOutput(ItemStack.class, (Object)this.recipe.getOutputForRender());
    }

    public TraitRecipe getRecipe() {
        return this.recipe;
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.recipe.getRequiredConstellation() != null) {
            GlStateManager.func_179118_c();
            RenderConstellation.renderConstellationIntoGUI(this.recipe.getRequiredConstellation().getConstellationColor(), this.recipe.getRequiredConstellation(), 0, 40, 0.0f, recipeWidth, recipeHeight - 40, 2.0, new RenderConstellation.BrightnessFunction(){

                @Override
                public float getBrightness() {
                    return 0.5f;
                }
            }, true, false);
            GlStateManager.func_179141_d();
        }
    }

    @Nullable
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Lists.newArrayList();
    }

    public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

