/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.crafting.altar;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.common.crafting.ICraftingProgress;
import hellfirepvp.astralsorcery.common.crafting.altar.AbstractAltarRecipe;
import hellfirepvp.astralsorcery.common.crafting.altar.AltarRecipeRegistry;
import hellfirepvp.astralsorcery.common.crafting.altar.recipes.TraitRecipe;
import hellfirepvp.astralsorcery.common.tile.TileAltar;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ActiveCraftingTask {
    private Map<Integer, Object> clientEffectContainer = new HashMap<Integer, Object>();
    private final AbstractAltarRecipe recipeToCraft;
    private final UUID playerCraftingUUID;
    private int ticksCrafting = 0;
    private int totalCraftingTime;
    private CraftingState state;
    private NBTTagCompound craftingData = new NBTTagCompound();

    private ActiveCraftingTask(AbstractAltarRecipe recipeToCraft, UUID playerCraftingUUID) {
        this(recipeToCraft, 1, playerCraftingUUID);
    }

    public ActiveCraftingTask(AbstractAltarRecipe recipeToCraft, int durationDivisor, UUID playerCraftingUUID) {
        Objects.requireNonNull(recipeToCraft);
        this.recipeToCraft = recipeToCraft;
        this.playerCraftingUUID = playerCraftingUUID;
        this.state = CraftingState.ACTIVE;
        this.totalCraftingTime = recipeToCraft.craftingTickTime() / durationDivisor;
    }

    private void attemptRecoverEffects(@Nullable ActiveCraftingTask previous) {
        if (previous != null && previous.recipeToCraft.getUniqueRecipeId() == this.recipeToCraft.getUniqueRecipeId()) {
            this.clientEffectContainer.putAll(previous.clientEffectContainer);
        }
    }

    public CraftingState getState() {
        return this.state;
    }

    public NBTTagCompound getCraftingData() {
        return this.craftingData;
    }

    public void setState(CraftingState state) {
        this.state = state;
    }

    public boolean shouldPersist(TileAltar ta) {
        return this.recipeToCraft instanceof TraitRecipe || ta.getAltarLevel().ordinal() >= TileAltar.AltarLevel.TRAIT_CRAFT.ordinal();
    }

    public UUID getPlayerCraftingUUID() {
        return this.playerCraftingUUID;
    }

    @Nullable
    public EntityPlayer tryGetCraftingPlayerServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(this.playerCraftingUUID);
    }

    @SideOnly(value=Side.CLIENT)
    public <T> T getEffectContained(int index, Function<Integer, T> provider) {
        return (T)this.clientEffectContainer.computeIfAbsent(index, provider);
    }

    public boolean tick(TileAltar altar) {
        if (this.recipeToCraft instanceof ICraftingProgress && !((ICraftingProgress)((Object)this.recipeToCraft)).tryProcess(altar, this, this.craftingData, this.ticksCrafting, this.totalCraftingTime)) {
            return false;
        }
        ++this.ticksCrafting;
        return true;
    }

    public int getTicksCrafting() {
        return this.ticksCrafting;
    }

    public int getTotalCraftingTime() {
        return this.totalCraftingTime;
    }

    public AbstractAltarRecipe getRecipeToCraft() {
        return this.recipeToCraft;
    }

    public boolean isFinished() {
        return this.ticksCrafting >= this.totalCraftingTime;
    }

    @Nullable
    public static ActiveCraftingTask deserialize(NBTTagCompound compound, @Nullable ActiveCraftingTask previous) {
        int recipeId = compound.func_74762_e("recipeId");
        AbstractAltarRecipe recipe = AltarRecipeRegistry.getRecipe(recipeId);
        if (recipe == null) {
            AstralSorcery.log.info("Recipe with unknown/invalid ID found: " + recipeId);
            return null;
        }
        UUID uuidCraft = compound.func_186857_a("crafterUUID");
        int tick = compound.func_74762_e("recipeTick");
        int total = compound.func_74762_e("totalCraftingTime");
        CraftingState state = CraftingState.values()[compound.func_74762_e("craftingState")];
        ActiveCraftingTask task = new ActiveCraftingTask(recipe, uuidCraft);
        task.ticksCrafting = tick;
        task.totalCraftingTime = total;
        task.setState(state);
        task.craftingData = compound.func_74775_l("craftingData");
        task.attemptRecoverEffects(previous);
        return task;
    }

    @Nonnull
    public NBTTagCompound serialize() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("recipeId", this.getRecipeToCraft().getUniqueRecipeId());
        compound.func_74768_a("recipeTick", this.getTicksCrafting());
        compound.func_74768_a("totalCraftingTime", this.getTotalCraftingTime());
        compound.func_186854_a("crafterUUID", this.getPlayerCraftingUUID());
        compound.func_74768_a("craftingState", this.getState().ordinal());
        compound.func_74782_a("craftingData", (NBTBase)this.craftingData);
        return compound;
    }

    public static enum CraftingState {
        ACTIVE,
        WAITING,
        PAUSED;

    }
}

