/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.util;

import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.common.structure.array.BlockArray;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class BlockArrayRenderHelper {
    private BlockArray blocks;
    private WorldBlockArrayRenderAccess renderAccess;
    private double rotX;
    private double rotY;
    private double rotZ;

    public BlockArrayRenderHelper(BlockArray blocks) {
        this.blocks = blocks;
        this.renderAccess = new WorldBlockArrayRenderAccess(blocks);
        this.resetRotation();
    }

    private void resetRotation() {
        this.rotX = -30.0;
        this.rotY = 45.0;
        this.rotZ = 0.0;
    }

    public void rotate(double x, double y, double z) {
        this.rotX += x;
        this.rotY += y;
        this.rotZ += z;
    }

    public int getDefaultSlice() {
        return Collections.min(this.renderAccess.blockRenderData.keySet(), Comparator.comparing(Vec3i::func_177956_o)).func_177956_o();
    }

    public boolean hasSlice(int y) {
        return MiscUtils.contains(this.renderAccess.blockRenderData.keySet(), pos -> pos.func_177956_o() == y);
    }

    public void render3DGUI(double x, double y, float pTicks) {
        this.render3DSliceGUI(x, y, pTicks, Optional.empty());
    }

    public void render3DSliceGUI(double x, double y, float pTicks, Optional<Integer> slice) {
        BakedBlockData renderData;
        BlockPos offset;
        GuiScreen scr = Minecraft.func_71410_x().field_71462_r;
        if (scr == null) {
            return;
        }
        GL11.glPushAttrib((int)1048575);
        GlStateManager.func_179094_E();
        Minecraft mc = Minecraft.func_71410_x();
        double sc = new ScaledResolution(mc).func_78325_e();
        GlStateManager.func_179137_b((double)(x + 16.0 / sc), (double)(y + 16.0 / sc), (double)512.0);
        double mul = 10.5;
        double size = 2.0;
        double minSize = 0.5;
        Vec3i max = this.blocks.getMax();
        Vec3i min = this.blocks.getMin();
        double maxLength = 0.0;
        double pointDst = max.func_177958_n() - min.func_177958_n();
        if (pointDst > maxLength) {
            maxLength = pointDst;
        }
        if ((pointDst = (double)(max.func_177956_o() - min.func_177956_o())) > maxLength) {
            maxLength = pointDst;
        }
        if ((pointDst = (double)(max.func_177952_p() - min.func_177952_p())) > maxLength) {
            maxLength = pointDst;
        }
        if ((maxLength -= 5.0) > 0.0) {
            size = (size - minSize) * (1.0 - maxLength / 20.0);
        }
        double dr = -5.75 * size;
        GlStateManager.func_179137_b((double)dr, (double)dr, (double)dr);
        GlStateManager.func_179114_b((float)((float)this.rotX), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)this.rotY), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)this.rotZ), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(-dr), (double)(-dr), (double)(-dr));
        GlStateManager.func_179139_a((double)(-size * mul), (double)(-size * mul), (double)(-size * mul));
        VertexFormat blockFormat = DefaultVertexFormats.field_176600_a;
        TextureHelper.setActiveTextureToAtlasSprite();
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        Set renderArray = this.renderAccess.blockRenderData.entrySet();
        this.renderAccess.slice = slice;
        slice.ifPresent(ySlice -> GlStateManager.func_179109_b((float)0.0f, (float)(-ySlice.intValue()), (float)0.0f));
        vb.func_181668_a(7, blockFormat);
        for (Map.Entry data : renderArray) {
            offset = (BlockPos)data.getKey();
            if (slice.isPresent() && offset.func_177956_o() != slice.get().intValue()) continue;
            renderData = (BakedBlockData)data.getValue();
            if (renderData.tileEntity != null) {
                renderData.tileEntity.func_145834_a((World)Minecraft.func_71410_x().field_71441_e);
                renderData.tileEntity.func_174878_a(offset);
            }
            if (renderData.type == Blocks.field_150350_a) continue;
            RenderingUtils.renderBlockSafely(this.renderAccess, offset, renderData.state, vb);
        }
        tes.func_78381_a();
        for (Map.Entry data : renderArray) {
            offset = (BlockPos)data.getKey();
            if (slice.isPresent() && offset.func_177956_o() != slice.get().intValue() || (renderData = (BakedBlockData)data.getValue()).tileEntity == null || renderData.tesr == null) continue;
            renderData.tileEntity.func_145834_a((World)Minecraft.func_71410_x().field_71441_e);
            renderData.tileEntity.func_174878_a(offset);
            renderData.tesr.func_192841_a(renderData.tileEntity, (double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p(), pTicks, 0, 1.0f);
        }
        this.renderAccess.slice = Optional.empty();
        GlStateManager.func_179121_F();
        GL11.glPopAttrib();
    }

    public static class WorldBlockArrayRenderAccess
    implements IBlockAccess {
        private Map<BlockPos, BakedBlockData> blockRenderData = new HashMap<BlockPos, BakedBlockData>();
        private Optional<Integer> slice = Optional.empty();

        public WorldBlockArrayRenderAccess(BlockArray array) {
            for (Map.Entry<BlockPos, BlockArray.BlockInformation> entry : array.getPattern().entrySet()) {
                BlockPos offset = entry.getKey();
                BlockArray.BlockInformation info = entry.getValue();
                if (info.type.hasTileEntity(info.state)) {
                    TileEntity te = info.type.createTileEntity((World)Minecraft.func_71410_x().field_71441_e, info.state);
                    BlockArray.TileEntityCallback callback = array.getTileCallbacks().get(offset);
                    if (te != null && callback != null && callback.isApplicable(te)) {
                        callback.onPlace(this, offset, te);
                    }
                    this.blockRenderData.put(offset, new BakedBlockData(info.type, info.state, te));
                    continue;
                }
                this.blockRenderData.put(offset, new BakedBlockData(info.type, info.state, null));
            }
        }

        @Nullable
        public TileEntity func_175625_s(BlockPos pos) {
            return this.isInBounds(pos) ? this.blockRenderData.get(pos).tileEntity : null;
        }

        @SideOnly(value=Side.CLIENT)
        public int func_175626_b(BlockPos pos, int lightValue) {
            return 0;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            return this.isInBounds(pos) ? this.blockRenderData.get((Object)pos).state : Blocks.field_150350_a.func_176223_P();
        }

        public boolean func_175623_d(BlockPos pos) {
            return !this.isInBounds(pos) || this.blockRenderData.get((Object)pos).type == Blocks.field_150350_a;
        }

        @SideOnly(value=Side.CLIENT)
        public Biome func_180494_b(BlockPos pos) {
            return Biomes.field_76772_c;
        }

        private boolean isInBounds(BlockPos pos) {
            return this.blockRenderData.containsKey(pos) && (!this.slice.isPresent() || pos.func_177956_o() == this.slice.get().intValue());
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return 0;
        }

        @SideOnly(value=Side.CLIENT)
        public WorldType func_175624_G() {
            return Minecraft.func_71410_x().field_71441_e.func_175624_G();
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return this.isInBounds(pos) ? this.func_180495_p(pos).isSideSolid((IBlockAccess)this, pos, side) : _default;
        }
    }

    public static class BakedBlockData
    extends BlockArray.BlockInformation {
        private TileEntity tileEntity;
        private TileEntitySpecialRenderer tesr;

        protected BakedBlockData(Block type, IBlockState state, TileEntity te) {
            super(type, state);
            this.tileEntity = te;
            if (te != null) {
                this.tesr = TileEntityRendererDispatcher.field_147556_a.func_147547_b(te);
            }
        }
    }
}

