/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.gui.journal;

import com.google.common.collect.Lists;
import hellfirepvp.astralsorcery.client.ClientScheduler;
import hellfirepvp.astralsorcery.client.gui.GuiJournalProgression;
import hellfirepvp.astralsorcery.client.gui.journal.GuiJournalPages;
import hellfirepvp.astralsorcery.client.gui.journal.PartSizeHandler;
import hellfirepvp.astralsorcery.client.gui.journal.ScalingPoint;
import hellfirepvp.astralsorcery.client.util.RenderingUtils;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.resource.AbstractRenderableTexture;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.data.research.ResearchManager;
import hellfirepvp.astralsorcery.common.data.research.ResearchNode;
import hellfirepvp.astralsorcery.common.data.research.ResearchProgression;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import org.lwjgl.opengl.GL11;

public class GuiProgressionClusterRenderer {
    private static final BindableResource frameWooden = AssetLibrary.loadTexture(AssetLoader.TextureLocation.GUI, "framewooden");
    private PartSizeHandler partSizeHandler;
    private ResearchProgression progression;
    private ScalingPoint mousePointScaled;
    private ScalingPoint previousMousePointScaled;
    private int renderOffsetX;
    private int renderOffsetY;
    private int renderGuiHeight;
    private int renderGuiWidth;
    private boolean hasPrevOffset = false;
    private float renderLoopBrFactor = 1.0f;
    private Map<Rectangle, ResearchNode> clickableNodes = new HashMap<Rectangle, ResearchNode>();

    public GuiProgressionClusterRenderer(ResearchProgression progression, int guiHeight, int guiWidth, int guiLeft, int guiTop) {
        this.progression = progression;
        this.partSizeHandler = new PartSizeHandler(progression, guiHeight, guiWidth);
        this.partSizeHandler.setMaxScale(1.2);
        this.partSizeHandler.setMinScale(0.1);
        this.partSizeHandler.setScaleSpeed(0.045);
        this.partSizeHandler.updateSize();
        this.partSizeHandler.forceScaleTo(0.1);
        this.mousePointScaled = ScalingPoint.createPoint(this.partSizeHandler.clampX(this.partSizeHandler.getMidX()), this.partSizeHandler.clampY(this.partSizeHandler.getMidY()), this.partSizeHandler.getScalingFactor(), false);
        this.renderOffsetX = guiLeft;
        this.renderOffsetY = guiTop;
        this.renderGuiHeight = guiHeight;
        this.renderGuiWidth = guiWidth;
    }

    public void propagateClick(GuiJournalProgression parent, Point p) {
        Rectangle frame = new Rectangle(this.renderOffsetX, this.renderOffsetY, this.renderGuiWidth, this.renderGuiHeight);
        if (frame.contains(p)) {
            for (Rectangle r : this.clickableNodes.keySet()) {
                if (!r.contains(p)) continue;
                ResearchNode clicked = this.clickableNodes.get(r);
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJournalPages(parent, clicked));
            }
        }
    }

    public void drawMouseHighlight(float zLevel, Point mousePoint) {
        Rectangle frame = new Rectangle(this.renderOffsetX, this.renderOffsetY, this.renderGuiWidth, this.renderGuiHeight);
        if (frame.contains(mousePoint)) {
            for (Rectangle r : this.clickableNodes.keySet()) {
                if (!r.contains(mousePoint)) continue;
                GL11.glPushMatrix();
                GL11.glTranslated((double)r.getX(), (double)r.getY(), (double)0.0);
                GL11.glScaled((double)this.partSizeHandler.getScalingFactor(), (double)this.partSizeHandler.getScalingFactor(), (double)this.partSizeHandler.getScalingFactor());
                String name = this.clickableNodes.get(r).getUnLocalizedName();
                name = I18n.func_135052_a((String)name, (Object[])new Object[0]);
                RenderingUtils.renderTooltip(0, 0, Lists.newArrayList((Object[])new String[]{name}), new Color(0x100033), new Color(-267386864), Color.WHITE, Minecraft.func_71410_x().field_71466_p);
                GL11.glPopMatrix();
            }
        }
    }

    public void moveMouse(double changedX, double changedY) {
        if (this.hasPrevOffset) {
            this.mousePointScaled.updateScaledPos(this.partSizeHandler.clampX(this.previousMousePointScaled.getScaledPosX() + changedX), this.partSizeHandler.clampY(this.previousMousePointScaled.getScaledPosY() + changedY), this.partSizeHandler.getScalingFactor());
        } else {
            this.mousePointScaled.updateScaledPos(this.partSizeHandler.clampX(changedX), this.partSizeHandler.clampY(changedY), this.partSizeHandler.getScalingFactor());
        }
    }

    public void applyMovedMouseOffset() {
        this.previousMousePointScaled = ScalingPoint.createPoint(this.mousePointScaled.getScaledPosX(), this.mousePointScaled.getScaledPosY(), this.partSizeHandler.getScalingFactor(), true);
        this.hasPrevOffset = true;
    }

    public void handleZoomOut() {
        this.partSizeHandler.handleZoomOut();
        this.rescale(this.partSizeHandler.getScalingFactor());
    }

    public void handleZoomIn() {
        this.partSizeHandler.handleZoomIn();
        this.rescale(this.partSizeHandler.getScalingFactor());
    }

    public double getScaleMouseX() {
        return this.mousePointScaled.getScaledPosX();
    }

    public double getScaleMouseY() {
        return this.mousePointScaled.getScaledPosY();
    }

    private void rescale(double newScale) {
        this.mousePointScaled.rescale(newScale);
        if (this.previousMousePointScaled != null) {
            this.previousMousePointScaled.rescale(newScale);
        }
        this.moveMouse(0.0, 0.0);
    }

    public void drawClusterScreen(float zLevel) {
        this.clickableNodes.clear();
        this.drawNodesAndConnections(zLevel);
    }

    private void drawNodesAndConnections(float zLevel) {
        this.renderLoopBrFactor = (float)Math.sqrt(this.partSizeHandler.getScalingFactor());
        double midX = this.renderGuiWidth / 2;
        double midY = this.renderGuiHeight / 2;
        HashMap<ResearchNode, double[]> displayPositions = new HashMap<ResearchNode, double[]>();
        for (ResearchNode node : this.progression.getResearchNodes()) {
            if (!node.canSee(ResearchManager.clientProgress)) continue;
            int absX = node.renderPosX;
            int absZ = node.renderPosZ;
            double lX = midX + (double)absX * (this.partSizeHandler.getZoomedWHNode() + this.partSizeHandler.getZoomedSpaceBetweenNodes());
            double lZ = midY + (double)absZ * (this.partSizeHandler.getZoomedWHNode() + this.partSizeHandler.getZoomedSpaceBetweenNodes());
            this.renderConnectionLines(node, lX, lZ, midX, midY, zLevel);
            displayPositions.put(node, new double[]{lX, lZ});
        }
        for (ResearchNode node : displayPositions.keySet()) {
            double[] pos = (double[])displayPositions.get(node);
            this.renderNodeToGUI(node, pos[0], pos[1], zLevel);
        }
    }

    private void renderNodeToGUI(ResearchNode node, double lowerPosX, double lowerPosY, float zLevel) {
        double scaledLeft = this.mousePointScaled.getScaledPosX() - this.partSizeHandler.widthToBorder;
        double scaledTop = this.mousePointScaled.getScaledPosY() - this.partSizeHandler.heightToBorder;
        double xAdd = lowerPosX - scaledLeft;
        double yAdd = lowerPosY - scaledTop;
        double offsetX = (double)this.renderOffsetX + xAdd;
        double offsetY = (double)this.renderOffsetY + yAdd;
        GL11.glPushMatrix();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        frameWooden.bind();
        double zoomedWH = this.partSizeHandler.getZoomedWHNode();
        if (this.partSizeHandler.getScalingFactor() >= 0.7) {
            this.clickableNodes.put(new Rectangle(MathHelper.func_76128_c((double)offsetX), MathHelper.func_76128_c((double)offsetY), MathHelper.func_76128_c((double)zoomedWH), MathHelper.func_76128_c((double)zoomedWH)), node);
        }
        this.drawResearchItemBackground(zoomedWH, xAdd, yAdd, zLevel);
        TextureHelper.refreshTextureBindState();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslated((double)offsetX, (double)offsetY, (double)0.0);
        double pxWH = this.partSizeHandler.getZoomedWHNode() / 16.0;
        RenderItem ri = Minecraft.func_71410_x().func_175599_af();
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder vb = t.func_178180_c();
        switch (node.getRenderType()) {
            case ITEMSTACK: {
                GL11.glPushAttrib((int)1048575);
                RenderHelper.func_74520_c();
                GL11.glPushMatrix();
                GL11.glScaled((double)this.partSizeHandler.getScalingFactor(), (double)this.partSizeHandler.getScalingFactor(), (double)this.partSizeHandler.getScalingFactor());
                GL11.glTranslated((double)3.0, (double)3.0, (double)3.0);
                GL11.glScaled((double)0.75, (double)0.75, (double)0.75);
                GL11.glColor4f((float)this.renderLoopBrFactor, (float)this.renderLoopBrFactor, (float)this.renderLoopBrFactor, (float)this.renderLoopBrFactor);
                float oldZ = ri.field_77023_b;
                ri.field_77023_b = zLevel - 5.0f;
                ri.func_175042_a(node.getRenderItemStack(ClientScheduler.getClientTick()), 0, 0);
                ri.field_77023_b = oldZ;
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
                RenderHelper.func_74518_a();
                GL11.glPopAttrib();
                break;
            }
            case TEXTURE: {
                Color c = node.getTextureColorHint();
                GlStateManager.func_179118_c();
                GL11.glDisable((int)3008);
                GlStateManager.func_179131_c((float)(this.renderLoopBrFactor * ((float)c.getRed() / 255.0f)), (float)(this.renderLoopBrFactor * ((float)c.getGreen() / 255.0f)), (float)(this.renderLoopBrFactor * ((float)c.getBlue() / 255.0f)), (float)(this.renderLoopBrFactor * ((float)c.getAlpha() / 255.0f)));
                AbstractRenderableTexture tex = node.getTexture().resolve();
                Point2D.Double of = tex.getUVOffset();
                tex.bindTexture();
                vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                vb.func_181662_b(pxWH, zoomedWH - pxWH, (double)zLevel).func_187315_a(of.x, of.y + tex.getVWidth()).func_181675_d();
                vb.func_181662_b(zoomedWH - pxWH, zoomedWH - pxWH, (double)zLevel).func_187315_a(of.x + tex.getUWidth(), of.y + tex.getVWidth()).func_181675_d();
                vb.func_181662_b(zoomedWH - pxWH, pxWH, (double)zLevel).func_187315_a(of.x + tex.getUWidth(), of.y).func_181675_d();
                vb.func_181662_b(pxWH, pxWH, (double)zLevel).func_187315_a(of.x, of.y).func_181675_d();
                t.func_78381_a();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                TextureHelper.refreshTextureBindState();
                GlStateManager.func_179141_d();
                break;
            }
            case TEXTURE_SPRITE: {
                Color col = node.getTextureColorHint();
                GlStateManager.func_179118_c();
                GL11.glDisable((int)3008);
                GlStateManager.func_179131_c((float)(this.renderLoopBrFactor * ((float)col.getRed() / 255.0f)), (float)(this.renderLoopBrFactor * ((float)col.getGreen() / 255.0f)), (float)(this.renderLoopBrFactor * ((float)col.getBlue() / 255.0f)), (float)(this.renderLoopBrFactor * ((float)col.getAlpha() / 255.0f)));
                SpriteSheetResource res = node.getSpriteTexture().resolveSprite();
                res.getResource().bindTexture();
                Tuple<Double, Double> uvTexture = res.getUVOffset(ClientScheduler.getClientTick());
                vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                vb.func_181662_b(pxWH, zoomedWH - pxWH, (double)zLevel).func_187315_a(((Double)uvTexture.key).doubleValue(), (Double)uvTexture.value + res.getVLength()).func_181675_d();
                vb.func_181662_b(zoomedWH - pxWH, zoomedWH - pxWH, (double)zLevel).func_187315_a((Double)uvTexture.key + res.getULength(), (Double)uvTexture.value + res.getVLength()).func_181675_d();
                vb.func_181662_b(zoomedWH - pxWH, pxWH, (double)zLevel).func_187315_a((Double)uvTexture.key + res.getULength(), ((Double)uvTexture.value).doubleValue()).func_181675_d();
                vb.func_181662_b(pxWH, pxWH, (double)zLevel).func_187315_a(((Double)uvTexture.key).doubleValue(), ((Double)uvTexture.value).doubleValue()).func_181675_d();
                t.func_78381_a();
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                TextureHelper.refreshTextureBindState();
                GlStateManager.func_179141_d();
                break;
            }
        }
        GL11.glPopMatrix();
    }

    private void renderConnectionLines(ResearchNode node, double lowerPosX, double lowerPosY, double midX, double midY, float zLevel) {
        double xAdd = lowerPosX - (this.mousePointScaled.getScaledPosX() - this.partSizeHandler.widthToBorder) + this.partSizeHandler.getZoomedWHNode() / 2.0;
        double yAdd = lowerPosY - (this.mousePointScaled.getScaledPosY() - this.partSizeHandler.heightToBorder) + this.partSizeHandler.getZoomedWHNode() / 2.0;
        for (ResearchNode other : node.getConnectionsTo()) {
            this.renderConnection(other, xAdd, yAdd, midX, midY, zLevel);
        }
    }

    private void renderConnection(ResearchNode to, double fromX, double fromY, double midX, double midY, float zLevel) {
        double relToX = midX + (double)to.renderPosX * (this.partSizeHandler.getZoomedWHNode() + this.partSizeHandler.getZoomedSpaceBetweenNodes());
        double relToY = midY + (double)to.renderPosZ * (this.partSizeHandler.getZoomedWHNode() + this.partSizeHandler.getZoomedSpaceBetweenNodes());
        double targetXOffset = relToX - (this.mousePointScaled.getScaledPosX() - this.partSizeHandler.widthToBorder) + this.partSizeHandler.getZoomedWHNode() / 2.0;
        double targetYOffset = relToY - (this.mousePointScaled.getScaledPosY() - this.partSizeHandler.heightToBorder) + this.partSizeHandler.getZoomedWHNode() / 2.0;
        this.drawConnection(fromX, fromY, targetXOffset, targetYOffset, zLevel);
    }

    private void drawConnection(double originX, double originY, double targetX, double targetY, float zLevel) {
        GL11.glPushMatrix();
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glLineWidth((float)3.5f);
        GL11.glEnable((int)2848);
        GL11.glHint((int)3154, (int)4354);
        long clientTicks = ClientScheduler.getClientTick();
        Vector3 origin = new Vector3(originX, originY, 0.0);
        Vector3 line = origin.vectorFromHereTo(targetX, targetY, 0.0);
        int segments = (int)Math.ceil(line.length() / 1.0);
        int activeSegment = (int)(clientTicks % (long)segments);
        Vector3 segmentIter = line.divide(segments);
        for (int i = segments; i >= 0; --i) {
            double lx = origin.getX();
            double ly = origin.getY();
            origin.add(segmentIter);
            float brightness = 0.4f;
            this.drawLinePart(lx, ly, origin.getX(), origin.getY(), zLevel, brightness += 0.6f * this.evaluateBrightness(i, activeSegment));
        }
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)2848);
        GL11.glLineWidth((float)2.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glPopMatrix();
    }

    private void drawLinePart(double lx, double ly, double hx, double hy, double zLevel, float brightness) {
        lx += (double)this.renderOffsetX;
        ly += (double)this.renderOffsetY;
        hx += (double)this.renderOffsetX;
        hy += (double)this.renderOffsetY;
        GL11.glColor4f((float)(brightness *= this.renderLoopBrFactor), (float)brightness, (float)brightness, (float)(0.5f * this.renderLoopBrFactor));
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder vb = t.func_178180_c();
        vb.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        vb.func_181662_b(lx, ly, zLevel).func_181675_d();
        vb.func_181662_b(hx, hy, zLevel).func_181675_d();
        t.func_78381_a();
    }

    private float evaluateBrightness(int segment, int activeSegment) {
        if (segment == activeSegment) {
            return 1.0f;
        }
        float res = (float)(10 - Math.abs(activeSegment - segment)) / 10.0f;
        return Math.max(0.0f, res);
    }

    private void drawResearchItemBackground(double zoomedWH, double xAdd, double yAdd, float zLevel) {
        GL11.glColor4f((float)this.renderLoopBrFactor, (float)this.renderLoopBrFactor, (float)this.renderLoopBrFactor, (float)this.renderLoopBrFactor);
        Tessellator t = Tessellator.func_178181_a();
        BufferBuilder vb = t.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vb.func_181662_b((double)this.renderOffsetX + xAdd, (double)this.renderOffsetY + yAdd + zoomedWH, (double)zLevel).func_187315_a(0.0, 1.0).func_181675_d();
        vb.func_181662_b((double)this.renderOffsetX + xAdd + zoomedWH, (double)this.renderOffsetY + yAdd + zoomedWH, (double)zLevel).func_187315_a(1.0, 1.0).func_181675_d();
        vb.func_181662_b((double)this.renderOffsetX + xAdd + zoomedWH, (double)this.renderOffsetY + yAdd, (double)zLevel).func_187315_a(1.0, 0.0).func_181675_d();
        vb.func_181662_b((double)this.renderOffsetX + xAdd, (double)this.renderOffsetY + yAdd, (double)zLevel).func_187315_a(0.0, 0.0).func_181675_d();
        t.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

