/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.registry;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RegistrationQueue {
    private final Multimap<Class, IForgeRegistryEntry> queue = HashMultimap.create();

    public RegistrationQueue() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public <T> RegistrationQueue enqueue(IForgeRegistryEntry<T> entry) {
        this.queue.put((Object)entry.getRegistryType(), entry);
        return this;
    }

    public <T> RegistrationQueue enqueue(IForgeRegistryEntry<T> ... entries) {
        for (IForgeRegistryEntry<T> entry : entries) {
            this.enqueue(entry);
        }
        return this;
    }

    @SubscribeEvent
    public void register(RegistryEvent.Register event) {
        if (this.queue.containsKey((Object)event.getGenericType())) {
            this.queue.get((Object)((Class)event.getGenericType())).forEach(entry -> event.getRegistry().register(entry));
        }
    }
}

