/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.render.world;

import code.elix_x.excore.utils.client.render.OpenGLHelper;
import code.elix_x.excore.utils.client.render.world.SingleChunkBlockAccessRenderer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;

public class MultiChunkBlockAccessRenderer {
    protected final IBlockAccess world;
    protected final AxisAlignedBB shape;
    protected final AxisAlignedBB shapeResult;
    protected final Vec3i renderBlock;
    protected int maxUpdatesPerFrame = -1;
    protected boolean[] layers = new boolean[BlockRenderLayer.values().length];
    protected final List<SingleChunkBlockAccessRenderer> renderers = new ArrayList<SingleChunkBlockAccessRenderer>();

    public static int findOptimalBlockDimension(int size, int maxBlock, int minBlock) {
        for (int next = maxBlock; next >= minBlock; --next) {
            if (size % next != 0) continue;
            return next;
        }
        return maxBlock;
    }

    public MultiChunkBlockAccessRenderer(IBlockAccess world, AxisAlignedBB shape, AxisAlignedBB shapeResult, Vec3i renderBlock) {
        this.world = world;
        this.shape = shape;
        this.shapeResult = shapeResult;
        this.renderBlock = renderBlock;
        this.initRenderers();
    }

    public MultiChunkBlockAccessRenderer(IBlockAccess world, AxisAlignedBB shape, Vec3d posResult, Vec3i renderBlock) {
        this(world, shape, shape.func_191194_a(posResult.func_178788_d(shape.func_189972_c())), renderBlock);
    }

    public MultiChunkBlockAccessRenderer(IBlockAccess world, AxisAlignedBB shape, Vec3i renderBlock) {
        this(world, shape, shape, renderBlock);
    }

    public MultiChunkBlockAccessRenderer(IBlockAccess world, AxisAlignedBB shape, AxisAlignedBB shapeResult) {
        this.world = world;
        this.shape = shape;
        this.shapeResult = shapeResult;
        this.renderBlock = new Vec3i(MultiChunkBlockAccessRenderer.findOptimalBlockDimension((int)(this.shape.field_72336_d - this.shape.field_72340_a), 16, 4), MultiChunkBlockAccessRenderer.findOptimalBlockDimension((int)(this.shape.field_72337_e - this.shape.field_72338_b), 16, 4), MultiChunkBlockAccessRenderer.findOptimalBlockDimension((int)(this.shape.field_72334_f - this.shape.field_72339_c), 16, 4));
        this.initRenderers();
    }

    public MultiChunkBlockAccessRenderer(IBlockAccess world, AxisAlignedBB shape, Vec3d posResult) {
        this(world, shape, shape.func_191194_a(posResult.func_178788_d(shape.func_189972_c())));
    }

    public MultiChunkBlockAccessRenderer(IBlockAccess world, AxisAlignedBB shape) {
        this(world, shape, shape);
    }

    public void setMaxUpdatesPerFrame(int maxUpdatesPerFrame) {
        this.maxUpdatesPerFrame = maxUpdatesPerFrame;
    }

    protected void initRenderers() {
        this.renderers.clear();
        int x = 0;
        while ((double)x < Math.ceil((this.shape.field_72336_d - this.shape.field_72340_a) / (double)this.renderBlock.func_177958_n())) {
            int y = 0;
            while ((double)y < Math.ceil((this.shape.field_72337_e - this.shape.field_72338_b) / (double)this.renderBlock.func_177956_o())) {
                int z = 0;
                while ((double)z < Math.ceil((this.shape.field_72334_f - this.shape.field_72339_c) / (double)this.renderBlock.func_177952_p())) {
                    this.renderers.add(new SingleChunkBlockAccessRenderer(this.world, new AxisAlignedBB(this.shape.field_72340_a + (double)(x * this.renderBlock.func_177958_n()), this.shape.field_72338_b + (double)(y * this.renderBlock.func_177956_o()), this.shape.field_72339_c + (double)(z * this.renderBlock.func_177952_p()), Math.min(this.shape.field_72340_a + (double)((x + 1) * this.renderBlock.func_177958_n()), this.shape.field_72336_d), Math.min(this.shape.field_72338_b + (double)((y + 1) * this.renderBlock.func_177956_o()), this.shape.field_72337_e), Math.min(this.shape.field_72339_c + (double)((z + 1) * this.renderBlock.func_177952_p()), this.shape.field_72334_f))));
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public boolean doRenderLayer(BlockRenderLayer layer) {
        return this.layers[layer.ordinal()];
    }

    public boolean isEmpty() {
        boolean notEmpty = false;
        for (BlockRenderLayer layer : BlockRenderLayer.values()) {
            notEmpty |= this.doRenderLayer(layer);
        }
        return !notEmpty;
    }

    public void markDirty(AxisAlignedBB region) {
        for (SingleChunkBlockAccessRenderer renderer : this.renderers) {
            if (!renderer.shape.func_72326_a(region)) continue;
            renderer.markDirty();
        }
    }

    public void markDirty(BlockPos region) {
        this.markDirty(new AxisAlignedBB(region.func_177982_a(-1, -1, -1), region.func_177982_a(1, 1, 1)));
    }

    public void render() {
        this.updateCheck();
        if (!this.isEmpty()) {
            this.renderSetup();
            this.renderPre();
            for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                if (!this.doRenderLayer(layer)) continue;
                this.renderLayerSetup(layer);
                this.renderLayer(layer);
                this.renderLayerCleanup(layer);
            }
            this.renderPost();
            this.renderCleanup();
        }
    }

    protected void updateCheck() {
        if (this.maxUpdatesPerFrame != 0) {
            this.updateCheck(this.maxUpdatesPerFrame);
        }
    }

    public int updateCheck(int maxUpdates) {
        int updatesLeft = maxUpdates;
        Iterator<SingleChunkBlockAccessRenderer> iterator = this.renderers.iterator();
        while (updatesLeft != 0 && iterator.hasNext()) {
            if (!iterator.next().updateCheck()) continue;
            --updatesLeft;
        }
        if (updatesLeft != maxUpdates) {
            block1: for (BlockRenderLayer layer : BlockRenderLayer.values()) {
                for (SingleChunkBlockAccessRenderer renderer : this.renderers) {
                    if (!renderer.doRenderLayer(layer)) continue;
                    this.layers[layer.ordinal()] = true;
                    continue block1;
                }
            }
        }
        return maxUpdates - updatesLeft;
    }

    protected void renderSetup() {
        OpenGLHelper.enableClientState(DefaultVertexFormats.field_176600_a);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        Minecraft.func_71410_x().field_71460_t.func_180436_i();
    }

    protected void renderPre() {
        GlStateManager.func_179094_E();
        double scaleX = (this.shapeResult.field_72336_d - this.shapeResult.field_72340_a) / (this.shape.field_72336_d - this.shape.field_72340_a);
        double scaleY = (this.shapeResult.field_72337_e - this.shapeResult.field_72338_b) / (this.shape.field_72337_e - this.shape.field_72338_b);
        double scaleZ = (this.shapeResult.field_72334_f - this.shapeResult.field_72339_c) / (this.shape.field_72334_f - this.shape.field_72339_c);
        GlStateManager.func_179139_a((double)scaleX, (double)scaleY, (double)scaleZ);
        GlStateManager.func_179137_b((double)((double)this.renderBlock.func_177958_n() / 2.0), (double)((double)this.renderBlock.func_177956_o() / 2.0), (double)((double)this.renderBlock.func_177952_p() / 2.0));
    }

    protected void renderLayerSetup(BlockRenderLayer layer) {
        switch (layer) {
            case SOLID: {
                GlStateManager.func_179118_c();
                break;
            }
            case CUTOUT_MIPPED: {
                GlStateManager.func_179141_d();
                break;
            }
            case CUTOUT: {
                GlStateManager.func_179141_d();
                Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
            }
            case TRANSLUCENT: {
                GlStateManager.func_179141_d();
                GlStateManager.func_179147_l();
            }
        }
    }

    protected void renderLayer(BlockRenderLayer layer) {
        for (SingleChunkBlockAccessRenderer renderer : this.renderers) {
            if (!renderer.doRenderLayer(layer)) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(renderer.shape.field_72340_a - this.shape.field_72340_a), (double)(renderer.shape.field_72338_b - this.shape.field_72338_b), (double)(renderer.shape.field_72339_c - this.shape.field_72339_c));
            renderer.renderLayer(layer);
            GlStateManager.func_179121_F();
        }
    }

    protected void renderLayerCleanup(BlockRenderLayer layer) {
        switch (layer) {
            case SOLID: {
                break;
            }
            case CUTOUT_MIPPED: {
                break;
            }
            case CUTOUT: {
                Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
                break;
            }
            case TRANSLUCENT: {
                GlStateManager.func_179084_k();
            }
        }
    }

    protected void renderPost() {
        GlStateManager.func_179121_F();
    }

    protected void renderCleanup() {
        Minecraft.func_71410_x().field_71460_t.func_175072_h();
        RenderHelper.func_74519_b();
        OpenGLHelper.disableClientState(DefaultVertexFormats.field_176600_a);
    }

    public void cleanUp() {
        this.renderers.forEach(SingleChunkBlockAccessRenderer::cleanUp);
    }
}

