/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.render.vao;

import code.elix_x.excore.utils.client.render.vao.VertexBuffer;
import code.elix_x.excore.utils.client.render.vbo.VBO;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20;

public class VertexBufferSingle
extends VertexBuffer {
    private final VBO[] vbos;

    private VertexBufferSingle(VertexFormat format, int drawMode, int vertexCount) {
        super(format, drawMode, vertexCount);
        HashSet<Integer> vboIndexes = new HashSet<Integer>();
        for (VertexFormatElement element : format.func_177343_g()) {
            vboIndexes.add(element.func_177369_e());
        }
        this.vbos = new VBO[vboIndexes.size()];
        for (int i = 0; i < this.vbos.length; ++i) {
            this.vbos[i] = new VBO();
        }
    }

    public VertexBufferSingle(BufferBuilder vertexBuffer) {
        this(vertexBuffer.func_178973_g(), vertexBuffer.func_178979_i(), vertexBuffer.func_178989_h());
        int[] sizes = new int[this.vbos.length];
        Arrays.fill(sizes, 0);
        for (VertexFormatElement element : this.format.func_177343_g()) {
            int n = element.func_177369_e();
            sizes[n] = sizes[n] + element.func_177368_f();
        }
        ByteBuffer bytebuf = vertexBuffer.func_178966_f();
        Object[] byteBuffers = new ByteBuffer[this.vbos.length];
        for (int e = 0; e < byteBuffers.length; ++e) {
            byteBuffers[e] = BufferUtils.createByteBuffer((int)(sizes[e] * this.vertexCount));
        }
        for (int v = 0; v < this.vertexCount; ++v) {
            for (VertexFormatElement element : this.format.func_177343_g()) {
                Object buffer = byteBuffers[element.func_177369_e()];
                byte[] bytes = new byte[element.func_177368_f()];
                bytebuf.get(bytes);
                ((ByteBuffer)buffer).put(bytes);
            }
        }
        System.out.println(Arrays.toString(byteBuffers));
        this.vao.bind();
        for (int b = 0; b < this.vbos.length; ++b) {
            VBO vbo = this.vbos[b];
            Object buffer = byteBuffers[b];
            VertexFormatElement formatElement = this.format.func_177348_c(b);
            ((ByteBuffer)buffer).flip();
            vbo.bind();
            vbo.data((ByteBuffer)buffer, 35044);
            for (VertexFormatElement element : this.format.func_177343_g()) {
                if (element.func_177369_e() != b) continue;
                this.vao.vboSingle(vbo, b, this.format, formatElement);
            }
            vbo.unbind();
        }
        this.vao.unbind();
    }

    @Override
    protected void renderPre() {
        super.renderPre();
        for (int i = 0; i < this.vbos.length; ++i) {
            GL20.glEnableVertexAttribArray((int)i);
        }
    }

    @Override
    protected void renderPost() {
        for (int i = 0; i < this.vbos.length; ++i) {
            GL20.glDisableVertexAttribArray((int)i);
        }
        super.renderPost();
    }

    @Override
    public void cleanUp() {
        for (VBO vbo : this.vbos) {
            vbo.cleanUp();
        }
        super.cleanUp();
    }
}

