/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excomms.tick;

import java.lang.ref.WeakReference;
import java.util.function.Consumer;

public class Ticker {
    private static final Thread tickerGranularityHack = new Thread(() -> {
        while (true) {
            Ticker.sleep(Long.MAX_VALUE);
        }
    }, "EXComms Ticker Granularity Hack Thread");
    private long tickTime;
    private long catchUpMaxDelta = 3000L;
    private Consumer<String> warningMessagesConsumer = message -> {};
    private WeakReference<Thread> thread;
    private long startTime;
    private long tickCount;

    private static void sleep(long millis) {
        if (millis <= 1L) {
            return;
        }
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void onTickerStart() {
        if (!tickerGranularityHack.isAlive()) {
            tickerGranularityHack.start();
        }
    }

    public boolean isRunning() {
        return this.thread != null;
    }

    private void assertNotRunning() {
        if (this.isRunning()) {
            throw new IllegalStateException("Invalid operation. Ticker is running!");
        }
    }

    public boolean isActuallyRunning() {
        return this.isRunning() && !this.thread.isEnqueued() && this.thread.get() != null && ((Thread)this.thread.get()).isAlive();
    }

    public long getTickTime() {
        return this.tickTime;
    }

    public Ticker setTickTime(long tickTime) throws IllegalStateException, IllegalArgumentException {
        if (tickTime < 4L) {
            throw new IllegalArgumentException(String.format("Tick time requested (%s) may be too low for precision ticking. Either make it higher than 3 seconds or use #setTickTimeForce if you want to force usage of that tick time.", tickTime));
        }
        return this.setTickTimeForce(tickTime);
    }

    public Ticker setTickTimeForce(long tickTime) throws IllegalStateException, IllegalArgumentException {
        this.assertNotRunning();
        if (tickTime <= 0L) {
            throw new IllegalArgumentException("Tick time cannot be zero or negative.");
        }
        this.tickTime = tickTime;
        return this;
    }

    public long getCatchUpMaxDelta() {
        return this.catchUpMaxDelta;
    }

    public Ticker setCatchUpMaxDelta(long catchUpMaxDelta) {
        this.catchUpMaxDelta = catchUpMaxDelta;
        return this;
    }

    public Ticker setCatchUpMaxDeltaDefault() {
        return this.setCatchUpMaxDelta(3000L);
    }

    public Ticker setNoCatchUp() {
        return this.setCatchUpMaxDelta(0L);
    }

    public Ticker setWarningMessagesConsumer(Consumer<String> warningMessagesConsumer) {
        this.warningMessagesConsumer = warningMessagesConsumer;
        return this;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTickCount() {
        return this.tickCount;
    }

    public void start() throws IllegalStateException {
        this.assertNotRunning();
        Ticker.onTickerStart();
        this.thread = new WeakReference<Thread>(Thread.currentThread());
        this.startTime = System.currentTimeMillis();
        this.tickCount = 0L;
    }

    public void finishTick() throws IllegalStateException {
        long actualTicksElapsed;
        if (!this.isRunning()) {
            return;
        }
        if (!this.isActuallyRunning()) {
            this.stop();
            return;
        }
        if (Thread.currentThread() != this.thread.get()) {
            throw new IllegalStateException("Finish tick must be called from the thread which started the ticker.");
        }
        long time = System.currentTimeMillis() - this.startTime;
        long afterStart = time % this.tickTime;
        if (afterStart == 0L) {
            ++time;
            afterStart = 1L;
        }
        if ((actualTicksElapsed = (time - afterStart) / this.tickTime) == this.tickCount) {
            while (afterStart > 0L) {
                Ticker.sleep((this.tickTime - afterStart) / 2L);
                long currentTime = System.currentTimeMillis();
                afterStart = currentTime % this.tickTime;
            }
            ++this.tickCount;
        } else if (actualTicksElapsed > this.tickCount) {
            long timeDelta = time - this.tickCount * this.tickTime;
            if (timeDelta >= this.getCatchUpMaxDelta()) {
                this.warningMessagesConsumer.accept("Could not catch up. Skipping " + (actualTicksElapsed - this.tickCount) + " ticks.");
                this.tickCount = actualTicksElapsed;
                this.finishTick();
            }
            ++this.tickCount;
        } else if (this.tickCount - actualTicksElapsed < 2L) {
            Ticker.sleep(this.tickTime == 1L ? 2L : this.tickTime);
            this.finishTick();
        } else {
            this.warningMessagesConsumer.accept("Time went backwards. Restarting.");
            this.stop();
            this.start();
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.thread = null;
        }
    }

    static {
        tickerGranularityHack.setDaemon(true);
    }
}

