/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.common.tile;

import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.helpers.NBTHelper;
import sonar.core.sync.ISonarValue;
import sonar.core.sync.IValueWatcher;
import sonar.core.sync.ValueWatcher;

public class TileEntitySaveable
extends TileEntity
implements ITickable,
INBTSyncable {
    public final ValueWatcher value_watcher = new ValueWatcher(new IValueWatcher(){

        @Override
        public void onSyncValueChanged(ISonarValue value) {
            TileEntitySaveable.this.onInternalValueChanged(value);
        }
    });

    public void onValuesChanged() {
    }

    public void onInternalValueChanged(ISonarValue value) {
    }

    public void func_73660_a() {
        if (this.value_watcher.isDirty()) {
            this.onValuesChanged();
            this.value_watcher.forEachSyncable(s -> s.setDirty(false));
            this.value_watcher.setDirty(false);
            if (!this.field_145850_b.field_72995_K) {
                this.func_70296_d();
            }
        }
    }

    public final void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.readData(compound, NBTHelper.SyncType.SAVE);
    }

    public final NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        this.writeData(compound, NBTHelper.SyncType.SAVE);
        return compound;
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.value_watcher.forEachSyncable(v -> {
            if (v.canLoadFrom(nbt)) {
                v.load(nbt);
            }
        });
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.value_watcher.forEachSyncable(v -> v.save(nbt));
        return nbt;
    }

    public final SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.func_189515_b(new NBTTagCompound());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, tag);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public NBTHelper.SyncType getUpdateTagType() {
        return NBTHelper.SyncType.SYNC_OVERRIDE;
    }

    @Nonnull
    public NBTTagCompound func_189517_E_() {
        return this.writeData(super.func_189517_E_(), this.getUpdateTagType());
    }

    public void handleUpdateTag(@Nonnull NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.readData(tag, this.getUpdateTagType());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }
}

