/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.util;

import ipsis.woot.util.WootMobName;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;

public class WootMobNameBuilder {
    private static final String NBT_WOOT_MOB_NAME_KEY = "wootMobNameKey";
    private static final String NBT_WOOT_MOB_NAME_TAG = "wootMobNameTag";

    @Nonnull
    public static WootMobName create(@Nonnull EntityLiving entityLiving) {
        WootMobName wootMobName = new WootMobName();
        ResourceLocation resourceLocation = EntityList.func_191301_a((Entity)entityLiving);
        if (resourceLocation != null) {
            wootMobName = new WootMobName(resourceLocation.toString());
        }
        return wootMobName;
    }

    @Nonnull
    public static WootMobName create(String name) {
        WootMobName wootMobName = new WootMobName();
        String[] parts = name.split(Pattern.quote(","));
        if (parts.length == 1) {
            wootMobName = new WootMobName(parts[0]);
        } else if (parts.length == 2) {
            wootMobName = new WootMobName(parts[0], parts[1]);
        }
        return wootMobName;
    }

    @Nonnull
    public static WootMobName createFromConfigString(String name) {
        WootMobName wootMobName = WootMobNameBuilder.create(name);
        if (!wootMobName.isValid() && EntityList.func_180125_b((ResourceLocation)new ResourceLocation(name))) {
            wootMobName = new WootMobName(name);
        }
        return wootMobName;
    }

    public static void writeToNBT(WootMobName wootMobName, NBTTagCompound tagCompound) {
        if (!wootMobName.isValid()) {
            return;
        }
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74778_a(NBT_WOOT_MOB_NAME_KEY, wootMobName.getEntityKey());
        tagCompound.func_74778_a(NBT_WOOT_MOB_NAME_TAG, wootMobName.getTag());
    }

    @Nonnull
    public static WootMobName create(NBTTagCompound tagCompound) {
        if (tagCompound == null || !tagCompound.func_74764_b(NBT_WOOT_MOB_NAME_KEY) || !tagCompound.func_74764_b(NBT_WOOT_MOB_NAME_TAG)) {
            return new WootMobName();
        }
        return new WootMobName(tagCompound.func_74779_i(NBT_WOOT_MOB_NAME_KEY), tagCompound.func_74779_i(NBT_WOOT_MOB_NAME_TAG));
    }
}

