/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.tileentity;

import ipsis.Woot;
import ipsis.woot.crafting.AnvilHelper;
import ipsis.woot.crafting.IAnvilRecipe;
import ipsis.woot.item.ItemEnderShard;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.StringHelper;
import ipsis.woot.util.WootMob;
import ipsis.woot.util.WootMobBuilder;
import ipsis.woot.util.WorldHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class TileEntityAnvil
extends TileEntity {
    private ItemStack itemStack = ItemStack.field_190927_a;

    @Nonnull
    public ItemStack getBaseItem() {
        return this.itemStack;
    }

    public void setBaseItem(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.func_70296_d();
        if (this.func_145831_w() != null) {
            IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
            this.func_145831_w().func_184138_a(this.func_174877_v(), state, state, 3);
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, nbtTagCompound);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.itemStack = compound.func_74764_b("baseItem") ? new ItemStack(compound.func_74775_l("baseItem")) : ItemStack.field_190927_a;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        if (!this.itemStack.func_190926_b()) {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            this.itemStack.func_77955_b(nbtTagCompound);
            compound.func_74782_a("baseItem", (NBTBase)nbtTagCompound);
        }
        return compound;
    }

    public void tryCraft(EntityPlayer entityPlayer) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.ANVIL_CRAFTING, "tryCraft", this.itemStack);
        if (!AnvilHelper.isAnvilHot(this.func_145831_w(), this.func_174877_v())) {
            entityPlayer.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localize("chat.woot.anvil.nomagma")), false);
            return;
        }
        List<EntityItem> entityItemList = AnvilHelper.getItems(this.func_145831_w(), this.func_174877_v());
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (EntityItem e : entityItemList) {
            ingredients.add(e.func_92059_d());
        }
        if (ItemEnderShard.isEnderShard(this.itemStack) && !ItemEnderShard.isFull(this.itemStack)) {
            entityPlayer.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localize("chat.woot.anvil.emptyshard")), false);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187686_e, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return;
        }
        IAnvilRecipe recipe = Woot.anvilManager.getRecipe(this.itemStack, ingredients);
        if (recipe != null) {
            ItemStack output = recipe.getCopyOutput();
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.ANVIL_CRAFTING, "tryCraft", "Output " + output);
            if (ItemEnderShard.isFull(this.itemStack)) {
                WootMob tmpWootMob = WootMobBuilder.create(this.itemStack.func_77978_p());
                NBTTagCompound tag = new NBTTagCompound();
                WootMobBuilder.writeToNBT(tmpWootMob, tag);
                output.func_77982_d(tag);
            }
            if (!recipe.shouldPreserveBase()) {
                this.setBaseItem(ItemStack.field_190927_a);
            }
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187686_e, SoundCategory.BLOCKS, 1.0f, 1.0f);
            WorldHelper.spawnInWorld(this.field_145850_b, this.field_174879_c, output);
            if (!ingredients.isEmpty()) {
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.ANVIL_CRAFTING, "tryCraft", "Leftovers " + ingredients);
            }
            block1: for (ItemStack recipeStack : recipe.getInputs()) {
                int count = recipeStack.func_190916_E();
                for (EntityItem entityItem : entityItemList) {
                    ItemStack itemStack = entityItem.func_92059_d();
                    if (ItemStack.func_179545_c((ItemStack)itemStack, (ItemStack)recipeStack)) {
                        if (entityItem.func_92059_d().func_190916_E() >= count) {
                            entityItem.func_92059_d().func_190920_e(entityItem.func_92059_d().func_190916_E() - count);
                            count = 0;
                        } else {
                            count -= entityItem.func_92059_d().func_190916_E();
                            entityItem.func_92059_d().func_190920_e(0);
                        }
                        if (entityItem.func_92059_d().func_190916_E() <= 0) {
                            entityItem.func_70106_y();
                        }
                    }
                    if (count != 0) continue;
                    continue block1;
                }
            }
        } else {
            entityPlayer.func_146105_b((ITextComponent)new TextComponentString(StringHelper.localize("chat.woot.anvil.invalid")), false);
            this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187686_e, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }
}

