/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.loot.generators;

import ipsis.Woot;
import ipsis.woot.loot.LootGenerationFarmInfo;
import ipsis.woot.loot.generators.ILootGenerator;
import ipsis.woot.loot.repository.ILootRepositoryLookup;
import ipsis.woot.plugins.thauncraft.Thaumcraft;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.EnumEnchantKey;
import ipsis.woot.util.LootHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemGenerator
implements ILootGenerator {
    private boolean shouldEnchant(DifficultyInstance difficultyInstance) {
        return Woot.RANDOM.nextFloat() < 0.25f * difficultyInstance.func_180170_c();
    }

    private void stripEnchant(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            itemStack.func_77978_p().func_82580_o("ench");
        }
    }

    private void addEnchant(ItemStack itemStack, DifficultyInstance difficulty) {
        if (!itemStack.func_77956_u()) {
            return;
        }
        float f = difficulty.func_180170_c();
        boolean allowTreasure = false;
        EnchantmentHelper.func_77504_a((Random)Woot.RANDOM, (ItemStack)itemStack, (int)((int)(5.0f + f * (float)Woot.RANDOM.nextInt(18))), (boolean)allowTreasure);
    }

    private void damageItem(ItemStack itemStack) {
        if (!itemStack.func_77984_f()) {
            return;
        }
        int dmg = Woot.RANDOM.nextInt(itemStack.func_77958_k() + 1);
        dmg = MathHelper.func_76125_a((int)dmg, (int)1, (int)itemStack.func_77958_k());
        itemStack.func_77964_b(dmg);
    }

    private ItemStack generateItemStack(ItemStack itemStack, EnumEnchantKey key) {
        ItemStack outStack = itemStack.func_77946_l();
        if (Thaumcraft.isThaumcraftCrystal(outStack)) {
            outStack = Thaumcraft.getCrystal(key);
        }
        return outStack;
    }

    private List<ItemStack> calculateDrops(List<ILootRepositoryLookup.LootItemStack> loot, DifficultyInstance difficulty, EnumEnchantKey key) {
        boolean shouldEnchant = this.shouldEnchant(difficulty);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (ILootRepositoryLookup.LootItemStack drop : loot) {
            if (drop.itemStack.func_190926_b()) continue;
            if (!Woot.policyRepository.canDrop(drop.itemStack)) {
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_ITEMS, "calculateDrops", "policy removed " + drop.itemStack);
                continue;
            }
            int chance = Woot.RANDOM.nextInt(101);
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_ITEMS, "calculateDrops", drop + " rolled:" + chance);
            if (chance > drop.dropChance) {
                Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_ITEMS, "calculateDrops", drop + " failed");
                continue;
            }
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_ITEMS, "calculateDrops", drop + " succeed");
            int stackSize = 0;
            double completeWeight = 0.0;
            for (int s : drop.sizes.keySet()) {
                completeWeight += (double)drop.sizes.get(s).intValue();
            }
            double r = Math.random() * completeWeight;
            double countWeight = 0.0;
            for (int s : drop.sizes.keySet()) {
                if (!((countWeight += (double)drop.sizes.get(s).intValue()) >= r)) continue;
                stackSize = s;
                break;
            }
            if (stackSize == 0) continue;
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_ITEMS, "calculateDrops", drop + " *** stacksize:" + stackSize);
            ItemStack itemStack = this.generateItemStack(drop.itemStack, key);
            itemStack.func_190920_e(stackSize);
            if (itemStack.func_77984_f()) {
                this.damageItem(itemStack);
            }
            if (itemStack.func_77948_v()) {
                shouldEnchant = false;
                this.stripEnchant(itemStack);
                this.addEnchant(itemStack, difficulty);
            } else if (itemStack.func_77956_u() && shouldEnchant) {
                this.addEnchant(itemStack, difficulty);
            }
            drops.add(itemStack);
        }
        return drops;
    }

    @Override
    public void generate(World world, LootGenerationFarmInfo farmInfo) {
        if (farmInfo.itemHandlerList.size() == 0) {
            return;
        }
        List<ILootRepositoryLookup.LootItemStack> loot = LootHelper.getDrops(farmInfo.farmSetup.getWootMobName(), farmInfo.farmSetup.getEnchantKey());
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_ITEMS, "generate", farmInfo.farmSetup.getNumMobs() + "*" + farmInfo.farmSetup.getWootMobName());
        for (int i = 0; i < farmInfo.farmSetup.getNumMobs(); ++i) {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_ITEMS, "generate", "Generating loot for mob " + i);
            List<ItemStack> mobLoot = this.calculateDrops(loot, farmInfo.difficultyInstance, farmInfo.farmSetup.getEnchantKey());
            for (IItemHandler hdlr : farmInfo.itemHandlerList) {
                for (ItemStack itemStack : mobLoot) {
                    if (itemStack.func_190926_b()) continue;
                    boolean success = true;
                    while (success && !itemStack.func_190926_b()) {
                        ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)hdlr, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1), (boolean)false);
                        if (result.func_190926_b()) {
                            Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_ITEMS, "generate", "Placed itemstack of size 1 into inventory " + itemStack.func_82833_r());
                            itemStack.func_190918_g(1);
                            continue;
                        }
                        success = false;
                    }
                }
            }
            mobLoot.clear();
        }
    }
}

