/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.loot.generators;

import ipsis.Woot;
import ipsis.woot.loot.LootGenerationFarmInfo;
import ipsis.woot.loot.generators.ILootGenerator;
import ipsis.woot.util.ConfigKeyHelper;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.EnumFarmUpgrade;
import ipsis.woot.util.SkullHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DecapitationGenerator
implements ILootGenerator {
    @Override
    public void generate(World world, LootGenerationFarmInfo farmInfo) {
        if (farmInfo.itemHandlerList.size() == 0) {
            return;
        }
        if (!farmInfo.farmSetup.hasUpgrade(EnumFarmUpgrade.DECAPITATE)) {
            return;
        }
        ItemStack skull = SkullHelper.getSkull(farmInfo.farmSetup.getWootMobName());
        if (skull.func_190926_b()) {
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_HEADS, "generate", "No heads for " + farmInfo.farmSetup.getWootMobName());
            return;
        }
        ItemStack itemStack = skull.func_77946_l();
        itemStack.func_190920_e(0);
        int decap = Woot.wootConfiguration.getInteger(farmInfo.farmSetup.getWootMobName(), ConfigKeyHelper.getDecapParam(farmInfo.farmSetup.getUpgradeLevel(EnumFarmUpgrade.DECAPITATE)));
        float chance = (float)decap / 100.0f;
        for (int m = 0; m < farmInfo.farmSetup.getNumMobs(); ++m) {
            float v = Woot.RANDOM.nextFloat();
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_HEADS, "generate", decap + " " + v + " <= " + chance);
            if (!(v <= chance)) continue;
            itemStack.func_190920_e(itemStack.func_190916_E() + 1);
        }
        for (IItemHandler hdlr : farmInfo.itemHandlerList) {
            if (itemStack.func_190926_b()) continue;
            boolean success = true;
            while (success && !itemStack.func_190926_b()) {
                ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)hdlr, (ItemStack)ItemHandlerHelper.copyStackWithSize((ItemStack)itemStack, (int)1), (boolean)false);
                if (result.func_190926_b()) {
                    itemStack.func_190918_g(1);
                    Woot.debugSetup.trace(DebugSetup.EnumDebugType.GEN_HEADS, "generate", "placed skull in itemhandler with slots " + hdlr.getSlots());
                    continue;
                }
                success = false;
            }
        }
    }
}

