/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.configuration.loaders;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ipsis.Woot;
import ipsis.woot.farming.SpawnRecipe;
import ipsis.woot.oss.FileUtils;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.util.JsonHelper;
import ipsis.woot.util.WootMobName;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.fluids.FluidStack;

public class FactoryIngredientsLoader {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public void loadConfig() {
        try {
            String configText = FileUtils.copyConfigFileFromJar("factory_ingredients.json", false);
            JsonObject jsonObject = (JsonObject)JsonUtils.func_193837_a((Gson)GSON, (String)configText, JsonObject.class, (boolean)false);
            this.parseConfig(jsonObject);
        }
        catch (Exception e) {
            LogHelper.error("Could not load factory ingredients from " + FileUtils.getConfigFile("factory_ingredients.json").getAbsolutePath());
            e.printStackTrace();
        }
    }

    private void parseConfig(JsonObject json) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        int version = JsonUtils.func_151208_a((JsonObject)json, (String)"version", (int)-1);
        if (version == -1 || version != 1) {
            throw new JsonSyntaxException("Invalid version");
        }
        if (JsonUtils.func_151204_g((JsonObject)json, (String)"default")) {
            this.parseDefaultIngredients(JsonUtils.func_152754_s((JsonObject)json, (String)"default"));
        }
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"ingredients")) {
            this.parseIngredients(ele);
        }
    }

    private void parseDefaultIngredients(JsonObject ele) {
        JsonObject json2;
        if (ele == null || !ele.isJsonObject()) {
            throw new JsonSyntaxException("Default ingredients must be objects");
        }
        JsonObject json = ele;
        boolean efficiency = JsonUtils.func_151209_a((JsonObject)json, (String)"efficiency", (boolean)true);
        Woot.spawnRecipeRepository.setDefaultEfficiency(efficiency);
        for (JsonElement ele2 : JsonUtils.func_151214_t((JsonObject)json, (String)"items")) {
            if (ele2 == null || !ele.isJsonObject()) {
                throw new JsonSyntaxException("Recipe items must be object");
            }
            json2 = (JsonObject)ele2;
            ItemStack itemStack = JsonHelper.getItemStack(json2);
            if (itemStack.func_190926_b()) continue;
            Woot.spawnRecipeRepository.addDefaultItem(itemStack);
        }
        for (JsonElement ele2 : JsonUtils.func_151214_t((JsonObject)json, (String)"fluids")) {
            if (ele2 == null | !ele.isJsonObject()) {
                throw new JsonSyntaxException("Recipe fluids must be object");
            }
            json2 = (JsonObject)ele2;
            FluidStack fluidStack = JsonHelper.getFluidStack(json2);
            if (fluidStack == null || fluidStack.amount <= 0) continue;
            Woot.spawnRecipeRepository.addDefaultFluid(fluidStack);
        }
    }

    private void parseIngredients(JsonElement ele) {
        if (ele == null || !ele.isJsonObject()) {
            throw new JsonSyntaxException("Ingredients must be objects");
        }
        JsonObject json = (JsonObject)ele;
        WootMobName wootMobName = JsonHelper.getWootMobName(json);
        if (wootMobName.isValid()) {
            JsonObject json2;
            SpawnRecipe recipe = new SpawnRecipe();
            recipe.setEfficiency(true);
            boolean valid = true;
            for (JsonElement ele2 : JsonUtils.func_151214_t((JsonObject)json, (String)"items")) {
                if (ele2 == null || !ele.isJsonObject()) {
                    throw new JsonSyntaxException("Recipe items must be object");
                }
                json2 = (JsonObject)ele2;
                ItemStack itemStack = JsonHelper.getItemStack(json2);
                if (itemStack.func_190926_b()) {
                    valid = false;
                    continue;
                }
                recipe.addIngredient(itemStack);
            }
            for (JsonElement ele2 : JsonUtils.func_151214_t((JsonObject)json, (String)"fluids")) {
                if (ele2 == null | !ele.isJsonObject()) {
                    throw new JsonSyntaxException("Recipe fluids must be object");
                }
                json2 = (JsonObject)ele2;
                FluidStack fluidStack = JsonHelper.getFluidStack(json2);
                if (fluidStack == null) {
                    valid = false;
                    continue;
                }
                if (fluidStack.amount < 1) {
                    valid = false;
                    continue;
                }
                recipe.addIngredient(fluidStack);
            }
            if (!(!valid || recipe.getItems().isEmpty() && recipe.getFluids().isEmpty())) {
                Woot.spawnRecipeRepository.add(wootMobName, recipe);
            }
        }
    }
}

