/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.command;

import ipsis.Woot;
import ipsis.woot.command.ITextStatus;
import ipsis.woot.multiblock.EnumMobFactoryModule;
import ipsis.woot.multiblock.EnumMobFactoryTier;
import ipsis.woot.util.CommandHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.server.command.CommandTreeBase;

public class CommandDump
extends CommandTreeBase {
    public CommandDump() {
        this.addSubcommand((ICommand)new CommandDumpLoot());
        this.addSubcommand((ICommand)new CommandDumpMobs());
        this.addSubcommand((ICommand)new CommandDumpTartarus());
        this.addSubcommand((ICommand)new CommandDumpLearning());
        this.addSubcommand((ICommand)new CommandDumpPolicy());
        this.addSubcommand((ICommand)new CommandDumpStructure());
    }

    public String func_71517_b() {
        return "dump";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.woot.dump.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public static class CommandDumpPolicy
    extends CommandBase {
        public String func_71517_b() {
            return "policy";
        }

        public String func_71518_a(ICommandSender sender) {
            return "commands.woot.dump.policy.usage";
        }

        public int func_82362_a() {
            return 2;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            boolean internal;
            if (args.length < 2) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            if (args[0].equalsIgnoreCase("ext")) {
                internal = false;
            } else if (args[0].equalsIgnoreCase("int")) {
                internal = true;
            } else {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            if (args[1].equalsIgnoreCase("mob")) {
                List<String> mobList = Woot.policyRepository.getEntityList(internal);
                StringBuilder sb = new StringBuilder();
                for (String s : mobList) {
                    sb.append(s).append(" ");
                }
                CommandHelper.display(sender, sb.toString(), new Object[0]);
            } else if (args[1].equalsIgnoreCase("item")) {
                List<String> mobList = Woot.policyRepository.getItemList(internal);
                StringBuilder sb = new StringBuilder();
                for (String s : mobList) {
                    sb.append(s).append(" ");
                }
                CommandHelper.display(sender, sb.toString(), new Object[0]);
            } else {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    public static class CommandDumpLoot
    extends CommandBase {
        public String func_71517_b() {
            return "loot";
        }

        public String func_71518_a(ICommandSender sender) {
            return "commands.woot.dump.loot.usage";
        }

        public int func_82362_a() {
            return 2;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        }
    }

    public static class CommandDumpLearning
    extends CommandBase {
        public String func_71517_b() {
            return "learning";
        }

        public String func_71518_a(ICommandSender sender) {
            return "commands.woot.dump.learning.usage";
        }

        public int func_82362_a() {
            return 2;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length != 0) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            for (String s : Woot.lootRepository.getStatus()) {
                CommandHelper.display(sender, s, new Object[0]);
            }
        }
    }

    public static class CommandDumpTartarus
    extends CommandBase {
        public String func_71517_b() {
            return "tartarus";
        }

        public String func_71518_a(ICommandSender sender) {
            return "commands.woot.dump.tartarus.usage";
        }

        public int func_82362_a() {
            return 2;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            if (args.length != 0) {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
            ArrayList<ITextStatus> status = new ArrayList<ITextStatus>();
            status.add(Woot.wootDimensionManager);
            status.add(Woot.tartarusManager);
            for (ITextStatus status1 : status) {
                for (String s : status1.getStatus()) {
                    CommandHelper.display(sender, s, new Object[0]);
                }
                for (String s : status1.getStatus(server.func_71218_a(Woot.wootDimensionManager.getDimensionId()))) {
                    CommandHelper.display(sender, s, new Object[0]);
                }
            }
        }
    }

    public static class CommandDumpStructure
    extends CommandBase {
        public String func_71517_b() {
            return "structure";
        }

        public String func_71518_a(ICommandSender sender) {
            return "commands.woot.dump.structure.usage";
        }

        public int func_82362_a() {
            return 2;
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) {
            for (EnumMobFactoryTier tier : EnumMobFactoryTier.VALID_TIERS) {
                StringBuilder sb = new StringBuilder();
                for (EnumMobFactoryModule m : EnumMobFactoryModule.VALUES) {
                    int c = Woot.factoryPatternRepository.getBlockCount(tier, m);
                    if (c <= 0) continue;
                    String s = m.func_176610_l() + ":" + c + " ";
                    sb.append(s);
                }
                String s = tier.getTranslated("%s") + " " + sb.toString();
                CommandHelper.display(sender, s, new Object[0]);
            }
        }
    }

    public static class CommandDumpMobs
    extends CommandBase {
        public String func_71517_b() {
            return "mobs";
        }

        public String func_71518_a(ICommandSender sender) {
            return "commands.woot.dump.mobs.usage";
        }

        public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
            List<String> mobs = Woot.lootRepository.getAllMobs();
            for (String mob : mobs) {
                CommandHelper.display(sender, mob, new Object[0]);
            }
            mobs = Woot.customDropsRepository.getAllMobs();
            for (String mob : mobs) {
                CommandHelper.display(sender, mob, new Object[0]);
            }
        }
    }
}

