/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.block;

import ipsis.Woot;
import ipsis.woot.block.BlockWoot;
import ipsis.woot.init.ModBlocks;
import ipsis.woot.init.ModItems;
import ipsis.woot.oss.client.ModelHelper;
import ipsis.woot.tileentity.TileEntityAnvil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockWootAnvil
extends BlockWoot
implements ITileEntityProvider {
    public static final String BASENAME = "anvil";
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB X_AXIS_AABB = new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 1.0, 0.875);
    protected static final AxisAlignedBB Z_AXIS_AABB = new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 1.0, 1.0);

    public BlockWootAnvil() {
        super(Material.field_151574_g, BASENAME);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing enumFacing = placer.func_174811_aO().func_176746_e();
        return super.func_180642_a(world, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)FACING, (Comparable)enumFacing);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing enumFacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        return enumFacing.func_176740_k() == EnumFacing.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityAnvil anvil;
        ItemStack itemStack;
        super.getDrops(drops, world, pos, state, fortune);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityAnvil && !(itemStack = (anvil = (TileEntityAnvil)te).getBaseItem()).func_190926_b()) {
            drops.add((Object)itemStack.func_77946_l());
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        this.func_176206_d(world, pos, state);
        if (willHarvest) {
            this.func_180657_a(world, player, pos, state, world.func_175625_s(pos), player.func_184614_ca());
        }
        world.func_175698_g(pos);
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177230_c() != this ? state : state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelHelper.registerBlock(ModBlocks.blockAnvil, BASENAME);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityAnvil();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        if (!worldIn.field_72995_K && (te = worldIn.func_175625_s(pos)) instanceof TileEntityAnvil) {
            TileEntityAnvil anvil = (TileEntityAnvil)te;
            ItemStack playerItem = playerIn.func_184586_b(hand);
            if (anvil.getBaseItem().func_190926_b()) {
                if (Woot.anvilManager.isValidBaseItem(playerItem)) {
                    ItemStack baseItem = playerItem.func_77946_l();
                    baseItem.func_190920_e(1);
                    anvil.setBaseItem(baseItem);
                    playerItem.func_190920_e(playerItem.func_190916_E() - 1);
                    if (playerItem.func_190926_b()) {
                        playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    } else {
                        playerIn.field_71071_by.func_70299_a(playerIn.field_71071_by.field_70461_c, playerItem);
                    }
                    playerIn.field_71070_bA.func_75142_b();
                }
            } else if (playerItem.func_77973_b() == ModItems.itemYahHammer) {
                anvil.tryCraft(playerIn);
            } else {
                ItemStack baseItem = anvil.getBaseItem();
                anvil.setBaseItem(ItemStack.field_190927_a);
                if (!playerIn.field_71071_by.func_70441_a(baseItem)) {
                    EntityItem entityItem = new EntityItem(worldIn, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), baseItem);
                    worldIn.func_72838_d((Entity)entityItem);
                } else {
                    playerIn.field_71070_bA.func_75142_b();
                }
            }
        }
        return true;
    }
}

