/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.block;

import com.google.common.base.Predicate;
import ipsis.woot.block.BlockWoot;
import ipsis.woot.block.ITooltipInfo;
import ipsis.woot.init.ModBlocks;
import ipsis.woot.multiblock.EnumMobFactoryTier;
import ipsis.woot.oss.client.ModelHelper;
import ipsis.woot.plugins.top.ITOPInfoProvider;
import ipsis.woot.plugins.top.TOPUIInfoConvertors;
import ipsis.woot.tileentity.IMobFarm;
import ipsis.woot.tileentity.TileEntityMobFactoryHeart;
import ipsis.woot.tileentity.ui.FarmUIInfo;
import ipsis.woot.tools.IValidateTool;
import ipsis.woot.tools.ValidateToolUtils;
import java.util.List;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMobFactoryHeart
extends BlockWoot
implements ITooltipInfo,
ITileEntityProvider,
ITOPInfoProvider {
    public static final String BASENAME = "factory";
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockMobFactoryHeart() {
        super(Material.field_151576_e, BASENAME);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMobFactoryHeart();
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        EnumFacing f = placer.func_174811_aO().func_176734_d();
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)f), 2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelHelper.registerBlock(ModBlocks.blockFactoryHeart, BASENAME);
    }

    @Override
    public void getTooltip(List<String> toolTip, boolean showAdvanced, int meta, boolean detail) {
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof IMobFarm) {
            FarmUIInfo info = new FarmUIInfo();
            ((IMobFarm)te).getUIInfo(info);
            if (info.isValid) {
                TOPUIInfoConvertors.farmConvertor(info, mode, probeInfo, player, world, blockState, data);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (te instanceof TileEntityMobFactoryHeart) {
            TileEntityMobFactoryHeart heart = (TileEntityMobFactoryHeart)te;
            ItemStack heldItem = playerIn.func_184614_ca();
            if (heldItem.func_190926_b()) {
                heart.showGui(playerIn, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                return true;
            }
            if (heldItem.func_77973_b() instanceof IValidateTool) {
                IValidateTool tool = (IValidateTool)heldItem.func_77973_b();
                if (tool.isValidateTier(heldItem)) {
                    EnumMobFactoryTier tier = ValidateToolUtils.getModeFromNbt(heldItem).getTierFromMode();
                    if (tier != null) {
                        heart.manualFarmScan(playerIn, tier);
                    }
                } else if (tool.isValidateExport(heldItem)) {
                    heart.outputFarmScan(playerIn);
                } else if (tool.isValidateImport(heldItem)) {
                    heart.inputFarmScan(playerIn);
                }
                return true;
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public static class PluginTooltipInfo {
        private PluginTooltipInfo() {
        }
    }
}

