/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.wireless.handling;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ListenableList;
import sonar.core.listener.ListenerTally;
import sonar.core.listener.PlayerListener;
import sonar.logistics.api.core.tiles.wireless.EnumWirelessSecurity;
import sonar.logistics.api.core.tiles.wireless.IWirelessManager;
import sonar.logistics.api.core.tiles.wireless.emitters.ClientWirelessEmitter;
import sonar.logistics.api.core.tiles.wireless.emitters.IWirelessEmitter;
import sonar.logistics.api.core.tiles.wireless.receivers.IWirelessReceiver;
import sonar.logistics.core.tiles.displays.info.InfoPacketHelper;

public abstract class AbstractWirelessManager<N, E extends IWirelessEmitter, R extends IWirelessReceiver>
implements IWirelessManager<E, R> {
    public List<E> emitters = new ArrayList();
    public List<R> receivers = new ArrayList<R>();
    public ListenableList<PlayerListener> player_viewers = new ListenableList((ISonarListenable)this, 1);
    protected boolean dirty;

    public void removeAll() {
        this.emitters.clear();
        this.receivers.clear();
        this.player_viewers.invalidateList();
    }

    public abstract void onReceiverConnected(N var1, R var2);

    public abstract void onReceiverDisconnected(N var1, R var2);

    public void connectReceiver(N network, R receiver) {
        if (!this.receivers.contains(receiver)) {
            this.receivers.add(receiver);
            this.onReceiverConnected(network, receiver);
        }
    }

    public void disconnectReceiver(N network, R receiver) {
        if (this.receivers.remove(receiver)) {
            this.onReceiverDisconnected(network, receiver);
        }
    }

    public void connectEmitter(N network, E emitter) {
        if (!this.emitters.contains(emitter)) {
            this.emitters.add(emitter);
            this.onEmitterConnected(network, emitter);
        }
    }

    public void disconnectEmitter(N network, E emitter) {
        if (this.emitters.remove(emitter)) {
            this.onEmitterDisconnected(network, emitter);
        }
    }

    public void onEmitterConnected(N network, E emitter) {
        this.receivers.forEach(receiver -> {
            if (receiver.canAccess(emitter).isConnected()) {
                receiver.onEmitterConnected(emitter);
            }
        });
    }

    public void onEmitterDisconnected(N network, E emitter) {
        this.receivers.forEach(receiver -> {
            if (receiver.canAccess(emitter).isConnected()) {
                receiver.onEmitterDisconnected(emitter);
            }
        });
    }

    @Override
    public void onEmitterSecurityChanged(E emitter, EnumWirelessSecurity oldSetting) {
        this.receivers.forEach(receiver -> {
            if (receiver.canEmitterAccessReceiver(emitter).isConnected()) {
                receiver.onEmitterSecurityChanged(emitter, oldSetting);
            }
        });
        this.dirty = true;
    }

    public List<E> getEmitters(UUID uuid) {
        ArrayList<IWirelessEmitter> list = new ArrayList<IWirelessEmitter>();
        for (IWirelessEmitter emitter : this.emitters) {
            if (!emitter.canPlayerConnect(uuid).isConnected()) continue;
            list.add(emitter);
        }
        return list;
    }

    @Override
    public E getEmitter(int identity) {
        for (IWirelessEmitter e : this.emitters) {
            if (e.getIdentity() != identity) continue;
            return (E)e;
        }
        return null;
    }

    @Override
    public R getReceiver(int identity) {
        for (IWirelessReceiver r : this.receivers) {
            if (r.getIdentity() != identity) continue;
            return (R)r;
        }
        return null;
    }

    public void sendDataEmittersToListeners() {
        if (this.dirty) {
            this.player_viewers.listener_tallies.forEach(player -> InfoPacketHelper.sendEmittersToPlayer((EntityPlayer)((PlayerListener)player.listener).player, this));
            this.dirty = false;
        }
    }

    @Override
    public void addViewer(EntityPlayer player) {
        this.player_viewers.addListener(player, new int[]{0});
    }

    @Override
    public void removeViewer(EntityPlayer player) {
        this.player_viewers.removeListener(player, true, new int[]{0});
    }

    public ArrayList<ClientWirelessEmitter> getClientEmitters(EntityPlayer player) {
        List<E> emitters = this.getEmitters(player.func_146103_bH().getId());
        ArrayList<ClientWirelessEmitter> clientEmitters = new ArrayList<ClientWirelessEmitter>();
        for (IWirelessEmitter emitter : emitters) {
            clientEmitters.add(new ClientWirelessEmitter(emitter));
        }
        return clientEmitters;
    }

    public boolean isValid() {
        return true;
    }

    public ListenableList<PlayerListener> getListenerList() {
        return this.player_viewers;
    }

    public void onListenerAdded(ListenerTally<PlayerListener> tally) {
        InfoPacketHelper.sendEmittersToPlayer((EntityPlayer)((PlayerListener)tally.listener).player, this);
    }

    public void onListenerRemoved(ListenerTally<PlayerListener> tally) {
    }

    public void onSubListenableAdded(ISonarListenable<PlayerListener> listen) {
    }

    public void onSubListenableRemoved(ISonarListenable<PlayerListener> listen) {
    }
}

