/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.wireless.base;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.core.tiles.wireless.EnumWirelessConnectionType;
import sonar.logistics.api.core.tiles.wireless.emitters.ClientWirelessEmitter;
import sonar.logistics.base.ClientInfoHandler;

public class PacketClientEmitters
implements IMessage {
    public EnumWirelessConnectionType type;
    public List<ClientWirelessEmitter> emitters;

    public PacketClientEmitters() {
    }

    public PacketClientEmitters(EnumWirelessConnectionType type, List<ClientWirelessEmitter> emitters) {
        this.type = type;
        this.emitters = emitters;
    }

    public void fromBytes(ByteBuf buf) {
        this.type = EnumWirelessConnectionType.values()[buf.readInt()];
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.emitters = new ArrayList<ClientWirelessEmitter>();
        if (tag.func_74764_b("emitters")) {
            NBTTagList tagList = tag.func_150295_c("emitters", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                this.emitters.add((ClientWirelessEmitter)NBTHelper.instanceNBTSyncable(ClientWirelessEmitter.class, (NBTTagCompound)tagList.func_150305_b(i)));
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.type.ordinal());
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagList tagList = new NBTTagList();
        this.emitters.forEach(emitter -> tagList.func_74742_a((NBTBase)emitter.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE)));
        if (!tagList.func_82582_d()) {
            tag.func_74782_a("emitters", (NBTBase)tagList);
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    public static class Handler
    implements IMessageHandler<PacketClientEmitters, IMessage> {
        public IMessage onMessage(PacketClientEmitters message, MessageContext ctx) {
            SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                switch (message.type) {
                    case DATA: {
                        ClientInfoHandler.instance().clientDataEmitters = message.emitters;
                        break;
                    }
                    case REDSTONE: {
                        ClientInfoHandler.instance().clientRedstoneEmitters = message.emitters;
                        break;
                    }
                }
            });
            return null;
        }
    }
}

