/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.items.handling;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.utils.Pair;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.readers.IListReader;
import sonar.logistics.api.core.tiles.readers.channels.INetworkListHandler;
import sonar.logistics.base.channels.handling.ListNetworkChannels;
import sonar.logistics.base.listeners.ListenerType;
import sonar.logistics.core.tiles.displays.info.InfoPacketHelper;
import sonar.logistics.core.tiles.displays.info.types.items.ItemChangeableList;
import sonar.logistics.core.tiles.displays.info.types.items.MonitoredItemStack;
import sonar.logistics.core.tiles.readers.items.handling.ItemNetworkHandler;

public class ItemNetworkChannels
extends ListNetworkChannels<MonitoredItemStack, INetworkListHandler<MonitoredItemStack, ItemChangeableList>> {
    public boolean updateLargeInventory = false;
    public List<ItemStack> forRapidUpdate = new ArrayList<ItemStack>();

    public ItemNetworkChannels(ILogisticsNetwork network) {
        super(ItemNetworkHandler.INSTANCE, network);
    }

    public boolean updateLargeInventory() {
        return this.updateLargeInventory;
    }

    @Override
    public void updateChannel() {
        if (this.forRapidUpdate.isEmpty()) {
            super.updateChannel();
        } else {
            this.performRapidUpdates();
        }
    }

    @Override
    public void updateTickLists() {
        super.updateTickLists();
        this.updateLargeInventory = false;
        for (IListReader reader : this.readers) {
            if (reader.getListenerList().getAllListeners(ListenerType.NEW_GUI_LISTENER, ListenerType.NEW_DISPLAY_LISTENER, ListenerType.TEMPORARY_LISTENER).isEmpty()) continue;
            this.updateLargeInventory = true;
            break;
        }
    }

    public void performRapidUpdates() {
        this.updateAllChannels();
        for (IListReader reader : this.readers) {
            Pair updateList = this.handler.updateAndSendList(this.network, reader, this.channels, false);
            InfoPacketHelper.sendRapidItemUpdate(reader, (InfoUUID)updateList.a, (ItemChangeableList)updateList.b, this.forRapidUpdate);
        }
        this.forRapidUpdate.clear();
    }

    public void createRapidItemUpdate(List<ItemStack> items) {
        block0: for (ItemStack stack : items) {
            for (ItemStack stored : this.forRapidUpdate) {
                if (!StoredItemStack.isEqualStack((ItemStack)stored, (ItemStack)stack)) continue;
                continue block0;
            }
            this.forRapidUpdate.add(stack.func_77946_l());
        }
    }

    @Override
    public void sendFullRapidUpdate() {
        this.updateLargeInventory = true;
        super.sendFullRapidUpdate();
        this.updateLargeInventory = false;
    }

    @Override
    public void sendLocalRapidUpdate(IListReader<MonitoredItemStack> reader, EntityPlayer viewer) {
        this.updateLargeInventory = true;
        super.sendLocalRapidUpdate(reader, viewer);
        this.updateLargeInventory = false;
    }
}

