/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.items;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.api.StorageSize;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.handlers.inventories.SonarInventory;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncEnum;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.utils.IByteBufTile;
import sonar.core.utils.SortingDirection;
import sonar.logistics.api.core.tiles.displays.info.INameableInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.api.core.tiles.displays.info.register.RegistryType;
import sonar.logistics.api.core.tiles.nodes.NodeTransferMode;
import sonar.logistics.api.core.tiles.readers.ILogicListSorter;
import sonar.logistics.api.core.tiles.readers.channels.INetworkHandler;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.base.channels.BlockConnection;
import sonar.logistics.base.channels.ChannelType;
import sonar.logistics.base.channels.ContainerChannelSelection;
import sonar.logistics.base.channels.EntityConnection;
import sonar.logistics.base.channels.GuiChannelSelection;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.filters.ContainerFilterList;
import sonar.logistics.base.filters.GuiFilterList;
import sonar.logistics.base.filters.IFilteredTile;
import sonar.logistics.base.guidance.errors.ErrorMessage;
import sonar.logistics.base.listeners.ListenerType;
import sonar.logistics.core.tiles.displays.info.types.InfoError;
import sonar.logistics.core.tiles.displays.info.types.LogicInfoList;
import sonar.logistics.core.tiles.displays.info.types.general.LogicInfo;
import sonar.logistics.core.tiles.displays.info.types.items.ItemChangeableList;
import sonar.logistics.core.tiles.displays.info.types.items.MonitoredItemStack;
import sonar.logistics.core.tiles.displays.info.types.progress.InfoProgressBar;
import sonar.logistics.core.tiles.readers.base.TileAbstractListReader;
import sonar.logistics.core.tiles.readers.items.ContainerInventoryReader;
import sonar.logistics.core.tiles.readers.items.GuiInventoryReader;
import sonar.logistics.core.tiles.readers.items.InventoryReader;
import sonar.logistics.core.tiles.readers.items.InventorySorter;
import sonar.logistics.core.tiles.readers.items.handling.ItemHelper;
import sonar.logistics.core.tiles.readers.items.handling.ItemNetworkChannels;
import sonar.logistics.core.tiles.readers.items.handling.ItemNetworkHandler;
import sonar.logistics.network.sync.SyncFilterList;

public class TileInventoryReader
extends TileAbstractListReader<MonitoredItemStack>
implements IByteBufTile,
IFilteredTile {
    public static final ErrorMessage[] validStates = new ErrorMessage[]{ErrorMessage.NO_NETWORK, ErrorMessage.NO_STACK_SELECTED};
    public SonarInventory inventory = new SonarInventory(1);
    public SyncEnum<InventoryReader.Modes> setting = (SyncEnum)new SyncEnum((Enum[])InventoryReader.Modes.values(), 2).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncTagType.INT targetSlot = (SyncTagType.INT)new SyncTagType.INT(3).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncTagType.INT posSlot = (SyncTagType.INT)new SyncTagType.INT(4).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncEnum<SortingDirection> sortingOrder = (SyncEnum)new SyncEnum((Enum[])SortingDirection.values(), 5).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncEnum<InventoryReader.SortingType> sortingType = (SyncEnum)new SyncEnum((Enum[])InventoryReader.SortingType.values(), 6).addSyncType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SPECIAL});
    public SyncFilterList filters = new SyncFilterList(9);
    public InventorySorter inventory_sorter = new InventorySorter(){

        @Override
        public SortingDirection getDirection() {
            return (SortingDirection)TileInventoryReader.this.sortingOrder.getObject();
        }

        @Override
        public InventoryReader.SortingType getType() {
            return (InventoryReader.SortingType)TileInventoryReader.this.sortingType.getObject();
        }
    };
    public boolean sorting_changed = true;

    public TileInventoryReader() {
        this.syncList.addParts(new IDirtyPart[]{this.inventory, this.setting, this.targetSlot, this.posSlot, this.sortingOrder, this.sortingType, this.filters});
    }

    @Override
    public List<INetworkHandler> addValidHandlers(List<INetworkHandler> handlers) {
        handlers.add(ItemNetworkHandler.INSTANCE);
        return handlers;
    }

    @Override
    public int getMaxInfo() {
        return 1;
    }

    @Override
    public AbstractChangeableList<MonitoredItemStack> getViewableList(AbstractChangeableList<MonitoredItemStack> updateList, InfoUUID uuid, Map<NodeConnection, AbstractChangeableList<MonitoredItemStack>> channels, List<NodeConnection> usedChannels) {
        if (updateList instanceof ItemChangeableList) {
            channels.values().forEach(list -> {
                if (list instanceof ItemChangeableList) {
                    ((ItemChangeableList)updateList).sizing.add(((ItemChangeableList)list).sizing);
                }
            });
        }
        return super.getViewableList(updateList, uuid, channels, usedChannels);
    }

    @Override
    public AbstractChangeableList<MonitoredItemStack> sortMonitoredList(AbstractChangeableList<MonitoredItemStack> updateInfo, int channelID) {
        return this.inventory_sorter.sortSaveableList(updateInfo);
    }

    @Override
    public boolean canMonitorInfo(IMonitoredValue<MonitoredItemStack> info, InfoUUID uuid, Map<NodeConnection, AbstractChangeableList<MonitoredItemStack>> channels, List<NodeConnection> usedChannels) {
        if (this.setting.getObject() == InventoryReader.Modes.FILTERED) {
            return this.filters.matches(info.getSaveableInfo().getStoredStack().getFullStack(), NodeTransferMode.ADD_REMOVE);
        }
        return true;
    }

    @Override
    public void setMonitoredInfo(AbstractChangeableList<MonitoredItemStack> updateInfo, List<NodeConnection> usedChannels, InfoUUID uuid) {
        INameableInfo<InfoError> info = null;
        switch ((InventoryReader.Modes)this.setting.getObject()) {
            case INVENTORIES: 
            case FILTERED: {
                LogicInfoList list = new LogicInfoList(this.getIdentity(), "items", this.getNetworkID());
                list.listSorter = this.inventory_sorter;
                info = list;
                break;
            }
            case POS: {
                int pos = (Integer)this.posSlot.getObject();
                if (pos >= updateInfo.getValueCount()) break;
                MonitoredItemStack posItem = updateInfo.getActualValue(pos).copy();
                posItem.setNetworkSource(this.network.getNetworkID());
                info = posItem;
                break;
            }
            case SLOT: {
                NodeConnection connection;
                StoredItemStack slotStack = null;
                if (!usedChannels.isEmpty() && (connection = usedChannels.get(0)) != null) {
                    if (connection instanceof BlockConnection) {
                        slotStack = ItemHelper.getTileStack((BlockConnection)connection, (Integer)this.targetSlot.getObject());
                    }
                    if (connection instanceof EntityConnection) {
                        slotStack = ItemHelper.getEntityStack((EntityConnection)connection, (Integer)this.targetSlot.getObject());
                    }
                }
                if (slotStack == null) break;
                MonitoredItemStack newInfo = new MonitoredItemStack(slotStack);
                newInfo.setNetworkSource(this.network.getNetworkID());
                info = newInfo;
                break;
            }
            case STACK: {
                ItemStack stack = this.inventory.getStackInSlot(0);
                if (!stack.func_190926_b()) {
                    MonitoredItemStack dummyInfo = new MonitoredItemStack(new StoredItemStack(stack.func_77946_l(), 0L), this.network.getNetworkID());
                    IMonitoredValue<MonitoredItemStack> value = updateInfo.find(dummyInfo);
                    info = value == null ? dummyInfo : new MonitoredItemStack(value.getSaveableInfo().getStoredStack().copy(), this.network.getNetworkID());
                    break;
                }
                info = new InfoError("NO ITEM SELECTED");
                break;
            }
            case STORAGE: {
                StorageSize size = updateInfo instanceof ItemChangeableList ? ((ItemChangeableList)updateInfo).sizing : new StorageSize(0L, 0L);
                info = new InfoProgressBar(LogicInfo.buildDirectInfo("items.storage", RegistryType.TILE, size.getStored()), LogicInfo.buildDirectInfo("max", RegistryType.TILE, size.getMaxStored()));
                break;
            }
        }
        ServerInfoHandler.instance().changeInfo(this, uuid, info);
        if (this.sorting_changed) {
            ServerInfoHandler.instance().markChanged(this, uuid);
            this.sorting_changed = false;
        }
    }

    @Override
    public ChannelType channelType() {
        return ChannelType.UNLIMITED;
    }

    @Override
    public void writePacket(ByteBuf buf, int id) {
        super.writePacket(buf, id);
    }

    @Override
    public void readPacket(ByteBuf buf, int id) {
        ItemNetworkChannels list;
        super.readPacket(buf, id);
        if (id == this.sortingOrder.id || id == this.sortingType.id) {
            this.sorting_changed = true;
        }
        if ((id == 5 || id == 6) && (list = this.network.getNetworkChannels(ItemNetworkChannels.class)) != null) {
            List players = this.listeners.getListeners(new Enum[]{ListenerType.OLD_GUI_LISTENER});
            players.forEach(player -> list.sendLocalRapidUpdate(this, (EntityPlayer)player.player));
        }
    }

    public Object getServerElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new ContainerInventoryReader(this, player);
            }
            case 1: {
                return new ContainerChannelSelection(this);
            }
            case 2: {
                return new ContainerFilterList(player, this);
            }
        }
        return null;
    }

    public Object getClientElement(Object obj, int id, World world, EntityPlayer player, NBTTagCompound tag) {
        switch (id) {
            case 0: {
                return new GuiInventoryReader(this, player);
            }
            case 1: {
                return new GuiChannelSelection(player, this, 0);
            }
            case 2: {
                return new GuiFilterList(player, this, 0);
            }
        }
        return null;
    }

    @Override
    public SyncFilterList getFilters() {
        return this.filters;
    }

    @Override
    public Predicate<ItemStack> getFilter() {
        return s -> this.filters.matches((ItemStack)s, NodeTransferMode.ADD_REMOVE);
    }

    @Override
    public ErrorMessage[] getValidMessages() {
        return validStates;
    }

    @Override
    public ILogicListSorter getSorter() {
        return this.inventory_sorter;
    }
}

