/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.base;

import javax.annotation.Nonnull;
import mcmultipart.api.container.IPartInfo;
import mcmultipart.api.slot.EnumFaceSlot;
import mcmultipart.api.slot.IPartSlot;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import sonar.core.common.block.properties.SonarProperties;
import sonar.core.integration.multipart.SonarMultipartHelper;
import sonar.core.integration.multipart.TileSonarMultipart;
import sonar.logistics.PL2Multiparts;
import sonar.logistics.PL2Properties;
import sonar.logistics.api.core.tiles.displays.tiles.IDisplay;
import sonar.logistics.core.tiles.base.BlockLogisticsSided;
import sonar.logistics.core.tiles.readers.base.TileAbstractReader;

public class BlockAbstractReader
extends BlockLogisticsSided {
    public BlockAbstractReader(PL2Multiparts multipart) {
        super(multipart);
    }

    @Override
    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176203_a(facing.ordinal()).func_177226_a((IProperty)PL2Properties.HASDISPLAY, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public IPartSlot getSlotForPlacement(World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, EntityLivingBase placer) {
        return EnumFaceSlot.fromFace((EnumFacing)facing);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)SonarProperties.ORIENTATION, (Comparable)EnumFacing.field_82609_l[meta]).func_177226_a((IProperty)PL2Properties.HASDISPLAY, (Comparable)Boolean.valueOf(false));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SonarProperties.ORIENTATION, PL2Properties.HASDISPLAY});
    }

    public void onPartAdded(IPartInfo part, IPartInfo otherPart) {
        if (otherPart.getTile() instanceof IDisplay && part.getTile() instanceof TileAbstractReader) {
            this.onScreenChanged((TileAbstractReader)part.getTile(), (IDisplay)otherPart.getTile(), true);
        }
    }

    public void onPartRemoved(IPartInfo part, IPartInfo otherPart) {
        if (otherPart.getTile() instanceof IDisplay && part.getTile() instanceof TileAbstractReader) {
            this.onScreenChanged((TileAbstractReader)part.getTile(), (IDisplay)otherPart.getTile(), false);
        }
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176221_a(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean hasDisplay = false;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileAbstractReader) {
            hasDisplay = (Boolean)((TileAbstractReader)tile).hasMonitor.getObject();
        }
        return state.func_177226_a((IProperty)PL2Properties.HASDISPLAY, (Comparable)Boolean.valueOf(hasDisplay));
    }

    public void onScreenChanged(TileAbstractReader reader, IDisplay screen, boolean valid) {
        if (screen.getCableFace() == reader.getCableFace()) {
            reader.hasMonitor.setObject((Object)valid);
            SonarMultipartHelper.sendMultipartUpdateSyncAround((TileSonarMultipart)reader, (int)128);
        }
    }
}

